@extends('layouts.master')
@section('content')
    <style>
        @import url('https://fonts.googleapis.com/css?family=Assistant');

        body {
            font-family: Assistant, sans-serif;
        }

        .cell-1 {
            border-collapse: separate;
            border-spacing: 0 4em;
            border-bottom: 5px solid transparent;
            background-clip: padding-box;
            cursor: pointer;
        }

        .table-elipse {
            cursor: pointer;
        }
    </style>

    <div class="az-content-breadcrumb">
        <span>Departments</span>
    </div>

    <h2 class="az-content-title" style="display: inline">
        Departments List
        <span>
            <a href="{{ url('departments/create') }}" class="btn btn-az-primary" style="float: right">
                <i class="fa-solid fa-plus"></i> Add Department
            </a>
        </span>
    </h2>

    <div class="row">
        <div class="col-md-12">
            <div class="card card-body pd-20">
                <table id="departmentsTable" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Code</th>
                            <th>Description</th>
                            <th>Status</th>
                            <th>Created</th>
                            <th>Updated</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($departments as $department)
                            <tr>
                                <td>{{ $department->name }}</td>
                                <td>{{ $department->code ?? '-' }}</td>
                                <td>{{ $department->description ?? '-' }}</td>
                                <td>
                                    @if ($department->status == 'active')
                                        <span class="btn btn-success btn-sm">Active</span>
                                    @else
                                        <span class="btn btn-danger btn-sm">Inactive</span>
                                    @endif
                                </td>
                                <td>{{ $department->created_at->format('d-m-Y') }}</td>
                                <td>{{ $department->updated_at->format('d-m-Y') }}</td>
                                <td>
                                    <a href="{{ url('departments/edit/' . Crypt::encrypt($department->id)) }}"
                                        class="btn btn-primary btn-sm">
                                        <i class="fa-regular fa-pen-to-square"></i> Edit
                                    </a>
                                    <a href="{{ url('departments/delete/' . Crypt::encrypt($department->id)) }}"
                                        class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">
                                        <i class="fa-solid fa-trash"></i> Delete
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                            <th>Name</th>
                            <th>Code</th>
                            <th>Description</th>
                            <th>Status</th>
                            <th>Created</th>
                            <th>Updated</th>
                            <th>Action</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $(document).ready(function() {
            $('#departmentsTable').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'csv',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: ':not(:last-child)'
                        }
                    },
                    {
                        extend: 'excel',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: ':not(:last-child)'
                        }
                    },
                    {
                        extend: 'pdf',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: ':not(:last-child)'
                        }
                    },
                    {
                        extend: 'print',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: ':not(:last-child)'
                        }
                    }
                ],
                responsive: true
            });
        });
    </script>
@endpush
