<!DOCTYPE html>
<html>

<head>
    <title>Receivables - Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
        }

        .container {
            width: 95%;
            margin: auto;
        }

        h2,
        p {
            text-align: center;
        }

        /* 2 Columns */
        .columns {
            display: flex;
            gap: 20px;
        }

        .col {
            width: 50%;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
        }

        th,
        td {
            padding: 6px;
            border: 2px solid black;
            text-align: right;
        }

        .no-print {
            margin-top: 20px;
        }

        @media print {
            .no-print {
                display: none;
            }
        }
    </style>
</head>

<body>
    <div class="container">
        <h2>M.D.S</h2>
        <p>Receivables &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; وصولی ادھاری</p>
        <p>As At {{ date('M d , y') }}</p>

        @php
            $half = ceil($sales->count() / 2);
            $secondPart = $sales->slice(0,$half);
            $firstPart = $sales->slice( $half);
        @endphp

        <div class="columns">

            <!-- LEFT SIDE -->
            <div class="col">
                <table>
                    <thead>
                        <tr>
                            <th>وصولی</th>
                            <th>فروخت وغیرہ</th>
                            <th>سابِقہ بیلنس</th>
                            <th>پارٹی</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($firstPart as $sale)
                            <tr>
                                <td>{{ number_format($sale->today_balance, 0) ?? '-' }}</td>
                                <td>{{ number_format($sale->yesterday_balance, 0) ?? '-' }}</td>
                                <td>{{ number_format($sale->total_balance, 0) }}</td>
                                <td>{{ $sale->customer?->customer_name_urdu }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <!-- RIGHT SIDE -->
            <div class="col">
                <table>
                    <thead>
                        <tr>
                            <th>وصولی</th>
                            <th>فروخت وغیرہ</th>
                            <th>سابِقہ بیلنس</th>
                            <th>پارٹی</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($secondPart as $sale)
                            <tr>
                                <td>{{ number_format($sale->today_balance, 0) ?? '-' }}</td>
                                <td>{{ number_format($sale->yesterday_balance, 0) ?? '-' }}</td>
                                <td>{{ number_format($sale->total_balance, 0) }}</td>
                                <td>{{ $sale->customer?->customer_name_urdu }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

        </div>

        <button class="no-print" onclick="window.print()">Print</button>
    </div>

</body>

</html>
