<?php

namespace App;

//use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BChequeDetail extends Model
{
    //    use HasFactory;

    protected $table = 'b_cheque_details';
    protected $primaryKey = 'id_b_cheque_details';

    protected $fillable = [
        'b_cheque_id',
        'rent_recieve_amount',
        'labour_amount',
        'total_katta',
        'total_bori_mazdori',
        'labour_katta_amount',
        'market_fees_amount',
        'post_expense_amount',
        'miscellaneous_expense_amount',
        'cash_amount',
        'commission_rate',
        'commission_amount',
        'else_more_amount',
        'payment_details',
        'total_bori',
        'total_weight',
        'total_amount',
        'total_expanse_amount',
        'save_amount',
        'created_by'
    ];
    protected $casts = [
        'rent_recieve_amount'        => 'float',
        'labour_amount'              => 'float',
        'market_fees_amount'         => 'float',
        'post_expense_amount'        => 'float',
        'miscellaneous_expense_amount' => 'float',
        'cash_amount'                => 'float',
        'commission_amount'          => 'float',
        'total_expanse_amount'       => 'float',
    ];
    public function bCheque()
    {
        return $this->belongsTo(BCheque::class, 'b_cheque_id', 'id_b_cheque');
    }
}
