<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Employees extends Model
{
    protected $table = 'employees';
    protected $primaryKey = 'id';
    // Fillable fields for mass assignment
    protected $fillable = [
        'user_id',
        'employee_no',
        'first_name',
        'last_name',
        'dob',
        'gender',
        'phone',
        'email',
        'department_id',
        'designation_id',
        'joining_date',
        'basic_salary',
        'status',
        'created_by',
    ];

    // Casts for date and numeric fields
    protected $casts = [
        'dob' => 'date',
        'joining_date' => 'date',
        'basic_salary' => 'decimal:2',
    ];

    public function department()
    {
        return $this->belongsTo(Departments::class, 'department_id', 'id');
    }

    public function attendances()
    {
        return $this->hasMany(EmployeeAttendance::class, 'employee_id', 'id');
    }
    public function designation()
    {
        return $this->belongsTo(Designations::class, 'designation_id', 'id');
    }


    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
