<?php

namespace App\Http\Controllers;

use App\NotificationManagement;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class NotificationManagementController extends Controller
{
    protected string $module = 'Notification Management';

    public function __construct()
    {
        $module = $this->module;

        $this->middleware("permission:$module list")->only(['index']);
        $this->middleware("permission:$module view")->only(['show']);
        $this->middleware("permission:$module add")->only(['create', 'store']);
        $this->middleware("permission:$module edit")->only(['edit', 'update']);
        $this->middleware("permission:$module delete")->only(['destroy']);
    }
    public function index()
    {
        $notification = NotificationManagement::all();
        return view('notification_management.index', compact('notification'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $notification = NotificationManagement::all();
        return view('notification_management.create', compact('notification'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    // public function store(Request $request)
    // {
    //     $store = new NotificationManagement();
    //     $store->discount_name = $request->discount_name;
    //     $store->discount_type = $request->discount_type;
    //     $store->discount_for = $request->discount_for;
    //     $store->discount_price = $request->discount_price;

    //     // dd($store);
    //     $store->discount_status = "1";
    //     $store->created_by = auth()->user()->id;
    //     // dd($store);
    //     $store->save();
    //     session()->flash('success', "New Discounted Added Successfully");

    //     return redirect('discounts');
    // }

    /**
     * Display the specified resource.
     *
     * @param  \App\NotificationManagement  $notificationManagement
     * @return \Illuminate\Http\Response
     */
    // public function show(NotificationManagement $notificationManagement)
    // {
    //     //
    // }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\NotificationManagement  $notificationManagement
     * @return \Illuminate\Http\Response
     */
    // public function edit($id)
    // {
    //     $dec_id = \Crypt::decrypt($id);
    //     $edit =NotificationManagement::where('id_discounts' , $dec_id)->first();
    //     // $edit = currency_exchange_rate::all();

    //     return view('discounts.edit' , compact('edit'));
    // }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\NotificationManagement  $notificationManagement
     * @return \Illuminate\Http\Response
     */
    // public function update(Request $request,$id)
    // {
    //     $dec_id = \Crypt::decrypt($id);
    //     $update = NotificationManagement::where('id_discounts' , $dec_id)->first();
    //     $update->discount_name = $request->discount_name;
    //     $update->discount_type = $request->discount_type;
    //     $update->discount_for = $request->discount_for;
    //     $update->discount_price = $request->discount_price;

    //     // dd($store);
    //     $update->discount_status = "1";
    //     $update->created_by = auth()->user()->id;

    //     $update->save();
    //     session()->flash('success', " Discounted Updated Successfully");

    //     return redirect('discounts');
    // }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\NotificationManagement  $notificationManagement
     * @return \Illuminate\Http\Response
     */
    // public function destroy(NotificationManagement $notificationManagement,$id)
    // {  $dec_id = \Crypt::decrypt($id);
    //     NotificationManagement::find($dec_id)->delete();
    //     return redirect()->back();
    // }

}
