<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductsSubCategory extends Model
{
    protected $table = 'products_sub_cat';
    protected $primaryKey = 'id_pro_sub_cat';
    protected $fillable = [
        'products_category_id',
        'sub_sub_pro_cat_id',
        'name',
        'name_urdu',
        'prime',
        'status',
        'created_by',
    ];
    
    public function category()
    {
        return $this->belongsTo(ProductsCategory::class, 'products_category_id', 'id_products_category');
    }

    public function subCategoryParent()
    {
        return $this->belongsTo(ProductsCategory::class, 'sub_sub_pro_cat_id', 'id_products_category');
    }
}
