<?php
namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PurchaseOrderDetails extends Model
{
    use HasFactory;

    // Define the table associated with the model
    protected $table = 'purchase_order_details';

    // Define the primary key
    protected $primaryKey = 'id';

    // Define the fillable attributes
   protected $fillable = [
        'pro_cate_main_id', 'pro_cate_parent_id','pro_cate_child_id','name','marka',
        'bori',
        'weight',
        'rate',
        'amount',
        'purchase_order_id',
        'created_by'
        ,
    ];

    /**
     * Relationship: Purchase Order Details belong to a Purchase Order
     */
    public function purchaseOrder()
    {
        return $this->belongsTo(PurchaseOrder::class, 'purchase_order_id', 'id_purchase_order');
    }
    public function proCateChild()
    {
        return $this->belongsTo(ProductsSubCategoryChild::class, 'pro_cate_child_id', 'id_pro_sub_cat_child');
    }


}
