<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ServiceVoucher extends Model
{


     protected $fillable = [
        'voucher_no',
        'voucher_date',
        'truck_no',
        'bill_no',
        'total_amount',
        'supplier_id',
        'description'
    ];

    public function details()
    {
        return $this->hasMany(ServiceVoucherDetail::class);
    }
    public function supplier()
    {
        return $this->belongsTo(Suppliers::class,'supplier_id','id_supplier');
    }
}
