<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ServiceVoucherDetail extends Model
{
    use HasFactory;
    protected $fillable = [
        'service_voucher_id',
        'control_account_id',
        'qty',
        'unit',
        'price',
        'amount',
        'narration'
    ];

    public function voucher()
    {
        return $this->belongsTo(ServiceVoucher::class);
    }
    public function controlAccount()
    {
        return $this->belongsTo(ControlAccount::class,'control_account_id','id_control_account');
    }
}
