@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>User Management</span>
        <span>Edit User</span>
    </div>

    <h2 class="az-content-title" style="display: inline">
        Edit User
        <span>
            <a href="{{ url('users') }}" class="btn border" style="float: right">
                <i class="fa-solid fa-bars-staggered"></i> Back to Users
            </a>
        </span>
    </h2>

    <div class="separator-breadcrumb border-top"></div>

    <div class="row">
        <div class="col-md-12">
            <div class="card card-body pd-40">
                <h5 class="card-title mg-b-20">Edit User Details</h5>

                {{-- Alerts --}}
                @if (Session('alert'))
                    <div class="alert alert-card alert-{{ Session('alert-class') }}" role="alert">
                        {{ Session('alert') }}
                        <button class="close" type="button" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif

                {{-- Validation Errors --}}
                @if ($errors->any())
                    <div class="p-1">
                        @foreach ($errors->all() as $error)
                            <div class="alert alert-warning alert-danger fade show" role="alert">
                                {{ $error }}
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                        @endforeach
                    </div>
                @endif

                {{-- Form --}}
                <form action="{{ url('users/update/' . Crypt::encrypt($user->id)) }}" method="post" enctype="multipart/form-data">
                    @csrf
                    @method('post')

                    {{-- Checkbox: Link to employee --}}
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <div class="form-group form-check form-switch">
                                <input type="checkbox" class="form-check-input" id="create_employee" name="create_employee" {{ $user->employee_id ? 'checked' : '' }}>
                                <label class="form-check-label" for="create_employee">
                                    Create user for an existing employee
                                </label>
                            </div>
                        </div>
                    </div>

                    {{-- Employee Select --}}
                    <div class="row mb-3">
                        <div class="col-md-4" id="employee_select_div" style="display: {{ $user->employee_id ? 'block' : 'none' }};">
                            <div class="form-group">
                                <label for="employee_id">Select Employee</label>
                                <select id="employee_id" name="employee_id" class="form-control">
                                    <option value="">Select Employee</option>
                                    @foreach ($employees as $employee)
                                        <option
                                            value="{{ $employee->id }}"
                                            data-name="{{ $employee->first_name.' '.$employee->last_name }}"
                                            data-email="{{ $employee->email }}"
                                            {{ $user->employee_id == $employee->id ? 'selected' : '' }}
                                        >
                                            {{ $employee->first_name.' '.$employee->last_name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>

                    {{-- User Name, Email, Role, Status --}}
                    <div class="row mb-3">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Full Name <span style="color:red;">*</span></label>
                                <input name="name" id="name" class="form-control" value="{{ old('name', $user->name) }}" />
                                @error('name')
                                    <span class="form-text text-muted"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600" for="email">Email <span style="color:red;">*</span></label>
                                <input name="email" id="email" class="form-control" value="{{ old('email', $user->email) }}" />
                                @error('email')
                                    <span class="form-text text-muted"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600" for="role_id">Role <span style="color:red;">*</span></label>
                                <select id="role_id" name="role_id" class="form-control">
                                    <option value="">Select</option>
                                    @foreach ($roles as $role)
                                        <option value="{{ $role['id'] }}" {{ old('role_id', $user->role_id) == $role['id'] ? 'selected' : '' }}>
                                            {{ $role['name'] }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('role_id')
                                    <span class="form-text text-muted"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600" for="status">Status <span style="color:red;">*</span></label>
                                <select name="status" id="status" class="form-control">
                                    <option value="1" {{ old('status', $user->status) == '1' ? 'selected' : '' }}>Active</option>
                                    <option value="2" {{ old('status', $user->status) == '2' ? 'selected' : '' }}>Inactive</option>
                                </select>
                                @error('status')
                                    <span class="form-text text-muted"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>
                        </div>
                    </div>

                    {{-- Password --}}
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600" for="password">Password</label>
                                <input type="password" name="password" id="password" class="form-control" placeholder="Leave blank to keep current password" />
                                @error('password')
                                    <span class="form-text text-muted"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600" for="password_confirmation">Confirm Password</label>
                                <input type="password" name="password_confirmation" id="password_confirmation" class="form-control" placeholder="Leave blank to keep current password" />
                                @error('password_confirmation')
                                    <span class="form-text text-muted"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>
                        </div>
                    </div>

                    {{-- Buttons --}}
                    <div class="row mt-3">
                        <div class="col-md-6">
                            <a href="{{ url('users') }}" class="btn btn-danger btn-block">Cancel</a>
                        </div>
                        <div class="col-md-6">
                            <button type="submit" class="btn btn-az-primary btn-block">Update</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- Scripts --}}
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const checkbox = document.getElementById('create_employee');
            const employeeDiv = document.getElementById('employee_select_div');
            const employeeSelect = document.getElementById('employee_id');
            const usernameInput = document.getElementById('name');
            const emailInput = document.getElementById('email');

            // Toggle employee select
            checkbox.addEventListener('change', function() {
                if(this.checked) {
                    employeeDiv.style.display = 'block';
                } else {
                    employeeDiv.style.display = 'none';
                    employeeSelect.value = '';
                    usernameInput.value = '';
                    emailInput.value = '';
                }
            });

            // Auto-fill name and email from selected employee
            employeeSelect.addEventListener('change', function() {
                const selectedOption = this.options[this.selectedIndex];
                usernameInput.value = selectedOption.getAttribute('data-name') || '';
                emailInput.value = selectedOption.getAttribute('data-email') || '';
            });
        });
    </script>
@endsection
