@extends('layouts.master')

@section('title', 'Employee Attendance')

@section('content')
    <div class="az-content-breadcrumb mb-3">
        <span>Attendance</span>
    </div>

    <div class="card shadow border-0 mt-4">
        <div class="card-header bg-gradient-primary  d-flex justify-content-between align-items-center py-3 px-4">
            <h5 class="mb-0"><i class="fas fa-user-clock me-2"></i> Employee Attendance</h5>
            <span class="fw-semibold">{{ \Carbon\Carbon::parse($today)->format('l, d M Y') }}</span>
        </div>

        <div class="card-body px-4 py-4">

            @php
                $currentEmployee = $employees->firstWhere('user_id', auth()->user()->id);
                $todayAttendance = $currentEmployee?->attendances()->where('date', $today)->first();
            @endphp

            @if (auth()->user()->hasRole('Super-Admin') || auth()->user()->hasRole('admin'))
            @else
                <div class="d-flex justify-content-between align-items-center mb-4 flex-wrap">

                    {{-- Left: Check-In Time --}}
                    <div class="text-center flex-fill me-3">
                        <p class="text-muted mb-1">Check In Time</p>
                        <h5 class="text-success fw-bold">
                            {{ $todayAttendance?->check_in?->format('h:i A') ?? '—' }}
                        </h5>
                    </div>


                    <div class="text-center flex-fill mx-3">
                        @if (!$todayAttendance || !$todayAttendance->check_in)
                            <form action="{{ route('attendance.checkin') }}" method="POST">
                                @csrf
                                <button type="submit" class="btn btn-success btn-lg px-5 shadow-sm hover-zoom">
                                    <i class="fas fa-sign-in-alt me-2"></i> Check In
                                </button>
                            </form>
                        @elseif(!$todayAttendance->check_out)
                            <form action="{{ route('attendance.checkout') }}" method="POST">
                                @csrf
                                <button type="submit" class="btn btn-danger btn-lg px-5 shadow-sm hover-zoom">
                                    <i class="fas fa-sign-out-alt me-2"></i> Check Out
                                </button>
                            </form>
                        @else
                            <button class="btn btn-secondary btn-lg px-5 shadow-sm" disabled>
                                <i class="fas fa-check-circle me-2"></i> Attendance Completed
                            </button>
                        @endif
                    </div>

                    {{-- Right: Check-Out Time --}}
                    <div class="text-center flex-fill ms-3">
                        <p class="text-muted mb-1">Check Out Time</p>
                        <h5 class="text-danger fw-bold">
                            {{ $todayAttendance?->check_out?->format('h:i A') ?? '—' }}
                        </h5>
                    </div>

                </div>
            @endif

            {{-- Attendance Table --}}
            <div class="table-responsive mt-4">
                <table class="table table-striped table-hover align-middle text-center" id="attendanceTable">
                    <thead class="bg-dark text-white">
                        <tr>
                            <th>Employee</th>
                            <th>Date</th>
                            <th>Check-In</th>
                            <th>Check-Out</th>
                            <th>Status</th>
                            <th>Notes</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($employees as $employee)
                            @foreach ($employee->attendances as $att)
                                <tr @if ($att->date == $today) class="table-success" @endif>
                                    <td class="fw-semibold text-start">
                                        <i class="fas fa-user me-1 text-primary"></i>
                                        {{ $employee->first_name }} {{ $employee->last_name }}
                                    </td>
                                    <td>{{ \Carbon\Carbon::parse($att->date)->format('d-m-Y') }}</td>
                                    <td class="text-success fw-semibold">{{ $att->check_in?->format('h:i A') ?? '—' }}</td>
                                    <td class="text-danger fw-semibold">{{ $att->check_out?->format('h:i A') ?? '—' }}</td>
                                    <td>
                                        <span
                                            class="badge
                                        @if ($att->status == 'present') bg-success
                                        @elseif($att->status == 'late') bg-warning text-dark
                                        @elseif($att->status == 'half-day') bg-info
                                        @elseif($att->status == 'absent') bg-danger
                                        @else bg-secondary @endif">
                                            {{ ucfirst($att->status ?? '—') }}
                                        </span>
                                    </td>
                                    <td>{{ $att->notes ?? '-' }}</td>
                                </tr>
                            @endforeach
                        @endforeach
                    </tbody>
                </table>
            </div>

        </div>
    </div>
@endsection

@push('styles')
    <style>
        .bg-gradient-primary {
            background: linear-gradient(45deg, #007bff, #6610f2);
        }

        .hover-zoom:hover {
            transform: scale(1.05);
            transition: 0.2s ease-in-out;
        }

        .table th {
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: .5px;
        }
    </style>
@endpush

@push('scripts')
    <script>
        $(document).ready(function() {
            $('#attendanceTable').DataTable({
                dom: 'Bfrtip',
                buttons: ['csv', 'excel', 'pdf', 'print'],
                responsive: true,
                order: [
                    [1, 'desc']
                ],
                pageLength: 25
            });
        });
    </script>
@endpush
