@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Departments</span>
        <span>Add Department</span>
    </div>
    <h2 class="az-content-title" style="display: inline">
        Add New Department
        <span><a href="{{ url('departments') }}" class="btn btn-az-primary" style="float: right">Department List</a></span>
    </h2>

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <h5 class="card-title mg-b-20">Add Department Details</h5>
                <form method="POST" action="{{ url('departments/store') }}">
                    @csrf
                    @if ($errors->any())
                        <div class="p-1">
                            @foreach ($errors->all() as $error)
                                <div class="alert alert-warning alert-danger fade show" role="alert">
                                    {{ $error }}
                                    <button type="button" class="close" data-dismiss="alert">
                                        <span>&times;</span>
                                    </button>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    <div class="form-group">
                        <label class="az-content-label tx-11 tx-medium tx-gray-600">Department Name</label>
                        <input type="text" name="name" class="form-control" required>
                    </div>

                    <div class="form-group">
                        <label class="az-content-label tx-11 tx-medium tx-gray-600">Department Code</label>
                        <input type="text" name="code" class="form-control">
                    </div>

                    <div class="form-group">
                        <label class="az-content-label tx-11 tx-medium tx-gray-600">Description</label>
                        <textarea name="description" class="form-control" rows="4"></textarea>
                    </div>

                    <button type="button" onclick="history.back()" class="btn btn-danger btn-block mt-2">Cancel</button>
                    <button type="submit" class="btn btn-az-primary btn-block mt-2">Submit</button>
                </form>
            </div>
        </div>
    </div>
@endsection
