@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Departments</span>
        <span>Edit Department</span>
    </div>
    <h2 class="az-content-title" style="display: inline">
        Edit Department
        <span><a href="{{ url('departments') }}" class="btn btn-az-primary" style="float: right">Department List</a></span>
    </h2>

    <div class="row">
        <div class=" col-md-12">
            <div class="card card-body pd-40">
                <h5 class="card-title mg-b-20">Edit Department Details</h5>
                <form method="POST" action="{{ url('departments/update/' . Crypt::encrypt($department->id)) }}">
                    @csrf
                    @method('POST')

                    <div class="form-group">
                        <label class="az-content-label tx-11 tx-medium tx-gray-600">Department Name</label>
                        <input type="text" name="name" value="{{ $department->name }}" class="form-control" required>
                    </div>

                    <div class="form-group">
                        <label class="az-content-label tx-11 tx-medium tx-gray-600">Department Code</label>
                        <input type="text" name="code" value="{{ $department->code }}" class="form-control">
                    </div>

                    <div class="form-group">
                        <label class="az-content-label tx-11 tx-medium tx-gray-600">Description</label>
                        <textarea name="description" class="form-control" rows="4">{{ $department->description }}</textarea>
                    </div>

                    <div class="form-group">
                        <label class="az-content-label tx-11 tx-medium tx-gray-600">Status</label>
                        <select name="status" class="form-control @error('status') is-invalid @enderror" required>
                            <option value="Active"
                                {{ isset($department) && $department->status == 'active' ? 'selected' : '' }}>Active
                            </option>
                            <option value="Inactive"
                                {{ isset($department) && $department->status == 'inactive' ? 'selected' : '' }}>Inactive
                            </option>
                        </select>
                        @error('status')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <button type="button" onclick="history.back()" class="btn btn-danger btn-block mt-2">Back</button>
                    <button type="submit" class="btn btn-az-primary btn-block mt-2">Update</button>
                </form>
            </div>
        </div>
    </div>
@endsection
