@extends('layouts.master')
@section('content')
    <style>
        @import url('https://fonts.googleapis.com/css?family=Assistant');

        body {

            font-family: Assistant, sans-serif
        }

        .cell-1 {
            border-collapse: separate;
            border-spacing: 0 4em;

            border-bottom: 5px solid transparent;
            background-clip: padding-box;
            cursor: pointer
        }



        .table-elipse {
            cursor: pointer
        }

        #demo {
            -webkit-transition: all 0.3s ease-in-out;
            -moz-transition: all 0.3s ease-in-out;
            -o-transition: all 0.3s 0.1s ease-in-out;
            transition: all 0.3s ease-in-out
        }


        .table td.collapse.in {
            display: table-cell;
        }
    </style>
    <div class="card card-body pd-10">
        <div class="az-content-breadcrumb">
            <span>Departments</span>
        </div>
        <h2 class="az-content-title" style="display: inline"> Departments List <span>
                @can('Departments add')
                    <a href="{{ url('departments/create') }}" class="btn btn-az-primary" style="float: right">Add
                        Department</a>
                @endcan
            </span>
        </h2>
        {{-- <h2 style="float: right" class="az-content-title"></h2> --}}
    </div>

    {{-- <div class="az-content-body pd-lg-l-40 d-flex flex-column"> --}}
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">

                <div>
                    <table id="example2" class="table table-striped">
                        <thead>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-10p">Name</th>
                                <th class="wd-10p">Type</th>
                                <th class="wd-10p">Status </th>
                                <th class="wd-10p">Created</th>
                                <th class="wd-10p">Operations</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($departments as $key => $sup)
                                <tr>

                                    <td>{{ $key + 1 }}</td>
                                    <td>{{ $sup->department_name }}</td>
                                    <td>{{ $sup->department_type }}</td>
                                    <td>{{ $sup->status == 1 ? 'Active' : 'In-Active' }}</td>
                                    <td><?= date('d-m-Y', strtotime($sup->created_at)) ?></td>

                                    <td>
                                        @can('Departments edit')
                                            <a class="btn btn-primary"
                                                href="{{ url('departments/edit', \Crypt::encrypt($sup->id_departments)) }}">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                        @endcan
                                        @can('Departments delete')
                                            <a href="#" class="btn btn-danger" data-toggle="modal"
                                                data-target="#deleteModal" data-id="{{ $sup->id_departments }}">
                                                <i class="fas fa-trash"></i>
                                            </a>
                                        @endcan

                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-10p">Name</th>
                                <th class="wd-10p">Type</th>
                                <th class="wd-10p">Status </th>
                                <th class="wd-10p">Created</th>
                                <th class="wd-10p">Operations</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
            <!-- card -->
        </div>
        <!-- col -->
    </div>





    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this sub-control account?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" action="" method="POST">
                        @csrf
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>



    {{-- </div><!-- az-content-body --> --}}
@endsection
@push('scripts')
    <script type="text/javascript">
        function confirmDelete() {
            return confirm('Are you sure you want to delete this supplier?');
        }

        $(function() {
            oTable = $('#example2').DataTable({
                responsive: !0
            });
        });

        $(document).ready(function() {
            $('#deleteModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget);
                var id = button.data('id');
                var actionUrl = '{{ url('departments/delete') }}/' + id;
                var modal = $(this);
                modal.find('#deleteForm').attr('action', actionUrl);
            });
        });
    </script>
@endpush
