@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Product Category list</span>
        <span>Edit Product Category</span>
    </div>
    <h2 class="az-content-title" style="display: inline">Edit Product Category <span>
            <a href="{{ url('product') }}" class="btn border" style="float: right"><i class="fa-solid fa-bars-staggered"></i>
                Back to Products Category
            </a>
        </span>
    </h2>

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <h5 class="card-title mg-b-20">Edit Product Category Details</h5>
                <form method="POST" action="{{ url('product/update/' . \Crypt::encrypt($edit->id_pro_cate_main)) }}">
                    @csrf
                    @if (count($errors) > 0)
                        <div class="p-1">
                            @foreach ($errors->all() as $error)
                                <div class="alert alert-warning alert-danger fade show" role="alert">{{ $error }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            @endforeach
                        </div>
                    @endif
                    <div class="row row-sm mg-b-20">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Product Category Name</label>
                                <input type="text" value="{{ $edit->products_category_name }}"
                                    name="products_category_name" class="form-control" required />
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Product Category Name (Urdu)
                                    Optional </label>
                                <input type="text" value="{{ $edit->products_category_name_urdu }}"
                                    name="products_category_name_urdu" class="form-control" required />
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label class="az-content-label tx-11 tx-medium tx-gray-600">Status</label>
                            <select class="form-control" name="products_category_status" id="products_category_status">
                                <option value="1" {{ $edit->products_category_status == 1 ? 'selected' : '' }}>Active
                                </option>
                                <option value="0" {{ $edit->products_category_status == 0 ? 'selected' : '' }}>In
                                    Active</option>
                            </select>
                        </div>
                    </div>

                    <a type="button" href="{{ url('/product') }}" class="btn btn-danger btn-block mt-2">
                        Cancel
                    </a>
                    <button type="submit" class="btn btn-az-primary btn-block mt-2" style="float: right">
                        Update
                    </button>
                </form>
            </div>
        </div>
    </div>
@endsection
