@extends('layouts.master')

@section('content')
    <div class="az-content-breadcrumb">
        <span>Brands & Products</span>
        <span>Products List</span>
    </div>
    <h2 class="az-content-title">Products for Brand: {{ $brand->brands_name }}
        @can('Supplier add')
            <a href="{{ route('products.create', Crypt::encrypt($brand_id)) }}" class="btn btn-az-primary" style="float: right">
                <i class="fa-solid fa-plus"></i> Add Product</a>
            <a href="{{ route('brands.list') }}" class="btn border" style="float: right"><i class="fa-solid fa-bars-staggered"></i>
                Back to Brands
            </a>
        @endcan
    </h2>

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-20">
                <div>
                    <table id="productTable" class="table table-striped">
                        <thead>
                            <tr>
                                <th>S.No</th>
                                <th>Product Name</th>
                                <th>Category</th>
                                <th>Unit</th>
                                <th>In Stock</th>
                                <th>Description</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($products as $key => $product)
                                <tr>
                                    <td>{{ $key + 1 }}</td>
                                    <td>{{ $product->products_name }}</td>
                                    <td>{{ $product->category->products_category_name . ' | ' . $product->category->products_category_name_urdu ?? '' }}
                                    </td>
                                    <td>{{ $product->unit->measurement_unit_name ?? '' }}</td>
                                    <td>{{ $product->in_stock ? 'Yes' : 'No' }}</td>
                                    <td>{{ $product->products_desc }}</td>
                                    <td>
                                        {{-- @can('Product edit') --}}
                                        {{-- <a href="{{ route('products.edit', $product->id_products) }}"
                                            class="btn btn-primary">Edit</a> --}}
                                        {{-- <a href="{{ route('products.edit', Crypt::encrypt($product->id_products)) }}"
                                            class="btn btn-primary">Edit</a> --}}

                                        <a class="btn rounded shadow-base" title="Edit"
                                            href="{{ route('products.edit', Crypt::encrypt($product->id_products)) }}">
                                            <i class="text-primary fa-regular fa-pen-to-square"></i> <span
                                                class="text-primary">Edit</span>
                                        </a>

                                        {{-- @endcan --}}
                                        {{-- @can('Product view') --}}
                                        {{-- <a href="{{ route('products.view', $product->id_products) }}"
                                                class="btn btn-info">View</a> --}}
                                        {{-- @endcan --}}
                                        {{-- @can('Product delete') --}}
                                        <form action="{{ route('products.destroy', $product->id_products) }}"
                                            method="POST" style="display: inline-block;">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn rounded shadow-base">
                                                <i class="text-danger fa-solid fa-trash-can"></i> <span
                                                    class="text-danger">Remove</span>
                                            </button>
                                            {{-- <a class="btn rounded shadow-base" data-toggle="modal"
                                                data-target="#deleteModal" data-id="{{ $brand->id_brands }}">
                                                <i class="text-danger fa-solid fa-trash-can"></i> <span
                                                    class="text-danger">Remove</span>
                                            </a> --}}
                                        </form>
                                        {{-- @endcan --}}
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th>S.No</th>
                                <th>Product Name</th>
                                <th>Category</th>
                                <th>Unit</th>
                                <th>In Stock</th>
                                <th>Description</th>
                                <th>Actions</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script type="text/javascript">
        function confirmDelete() {
            return confirm('Are you sure you want to delete this Product?');
        }

        // <script type="text/javascript">
        $(function() {
            oTable = $('#productTable').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'csv',
                        text: 'CSV',
                        title: 'Supplier List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'excel',
                        text: 'Excel',
                        title: 'Supplier List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'pdf',
                        text: 'PDF',
                        title: 'Supplier List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'print',
                        text: 'Print',
                        title: 'Supplier List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    }
                ],
                responsive: !0
            });
        });


        $(document).ready(function() {
            $('#deleteModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget);
                var id = button.data('id');
                var actionUrl = '{{ url('supplier/destroy') }}/' + id;
                var modal = $(this);
                modal.find('#deleteForm').attr('action', actionUrl);
            });
        });

        $(document).ready(function() {
            $('#brandModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget);
                var supplierId = button.data('id');
                var modal = $(this);
                modal.find('#supplier_id').val(supplierId);
            });
        });
    </script>
@endpush
