@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Purchase Order</span>
    </div>
    <h2 class="az-content-title" style="display: inline">Purchase Order List
        <span>
            @can('Purchase Order add')
                <a href="{{ route('po.create') }}" class="btn btn-az-primary " id="addbtn" style="float: right">
                    <i class="fa-solid fa-plus"></i> Add Purchase Order
                </a>
            @endcan
        </span>
    </h2>
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-20">
                <div>
                    <table id="example2" class="table table-striped">
                        <thead>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-10p">Date</th>
                                <th class="wd-10p">PO Number</th>
                                <th class="wd-10p">Supplier</th>
                                <th class="wd-10p">Total Amount</th>
                                <th class="wd-10p">Custom Charges</th>
                                <th class="wd-10p">Labour Charges</th>
                                <th class="wd-10p">Local Charges</th>
                                <th class="wd-10p">Weight Charges</th>
                                <th class="wd-10p">Tax</th>
                                <th class="wd-10p">Grand Total</th>
                                <th class="wd-10p">Status</th>
                                <th class="none">Item Details</th>
                                <th class="wd-20p">Description</th>
                                <th class="none">Created By</th>
                                <th class="none">Created Ay</th>
                                <th class="none">Updated At</th>
                                <th class="none">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($purchase_order as $key => $po)
                                <tr>
                                    <td>{{ $key + 1 }}</td>
                                    <td>{{ $po->order_date }}</td>
                                    <td>{{ $po->po_number }}</td>
                                    <td>{{ $po->purchaser->purchaser_name }}</td>
                                    <td>{{ number_format($po->total_amount) }}</td>
                                    <td>{{ number_format($po->labour_charges) }}</td>
                                    <td>{{ number_format($po->local_charges) }}</td>
                                    <td>{{ number_format($po->weight_charges) }}</td>
                                    <td>{{ number_format($po->custom_charges) }}</td>
                                    <td>{{ number_format($po->tax) }}</td>
                                    <td>{{ number_format($po->grand_total) }}</td>
                                    <td>
                                        @if ($po->status == 'Pending')
                                            <span class="badge bg-warning">{{ $po->status }}</span>
                                        @elseif($po->status == 'Approved')
                                            <span class="badge bg-success">{{ $po->status }}</span>
                                        @elseif($po->status == 'Rejected')
                                            <span class="badge bg-danger">{{ $po->status }}</span>
                                        @else
                                            <span class="badge bg-secondary">{{ $po->status }}</span>
                                        @endif
                                    </td>

                                    <td>
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>Item Name</th>
                                                    <th>Marka</th>
                                                    <th>Bori</th>
                                                    <th>Weight</th>
                                                    <th>Rate</th>
                                                    <th>Amount</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($po->Purchasedetails as $item)
                                                    <tr>
                                                        <td>{{ $item->proCateChild->name }}</td>
                                                        <td>{{ $item->marka }}</td>
                                                        <td>{{ $item->bori }}</td>
                                                        <td>{{ number_format($item->weight) }}</td>
                                                        <td>{{ number_format($item->rate) }}</td>
                                                        <td>{{ number_format($item->amount) }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </td>
                                    <td>{{ $po->notes }}</td>
                                    <td>{{ $po->createdBy->name }}</td>
                                    <td>{{ $po->created_at }}</td>
                                    <td>{{ $po->updated_at }}</td>
                                    <td>
                                        @can('Purchase Order edit')
                                            <a class="btn rounded shadow-base" title="Edit Purchase Order"
                                                href="{{ route('po.edit', Crypt::encrypt($po->id)) }}">
                                                <i class="text-primary fa-regular fa-pen-to-square"></i>
                                                <span class="text-primary">Edit</span>
                                            @endcan
                                        </a>
                                        @can('Purchase Order delete')
                                            <a class="btn rounded shadow-base" title="Delete Purchase Order" data-toggle="modal"
                                                data-target="#deleteModal" data-id="{{ Crypt::encrypt($po->id) }}">
                                                <i class="text-danger fa-solid fa-trash-can"></i>
                                                <span class="text-danger">Remove</span>
                                            </a>
                                        @endcan
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>

                    </table>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this Purchase Order?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" action="" method="POST">
                        @csrf
                        @method('GET')
                        <button type="button" class="btn btn-secondary text-light" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>

        $(document).ready(function() {
            $('#deleteModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget);
                var id = button.data('id');
                var actionUrl = '{{ url('purchase_order/destroy') }}/' + id;
                var modal = $(this);
                modal.find('#deleteForm').attr('action', actionUrl);
            });
        });
    </script>

    <script type="text/javascript">

     document.addEventListener('keydown', function(event) {
            if ((event.ctrlKey || event.metaKey) && event.key === 'a') {
                event.preventDefault(); // Prevent default CTRL + A behavior (Select All)

                // Trigger the click on the "Add Customers" button
                document.getElementById('addbtn').click();
            }
        });
        $(function() {
            oTable = $('#example2').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'csv',
                        text: 'CSV',
                        title: 'Purchase Order List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'excel',
                        text: 'Excel',
                        title: 'Purchase Order List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'pdf',
                        text: 'PDF',
                        title: 'Purchase Order List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'print',
                        text: 'Print',
                        title: 'Purchase Order List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    }
                ],
                responsive: true
            });
        });
    </script>
@endpush
