@extends('layouts.master')

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
@endpush

@section('content')
    <div class="card">
        <div class="card-header">
            <h3>Receivables Report</h3>
        </div>
        <div class="card-body">
            @if ($errors->any())
                <div style="border:1px solid red; padding:10px; margin-bottom:20px; background-color:#fdd;">
                    <strong>Errors:</strong>
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form id="filterForm" class="row" method="GET" action="{{ route('receivables.print') }}">

                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group mt-3">
                            <label for="date">Date</label>
                            <input type="date" name="date" id="date" readonly class="date form-control"
                                value="{{ request('date', date('Y-m-d')) }}">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group mt-3">
                            <label>Select Customer</label>
                            <select id="customers" name="customers[]" class="form-control select2" multiple>
                                @foreach ($customers as $customer)
                                    <option value="{{ $customer->id_customers }}">{{ $customer->customer_name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>

                <div class="row mt-5">
                    <div class="col-md-12 text-center">
                        <button type="submit" class="btn btn-primary">
                            <i class="fa fa-search"></i> Print View
                        </button>
                    </div>
                </div>

            </form>
            <hr />

        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $(document).ready(function () {
            $(".date").datepicker({
                dateFormat: "yy-mm-dd"
            });

            $('.select2').select2();
        });
    </script>
@endpush
