@extends('layouts.master')

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
@endpush

@section('content')
    <div class="card">
        <div class="card-header">
            <h3>Truck Sale Register Report</h3>
        </div>
        <div class="card-body">
            @if ($errors->any())
                <div style="border:1px solid red; padding:10px; margin-bottom:20px; background-color:#fdd;">
                    <strong>Errors:</strong>
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form id="filterForm" class="row" method="GET" action="{{ route('truck-sale-register.report.print') }}">

                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group mt-3">
                            <label for="from_date">From Date</label>
                            <input type="date" name="date" id="from_date" readonly class="date form-control"
                                value="{{ request('date') }}">
                        </div>
                    </div>

                    <div class="col-md-9">
                        <div class="form-group mt-3">
                            <label>Select Truck</label>
                            <select id="trucks" name="truck_id" class="form-control select2">
                                {{-- <option value="">Select</option> --}}
                                @foreach ($trucks as $customer)
                                    <option value="{{ $customer->id_truck }}">{{ $customer->truck_no }}</option>
                                @endforeach
                            </select>

                            {{-- <button type="button" id="toggleSelectBtn" class="btn btn-primary btn-sm"
                                style="margin-top:10px;">
                                Select All
                            </button> --}}
                        </div>
                    </div>

                    <div class="row mt-5">
                        <div class="col-md-12 text-center">
                            <button type="submit" class="btn btn-primary"><i class="fa fa-search"></i> Print
                                View</button>
                        </div>
                    </div>
            </form>
            <hr />

        </div>
    </div>
@endsection
@push('scripts')
    <script>
        $('.select2').select2();
    </script>
    <script>
        $(document).ready(function() {
            $(function() {
                $(".date").datepicker({
                    dateFormat: "yy-mm-dd"
                });
            });
            $('.select2').select2();

            $(document).ready(function() {

                $('.select2').select2();

                $('#toggleSelectBtn').click(function() {

                    let totalOptions = $('#trucks option').length;
                    let selectedCount = $('#trucks').val() ? $('#trucks').val().length : 0;


                    if (selectedCount === totalOptions) {

                        $('#trucks').val(null).trigger('change');

                        $('#toggleSelectBtn')
                            .text('Select All')
                            .removeClass('btn-danger')
                            .addClass('btn-primary');

                    } else {

                        let allValues = [];

                        $('#trucks option').each(function() {
                            let val = $(this).val();
                            if (val !== "") allValues.push(val);
                        });

                        $('#trucks').val(allValues).trigger('change');

                        $('#toggleSelectBtn')
                            .text('Deselect All')
                            .removeClass('btn-primary')
                            .addClass('btn-danger');
                    }

                });

            });

        });
    </script>
@endpush
