<!DOCTYPE html>
<html lang="ur" dir="rtl">

<head>
    <meta charset="UTF-8">
    <title>Truck Sale Register - Report</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Noto+Nastaliq+Urdu:wght@400;600;700&display=swap');

        body {
            font-family: 'Noto Nastaliq Urdu', Arial, sans-serif;
            margin: 0;
            padding: 0;
            background: #fff;
            color: #111;
            direction: rtl;
        }

        .container { width: 95%; margin: auto; padding: 20px 0; }
        h2 { text-align: center; margin: 0; font-size: 22px; letter-spacing: 2px; }
        .report-title { text-align: center; font-size: 16px; margin: 4px 0; }
        .truck-no { text-align: center; font-size: 15px; margin: 4px 0; }

        .supplier-row {
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-bottom: 2px solid #000;
            padding: 6px 10px;
            margin-top: 10px;
            margin-bottom: 0;
        }
        .supplier-label { font-size: 16px; font-weight: bold; }
        .supplier-name { font-size: 16px; font-weight: bold; color: #0000cc; text-decoration: underline; }

        table { width: 100%; border-collapse: collapse; margin-bottom: 10px; }
        th { padding: 8px 10px; border-top: 1px solid #000; border-bottom: 1px solid #000; text-align: center; font-size: 15px; background: #fff; }
        td { padding: 6px 10px; text-align: center; font-size: 14px; }

        .customer-name-row td { text-align: right; padding: 10px 10px 2px 0; }
        .customer-name-row td h3 { margin: 0; font-size: 17px; color: #cc0000; font-weight: bold; }

        tr.customer-end td { border-bottom: 1px dashed #000; }
        tr.customer-subtotal td { font-weight: bold; }

        tr.grand-total {
            border-top: 2px solid #000;
            border-bottom: 2px solid #000;
            font-weight: bold;
            background-color: #f0f0f0;
        }
        tr.grand-total td { padding: 10px 10px; }

        .no-print { display: block; margin: 20px auto; padding: 10px 20px; font-size: 16px; cursor: pointer; background: #333; color: #fff; border: none; border-radius: 4px; }
        @media print { .no-print { display: none; } }
    </style>
</head>

<body>
    <div class="container">

        <h2>M.D.S</h2>
        <p class="report-title">ٹرک &nbsp; فروخت رجسٹر &nbsp; Truck Sales Register</p>
        <p class="truck-no">Truck No. : {{ $truckNumber }}</p>

        <div class="supplier-row">
            <span class="supplier-label">سپلائر</span>
            <span class="supplier-name">{{ $supplier->supplier_name ?? '—' }}</span>
        </div>

        <table>
            <thead>
                <tr>
                    <th>مال</th>
                    <th>بوری</th>
                    <th>وزن</th>
                    <th>ریٹ</th>
                    <th>قیمت</th>
                    <th>کیش وصول</th>
                    <th>بقایہ</th>
                </tr>
            </thead>
            <tbody>

                @php
                    $grandTotalBori    = 0;
                    $grandTotalWeight  = 0;
                    $grandTotalAmount  = 0;
                    $grandTotalPaid    = 0;
                    $grandTotalBalance = 0;
                @endphp

                @foreach ($salesByCustomer as $customerId => $customerSales)
                    @php
                        $totalBori    = 0;
                        $totalWeight  = 0;
                        $totalAmount  = 0;

                        $totalCashRec = $customerTotals[$customerId]->total_paid ?? 0;
                        $totalBalance = $customerTotals[$customerId]->total_balance ?? 0;
                        $totalCredit  = $customerCredits[$customerId] ?? 0;
                        $allItems     = $customerSales->flatMap(fn($sale) => $sale->salesItemsDetails);
                    @endphp

                    <tr class="customer-name-row">
                        <td colspan="7">
                            <h3>{{ $customerSales->first()->customer->customer_name_urdu ?? 'Unknown' }}</h3>
                        </td>
                    </tr>

                    @foreach ($allItems as $item)
                        @php
                            $totalBori   += (int) $item->bori;
                            $totalWeight += (int) $item->weight;
                            $totalAmount += (int) $item->amount;
                        @endphp
                        <tr class="{{ $loop->last ? 'customer-end' : '' }}">
                            <td>{{ $item->productChildCate->name_urdu ?? '—' }}</td>
                            <td>{{ number_format($item->bori) }}</td>
                            <td>{{ number_format($item->weight) }}</td>
                            <td>{{ number_format($item->rate) }}</td>
                            <td>{{ number_format($item->amount) }}</td>
                            <td></td>
                            <td></td>
                        </tr>
                    @endforeach

                    {{-- Customer Subtotal --}}
                    <tr class="customer-subtotal">
                        <td></td>
                        <td>{{ number_format($totalBori) }}</td>
                        <td>{{ number_format($totalWeight) }}</td>
                        <td></td>
                        <td>{{ number_format($totalAmount) }}</td>
                        <td>{{ number_format($totalCredit+$totalCashRec) }}</td>
                        <td>{{ number_format($totalBalance-$totalCredit) }}</td>
                    </tr>

                    @php
                        $grandTotalBori    += $totalBori;
                        $grandTotalWeight  += $totalWeight;
                        $grandTotalAmount  += $totalAmount;
                        $grandTotalPaid    += $totalCredit+$totalCashRec;
                        $grandTotalBalance += $totalBalance-$totalCredit;
                    @endphp

                @endforeach

                <tr class="grand-total">
                    <td style="text-align:right;">کل جمع (Grand Total)</td>
                    <td>{{ number_format($grandTotalBori) }}</td>
                    <td>{{ number_format($grandTotalWeight) }}</td>
                    <td></td>
                    <td>{{ number_format($grandTotalAmount) }}</td>
                    <td>{{ number_format($grandTotalPaid) }}</td>
                    <td>{{ number_format($grandTotalBalance) }}</td>
                </tr>

            </tbody>
        </table>

        <button class="no-print" onclick="window.print()">Print</button>

    </div>
</body>

</html>
