@extends('layouts.master')

@section('content')
    <div class="az-content-breadcrumb">
        <span>Sale Rate</span>
    </div>
    <h2 class="az-content-title" style="display: inline">
        Sale Rate List
        <span>
            <a href="{{ route('sale_rate.create') }}" class="btn btn-az-primary" style="float: right">
                <i class="fa-solid fa-plus"></i> Create Sale Rate </a>
        </span>
    </h2>

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-20">
                <div>
                    <table id="example2" class="table table-striped">
                        <thead>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-10p">Date</th>
                                <th class="wd-10p">Client</th>
                                <th class="wd-10p">Vehicle No</th>
                                <th class="wd-10p">Products</th>
                                <th class="wd-10p">Marks</th>
                                <th class="wd-10p">Qty</th>
                                <th class="wd-10p">Weight</th>
                                <th class="wd-10p">Price</th>
                                <th class="wd-10p">BasicAccount</th>
                                <th class="none">Remarks</th>
                                <th class="none">Created By</th>
                                <th class="none">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            {{-- @foreach ($sales as $key => $sale)
                                <tr>
                                    <td>{{ $key + 1 }}</td>
                                    <td>{{ $sale->date }}</td>
                                    <td>{{ $sale->s_no }}</td>
                                    <td>{{ $sale->goodReceiptTruck->truck_no }}</td>
                                    <td>{{ $sale->customer->customer_name }}</td>
                                    <td>{{ $sale->balance }}</td>
                                    <td>{{ $sale->total_amount }}</td>
                                    <td>{{ $sale->paid ?? 0 }}</td>
                                    <td>{{ $sale->total_amount }}</td>
                                    <td>
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>Item Name</th>
                                                    <th>Marka</th>
                                                    <th>Bori</th>
                                                    <th>Weight</th>
                                                    <th>Rate</th>
                                                    <th>Amount</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($sale->salesItemsDetails as $item)
                                                    <tr>
                                                        <td>{{ $item->items_name }}</td>
                                                        <td>{{ $item->marka }}</td>
                                                        <td>{{ $item->bori }}</td>
                                                        <td>{{ $item->weight }}</td>
                                                        <td>{{ $item->rate }}</td>
                                                        <td>{{ $item->amount }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </td>
                                    <td>
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>Bori Number</th>
                                                    <th>Per Bori Weight</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($sale->salesPerBoriWeight as $bori)
                                                    <tr>
                                                        <td>{{ $bori->bori_number }}</td>
                                                        <td>{{ $bori->per_bori_weight }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </td>
                                    <td>{{ $sale->details }}</td>
                                    <td>{{ $sale->bori_details }}</td>
                                    <td>{{ $sale->created_by }}</td>
                                    <td>
                                        <a class="btn rounded shadow-base" title="Edit Sale Rate"
                                            href="{{ route('sale_rate.edit', Crypt::encrypt($sale->id_sales)) }}">
                                            <i class="text-primary fa-regular fa-pen-to-square"></i>
                                            <span class="text-primary">Edit</span>
                                        </a>
                                        <a class="btn rounded shadow-base" title="Delete Sale Rate" data-toggle="modal"
                                            data-target="#deleteModal" data-id="{{ Crypt::encrypt($sale->id_sales) }}">
                                            <i class="text-danger fa-solid fa-trash-can"></i>
                                            <span class="text-danger">Remove</span>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach --}}
                        </tbody>
                        <tfoot>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-10p">Date</th>
                                <th class="wd-10p">Client</th>
                                <th class="wd-10p">Vehicle No</th>
                                <th class="wd-10p">Products</th>
                                <th class="wd-10p">Marks</th>
                                <th class="wd-10p">Qty</th>
                                <th class="wd-10p">Weight</th>
                                <th class="wd-10p">Price</th>
                                <th class="wd-10p">BasicAccount</th>
                                <th class="none">Remarks</th>
                                <th class="none">Created By</th>
                                <th class="none">Action</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this Sale?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" action="" method="POST">
                        @csrf
                        @method('GET')
                        <button type="button" class="btn btn-secondary text-light" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script type="text/javascript">
        $(function() {
            oTable = $('#example2').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'csv',
                        text: 'CSV',
                        title: 'Goods Receipts List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'excel',
                        text: 'Excel',
                        title: 'Goods Receipts List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'pdf',
                        text: 'PDF',
                        title: 'Goods Receipts List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'print',
                        text: 'Print',
                        title: 'Goods Receipts List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    }
                ],
                responsive: !0
            });
        });

        $(document).ready(function() {
            $('#deleteModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget);
                var id = button.data('id');
                var actionUrl = '{{ url('sale_rate/destroy') }}/' + id;
                var modal = $(this);
                modal.find('#deleteForm').attr('action', actionUrl);
            });
        });
    </script>
@endpush
