@extends('layouts.master')

@section('content')

<div class="az-content-breadcrumb">
    <span>Service Purchase</span>
    <span>Add Service Purchase</span>
</div>

<h2 class="az-content-title">
     <a href="{{ route('service_purchase.list') }}" class="btn border float-right">
        Back
    </a>
    Add New Service Purchase
</h2>

<div class="separator-breadcrumb border-top"></div>

<div class="card card-body pd-40">

<form action="{{ route('service_purchase.store') }}" method="POST">
@csrf

{{-- ================= MASTER FIELDS ================= --}}
<div class="row">
    <div class="col-md-4">
        <label>Supplier</label>
        <select name="supplier_id" class="form-control" required>
            <option value="">Select Supplier</option>
            @foreach($suppliers as $supplier)
                <option value="{{ $supplier->id }}">{{ $supplier->name }}</option>
            @endforeach
        </select>
    </div>

    <div class="col-md-4">
        <label>Vehicle No</label>
        <input type="text" name="truck_no" class="form-control">
    </div>

    <div class="col-md-4">
        <label>Bill No</label>
        <input type="text" name="bill_no" class="form-control">
    </div>
</div>

<div class="row mt-2">
    <div class="col-md-12">
        <label>Description</label>
        <textarea name="description" class="form-control"></textarea>
    </div>
</div>

<hr>

{{-- ================= DETAILS TABLE ================= --}}
<h5>Service Details</h5>

<table class="table table-bordered" id="detailsTable">
    <thead>
        <tr>
            <th>Expense Account</th>
            <th width="10%">Qty</th>
            <th width="10%">Unit</th>
            <th width="15%">Price</th>
            <th width="15%">Amount</th>
            <th>Narration</th>
            <th width="5%">❌</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td>
                <select name="details[0][expense]" class="form-control" required>
                    <option value="">Select Expense</option>
                    @foreach($expenseAccounts as $account)
                        <option value="{{ $account->id }}">{{ $account->name }}</option>
                    @endforeach
                </select>
            </td>
            <td>
                <input type="number" step="0.01" name="details[0][qty]" class="form-control qty" required>
            </td>
            <td>
                <select name="details[0][unit]" class="form-control">
                    <option value="">Select Unit</option>
                    @foreach($units as $unit)
                        <option value="{{ $unit->id }}">{{ $unit->name }}</option>
                    @endforeach
                </select>
            </td>
            <td>
                <input type="number" step="0.01" name="details[0][price]" class="form-control price" required>
            </td>
            <td>
                <input type="number" step="0.01" class="form-control amount" readonly>
            </td>
            <td>
                <input type="text" name="details[0][remarks]" class="form-control">
            </td>
            <td>
                <button type="button" class="btn btn-danger btn-sm removeRow">×</button>
            </td>
        </tr>
    </tbody>
</table>

<button type="button" id="addRow" class="btn btn-success btn-sm">+ Add More Detail</button>

<hr>

<button type="submit" class="btn btn-az-primary btn-block mt-2">Submit</button>
<button type="button" onclick="history.back()" class="btn btn-danger btn-block mt-2">Cancel</button>

</form>
</div>

{{-- ================= JS ================= --}}
<script>
let rowIndex = 1;

document.getElementById('addRow').addEventListener('click', function () {
    let table = document.querySelector('#detailsTable tbody');
    let row = `
    <tr>
        <td>
            <select name="details[${rowIndex}][expense]" class="form-control" required>
                <option value="">Select Expense</option>
                @foreach($expenseAccounts as $account)
                    <option value="{{ $account->id }}">{{ $account->name }}</option>
                @endforeach
            </select>
        </td>
        <td><input type="number" step="0.01" name="details[${rowIndex}][qty]" class="form-control qty" required></td>
        <td>
            <select name="details[${rowIndex}][unit]" class="form-control">
                <option value="">Select Unit</option>
                @foreach($units as $unit)
                    <option value="{{ $unit->id }}">{{ $unit->name }}</option>
                @endforeach
            </select>
        </td>
        <td><input type="number" step="0.01" name="details[${rowIndex}][price]" class="form-control price" required></td>
        <td><input type="number" step="0.01" class="form-control amount" readonly></td>
        <td><input type="text" name="details[${rowIndex}][remarks]" class="form-control"></td>
        <td><button type="button" class="btn btn-danger btn-sm removeRow">×</button></td>
    </tr>`;
    table.insertAdjacentHTML('beforeend', row);
    rowIndex++;
});

// Auto-calculate amount
document.addEventListener('input', function (e) {
    if (e.target.classList.contains('qty') || e.target.classList.contains('price')) {
        let row = e.target.closest('tr');
        let qty = row.querySelector('.qty').value || 0;
        let price = row.querySelector('.price').value || 0;
        row.querySelector('.amount').value = (qty * price).toFixed(2);
    }
});

// Remove row
document.addEventListener('click', function (e) {
    if (e.target.classList.contains('removeRow')) {
        e.target.closest('tr').remove();
    }
});
</script>

@endsection
