@extends('layouts.master')

@section('content')
<div class="az-content-breadcrumb">
    <span>Service  Voucher</span>
</div>

<h2 class="az-content-title d-flex justify-content-between align-items-center">
    Service  Vouchers
    @can('Service Vouchers add')
        <a href="{{ route('service_vouchers.create') }}" class="btn btn-az-primary">
            <i class="fa-solid fa-plus"></i> Add Voucher
        </a>
    @endcan
</h2>

{{-- Alerts --}}
<div class="row mt-2">
    <div class="col-md-12">
        @if (session('alert'))
            <div class="alert alert-card alert-{{ session('alert-class') }}">
                {{ session('alert') }}
                <button class="close" type="button" data-dismiss="alert">
                    <span>&times;</span>
                </button>
            </div>
        @endif
    </div>
</div>

<div class="separator-breadcrumb border-top mt-3"></div>

<div class="row mt-3">
    <div class="col-md-12">
        <div class="card card-body">
            <table id="voucherTable" class="table table-bordered table-hover">
                <thead class="table-light">
                    <tr>
                        <th></th> {{-- This is the "expand/collapse" control --}}
                        <th>#</th>
                        <th>Voucher No</th>
                        <th>Date</th>
                        <th>Truck No</th>
                        <th>Bill No</th>
                        <th>Supplier</th>
                        <th>Total Amount</th>
                        <th>Description</th>
                        <th>Actions</th>
                    </tr>
                </thead>

                <tbody>
                    @forelse($vouchers as $key => $voucher)
                        <tr>
                            <td class="details-control"><i class="fa-brands fa-pushed"></i></td>
                            <td>{{ $key + 1 }}</td>
                            <td>{{ $voucher->voucher_no }}</td>
                            <td>{{ $voucher->voucher_date }}</td>
                            <td>{{ $voucher->truck_no }}</td>
                            <td>{{ $voucher->bill_no }}</td>
                            <td>{{ optional($voucher->supplier)->supplier_name ?? 'N/A' }}</td>
                            <td class="text-right">{{ number_format($voucher->total_amount, 2) }}</td>
                            <td>{{ $voucher->description }}</td>
                            <td>
                                @can('Service Vouchers edit')
                                    <a href="{{ route('service_vouchers.edit', Crypt::encrypt($voucher->id)) }}"
                                        class="btn btn-sm btn-success" title="Edit">
                                        <i class="fa fa-pen"></i>
                                    </a>
                                @endcan
                                @can('Service Vouchers delete')
                                    <form action="{{ route('service_vouchers.destroy', Crypt::encrypt($voucher->id)) }}"
                                        method="POST" style="display:inline-block"
                                        onsubmit="return confirm('Are you sure?')">
                                        @csrf
                                        @method('DELETE')
                                        <button class="btn btn-sm btn-danger" title="Delete">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </form>
                                @endcan
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="10" class="text-center">No vouchers found.</td>
                        </tr>
                    @endforelse
                </tbody>

                <tfoot>
                    <tr>
                        <th></th>
                        <th>#</th>
                        <th>Voucher No</th>
                        <th>Date</th>
                        <th>Truck No</th>
                        <th>Bill No</th>
                        <th>Supplier</th>
                        <th>Total Amount</th>
                        <th>Description</th>
                        <th>Actions</th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function () {

    // Function to format the child row with details
    function format(details) {
        var html = '<table class="table table-sm table-bordered mb-0">';
        html += '<thead class="table-secondary">';
        html += '<tr><th>#</th><th>Control Account</th><th>Qty</th><th>Unit</th><th>Price</th><th>Amount</th><th>Narration</th></tr>';
        html += '</thead><tbody>';
        details.forEach(function(item, index) {
            html += '<tr>';
            html += '<td>' + (index + 1) + '</td>';
            html += '<td>' + (item.control_account ? item.control_account.control_account_name : 'N/A') + '</td>';
            html += '<td>' + item.qty + '</td>';
            html += '<td>' + item.unit + '</td>';
            html += '<td>' + parseFloat(item.price).toFixed(2) + '</td>';
            html += '<td>' + parseFloat(item.amount).toFixed(2) + '</td>';
            html += '<td>' + item.narration + '</td>';
            html += '</tr>';
        });
        html += '</tbody></table>';
        return html;
    }

    // Prepare Data for JS
    var vouchersData = @json($vouchers);

    // Initialize DataTable
    var table = $('#voucherTable').DataTable({
        ordering: true,
        responsive: true,
        dom: 'Blfrtip',
        buttons: ['excel', 'pdf', 'print']
    });

    // Add event listener for opening and closing details
    $('#voucherTable tbody').on('click', 'td.details-control', function () {
        var tr = $(this).closest('tr');
        var row = table.row(tr);
        var rowIndex = row.index();
        var details = vouchersData[rowIndex].details;

        if (row.child.isShown()) {
            // Close row
            row.child.hide();
            tr.removeClass('shown');
        }
        else {
            // Open row
            row.child(format(details)).show();
            tr.addClass('shown');
        }
    });
});
</script>
@endpush
