@extends('layouts.master')

@section('content')
    <div class="az-content-breadcrumb">
        <span>Stock</span>
        <span>Edit Stock</span>
    </div>
    <h2 class="az-content-title" style="display: inline">Edit Product Stock
        <span>
            <a href="{{ route('products.stock.list', ['brand_id' => Crypt::encrypt($product->brands_id), 'product_id' => Crypt::encrypt($product->id_products)]) }}"
                class="btn border" style="float: right">
                <i class="fa-solid fa-bars-staggered"></i> Back to Stock
            </a>
        </span>
    </h2>
    <div class="separator-breadcrumb border-top"></div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Edit Stock Details</h5>

                    @if (Session::has('alert'))
                        <div class="alert alert-card alert-{{ Session::get('alert-class') }}" role="alert">
                            {{ Session::get('alert') }}
                            <button class="close" type="button" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif

                    <form action="{{ route('products.stocks.update', ['id_stock' => Crypt::encrypt($stock->id_stock), 'product_id' => Crypt::encrypt($product->id_products)]) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')

                        <input type="hidden" name="products_id" value="{{ $product->id_products }}">
                        <input type="hidden" name="brand_id" value="{{ $product->brands_id }}">

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Product Name</label>
                                    <input type="text" class="form-control" value="{{ $product->products_name }}" disabled>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Batch Number</label>
                                    <input type="text" class="form-control" name="stock_batch_number"
                                        value="{{ old('stock_batch_number', $stock->stock_batch_number) }}">
                                    @error('stock_batch_number')
                                        <span class="form-text text-danger">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Batch Date</label>
                                    <input type="date" class="form-control" name="stock_purchase_date"
                                        value="{{ old('stock_purchase_date', $stock->stock_purchase_date) }}" required>
                                    @error('stock_purchase_date')
                                        <span class="form-text text-danger">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Expiry Date</label>
                                    <input type="date" class="form-control" name="stock_expiry_date"
                                        value="{{ old('stock_expiry_date', $stock->stock_expiry_date) }}" required>
                                    @error('stock_expiry_date')
                                        <span class="form-text text-danger">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <button type="submit" class="btn btn-az-primary btn-block mt-2 float-end"><i class="fa-regular fa-floppy-disk"></i> <strong>Update</strong></button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
