<?php

use App\cities;
use App\cities_code;
use App\Http\Controllers\CountryController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\ServiceVendorController;
use App\Http\Controllers\PackagesController;
use App\Http\Controllers\EscellationsController;
use App\Http\Controllers\JobsController;
use App\Http\Controllers\DocumentationController;
use App\Http\Controllers\UsersController;
use App\Http\Controllers\ActivityController;
use App\Http\Controllers\ActivityscheduleController;
use App\Http\Controllers\AddonsController;
use App\Http\Controllers\LogViewerController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\CronJobController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\AjaxController;
use App\Http\Controllers\ApprovalGroupController;
use App\Http\Controllers\CampaignController;
use App\Http\Controllers\SalesController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\InquirytypesController;
use App\Http\Controllers\InquiryController;
use App\Http\Controllers\SalesreferenceController;
use App\Http\Controllers\CityController;
use App\Http\Controllers\CurrencyController;
use App\Http\Controllers\DepartmentsController;
use App\Http\Controllers\EscalationGroupController;
use App\Http\Controllers\FollowUpTypeController;
use App\Http\Controllers\MyJobController;
use App\Http\Controllers\OfficeWorkingHourController;
use App\Http\Controllers\OtherServiceController;
use App\Http\Controllers\PerformanceSlabController;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\TeamsJobsController;
use App\Http\Controllers\SecurityController;
use App\Http\Controllers\EscalationController;
use App\Http\Controllers\AccountsController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\Bank_accountsController;
use App\Http\Controllers\ChartOfAccountController;
use App\Http\Controllers\DesignationController;
use App\Http\Controllers\DiscountsController;
use App\Http\Controllers\EmployeeAttendanceController;
use App\Http\Controllers\GeneralPreferencesController;
// use App\Http\Controllers\Measurement_unitController;
use App\Http\Controllers\MeasurementUnitController;
use App\Http\Controllers\PayrollController;
// use App\Http\Controllers\Unit_typeController;
use App\Http\Controllers\ProductsCategoryController;
use App\Http\Controllers\PurchaserController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\ServicePurchaseController;
use App\Http\Controllers\ServiceVoucherController;
use App\Http\Controllers\UnitTypeController;
use App\Http\Controllers\VoucherController;
use App\roles;
use Illuminate\Support\Facades\DB as FacadesDB;
use Illuminate\Auth\Middleware;
use Illuminate\Support\Facades\Route;

Route::get('/clear-cache', function () {
    Artisan::call('cache:clear');
    Artisan::call('view:clear');
    session()->flash('success', 'System Cache Cleared!');
    return back();
});

Route::get('/', function () {
    return redirect('admin');
})->middleware('auth');

// $role = \App\Role::select('name')->get()->toArray();
//
//Route::group(['middleware' => ['auth', 'roles'],'roles' => $role], function () {
// Route::group(['middleware' => ['role:admin']], function () {
//Route::get('/home', function () {
//
//    //$role = \App\Role::select('name')->get()->toArray();
//    //return $role;exit;
//    if (!auth()->user()->role_id) {
//        echo "Role is not define for current user. Please contact administrator";
//        exit;
//        //Session::flash('message','Role is not define for current user. Please contact administrator');
//        //return redirect('/');
//    }
//    if (auth()->user()->role_id == 1) {
//        echo 'admin';
//        exit;
//        return redirect('admin'); // Admin role
//    } elseif (auth()->user()->role_id == 6) { //sales role
//        echo 'sales';
//        exit;
//        return redirect('sales');
//    }
//});
Route::get('account-settings', 'UsersController@getSettings');
Route::post('account-settings', 'UsersController@saveSettings');

//Route::get('get_inquiry_list', [InquiryController::class, 'get_inquiry_list']);
//Route::get('fetch_data/{page?}', [InquiryController::class, 'fetch_data']);
//Route::get('get_inquiry_remarks/{id?}', [InquiryController::class, 'get_inquiry_remarks']);
//});
// Route::group(['middleware' => ['role:']], function () {
//Core
Route::post('get-cities-by-country', [CustomerController::class, 'getCity']);
// Vendors
Route::get('/login', [SCustomerController::class, 'login']);
Route::get('/vendors', [ServiceVendorController::class, 'index']);
Route::get('/add_vendor_contact_details/{id}', [AjaxController::class, 'add_vendor_contact_details']);
Route::get('/vendors/edit/{id}', [ServiceVendorController::class, 'edit']);
Route::get('/vendors/create', [ServiceVendorController::class, 'create']);
Route::post('/vendors/store', [ServiceVendorController::class, 'store']);
Route::post('/vendors/update', [ServiceVendorController::class, 'update']);
Route::post('/vendors/destroy/{id}', [ServiceVendorController::class, 'destroy']);


// Packages
Route::get('/packages', [PackagesController::class, 'index']);
Route::get('/packages/edit/{id}', [PackagesController::class, 'edit']);
Route::get('/packages/create', [PackagesController::class, 'create']);
Route::post('/packages/store', [PackagesController::class, 'store']);
Route::post('/packages/update/{id}', [PackagesController::class, 'update']);
Route::post('/packages/delete/{id}', [PackagesController::class, 'destroy']);

// package_types
Route::get('/package_types', [PackagesController::class, 'package_types_index']);
Route::get('/package_types/edit/{id}', [PackagesController::class, 'package_types_edit']);
Route::get('/package_types/create', [PackagesController::class, 'package_types_create']);
Route::post('/package_types/store', [PackagesController::class, 'package_types_store']);
Route::post('/package_types/update/{id}', [PackagesController::class, 'package_types_update']);
Route::post('/package_types/delete/{id}', [PackagesController::class, 'package_types_destroy']);

// Inquiry Types
Route::get('/inquiry', [InquiryController::class, 'get_inquiry_list']);
Route::get('/get_followup_details/{id}', [AjaxController::class, 'get_followup_details']);
Route::get('/inquiry_edit/{inquiry_id}', [InquiryController::class, 'edit_inquiry_index']);
Route::get('/inquiry_ajax_list', [InquiryController::class, 'getdata']);
Route::get('/inquiry/create', [InquiryController::class, 'create']);
Route::post('/inquiry/store', [InquiryController::class, 'store']);
Route::post('add_inquiry_remarks', [InquiryController::class, 'add_inquiry_remarks']);
Route::post('add_followup_remarks', [InquiryController::class, 'add_followup_remarks']);
Route::post('inquiry_edit_update', [InquiryController::class, 'inquiry_edit_update']);
Route::get('append_services_edit/{inq_id}', [InquiryController::class, 'append_services_edit']);
Route::get('/edit_inquiry/{id}', 'InquiryController@edit')->name('edit_inquiry');
Route::post('/update_inquiry/{id}', 'InquiryController@update')->name('update_inquiry');
Route::get('/delete_inquiry/{id}', 'InquiryController@destroy')->name('delete_inquiry');
Route::get('/get_sub_services/{id}', 'AjaxController@get_sub_services')->name('get_sub_services');
Route::get('/get_sub_services_id/{id}/{inq_id}', 'AjaxController@get_sub_services_id');
Route::get('/add_more_services/{count}', 'AjaxController@add_more_services')->name('add_more_services');
Route::get('/add_more_services_users/{count}', 'AjaxController@add_more_services_users')->name('add_more_services_users');
Route::get('/get_campaign_data/{id}', 'AjaxController@get_campaign_data')->name('get_campaign_data');

Route::get('/followups', [MyJobController::class, 'followups']);

// Inquiry Types
Route::get('/inquiry_types', [InquirytypesController::class, 'index']);
Route::get('/inquiry_types/edit/{id}', [InquirytypesController::class, 'edit']);
Route::get('/inquiry_types/create', [InquirytypesController::class, 'create']);
Route::post('/inquiry_types/store', [InquirytypesController::class, 'store']);
Route::post('/inquiry_types/update/{id}', [InquirytypesController::class, 'update']);
Route::post('/inquiry_types/delete/{id}', [InquirytypesController::class, 'destroy']);

//Notifications Crud
Route::get('/notifications', [App\Http\Controllers\NotificationController::class, 'index']);
Route::get('/team_notifications', [App\Http\Controllers\NotificationController::class, 'team_index']);
Route::get('/escalation_notifications', [App\Http\Controllers\NotificationController::class, 'escalation_index']);
Route::get('/get_escalations_data', [AjaxController::class, 'get_escalations_data']);
Route::get('/issuance_notifications', [App\Http\Controllers\NotificationController::class, 'issuance_index']);
Route::get('/approval_notifications', [App\Http\Controllers\NotificationController::class, 'approval_index']);
// Notifcation Work for My Jobs
Route::get('get_notifications_my_jobs', [App\Http\Controllers\NotificationController::class, 'get_notifications_my_jobs']);
Route::get('get_noti_count_my_jobs/{count?}', [App\Http\Controllers\NotificationController::class, 'get_noti_count_my_jobs']);
Route::get('notification_read_my_jobs/{id}', [App\Http\Controllers\NotificationController::class, 'notification_read_my_jobs']);
Route::get('get_notifications_data', 'AjaxController@getnotificationsData')->name('get_notifications_data');

// Paymennts Notification
Route::get('get_notifications_payments', [App\Http\Controllers\NotificationController::class, 'get_notifications_payments']);
Route::get('get_noti_count_payments/{count?}', [App\Http\Controllers\NotificationController::class, 'get_noti_count_payments']);
Route::get('notification_read_payments/{id}', [App\Http\Controllers\NotificationController::class, 'notification_read_payments']);
// General Notification
Route::get('get_notifications_general', [NotificationController::class, 'get_notifications_general']);
Route::get('get_noti_count_general/{count?}', [NotificationController::class, 'get_noti_count_general']);
Route::get('notification_read_general/{id}', [NotificationController::class, 'notification_read_general']);

Route::get('get_notifications_team', [NotificationController::class, 'get_notifications_team']);
Route::get('get_noti_count_team/{count?}', [NotificationController::class, 'get_noti_count_team']);
Route::get('notification_read_team/{id}', [NotificationController::class, 'notification_read_team']);
Route::get('get_team_notifications_data', 'AjaxController@getteamnotificationsData')->name('get_team_notifications_data');

// Escalation Notification
Route::get('get_escalations', [NotificationController::class, 'get_escalations']);
Route::get('get_escalations_count/{count?}', [NotificationController::class, 'get_escalations_count']);
Route::get('escalations_read/{id}', [NotificationController::class, 'escalations_read']);
Route::get('/escalation_preferences', [EscalationController::class, 'preferences']);


// Quoatation Approval notifications
Route::get('get_approval_data', 'AjaxController@getapprovalData')->name('get_approval_data');
Route::get('get_approvals', [NotificationController::class, 'get_approvals']);
Route::get('get_approvals_count/{count?}', [NotificationController::class, 'get_approvals_count']);
Route::get('get_approvals_read/{id}', [NotificationController::class, 'get_approvals_read']);

// Quoatation Issuance notifications
Route::get('get_issuance_data', 'AjaxController@getissuanceData')->name('get_issuance_data');
Route::get('get_issuance', [NotificationController::class, 'get_issuance']);
Route::get('get_issuance_count/{count?}', [NotificationController::class, 'get_issuance_count']);
Route::get('get_issuance_read/{id}', [NotificationController::class, 'get_issuance_read']);



Route::get('send_noti_test', [NotificationController::class, 'test']);

// Security For Lock Screen

Route::get('lock_screen_auto/{type}', [App\Http\Controllers\SecurityController::class, 'lock_screen_auto']);
Route::post('check_pincode', [App\Http\Controllers\SecurityController::class, 'check_pincode']);

// Customer Routes
Route::get('customers', [CustomerController::class, 'index']);
Route::get('customers/create', [CustomerController::class, 'create']);
Route::post('customers/store', [CustomerController::class, 'store'])->name('customers.store');
Route::get('get-data', [AjaxController::class, 'getData']);
Route::get('get-customer-data', [AjaxController::class, 'customerSearch']);
Route::get('get-supplier-data', [AjaxController::class, 'supplierSearch']);
Route::get('get_customer_details', [AjaxController::class, 'get_customer_details']);
Route::get('check_customer_number/{cell}', [AjaxController::class, 'check_customer_number']);
Route::get('customer_list/{query?}', [AjaxController::class, 'customer_search']);
Route::get('customers/destroy/{id}', [CustomerController::class, 'destroy']);
Route::get('customers/edit/{id}', [CustomerController::class, 'edit']);
Route::post('customers/update/{id}', [CustomerController::class, 'update']);
Route::get('customers/view/{id}', [CustomerController::class, 'view']);
Route::get('print/{id}', [App\Http\Controllers\CustomerController::class, 'print'])->name('cvoucher.print');

// Sale References
Route::get('/sales_references', [SalesreferenceController::class, 'index']);
Route::get('/sales_references/edit/{id}', [SalesreferenceController::class, 'edit']);
Route::get('/sales_references/create', [SalesreferenceController::class, 'create']);
Route::post('/sales_references/store', [SalesreferenceController::class, 'store']);
Route::post('/sales_references/update/{id}', [SalesreferenceController::class, 'update']);
Route::post('/sales_references/delete/{id}', [SalesreferenceController::class, 'destroy']);

// Departmetns
Route::get('/departments', [DepartmentsController::class, 'index'])->name('departments.index');
Route::get('/departments/edit/{id}', [DepartmentsController::class, 'edit'])->name('departments.edit');
Route::get('/departments/create', [DepartmentsController::class, 'create']);
Route::post('/departments/store', [DepartmentsController::class, 'store'])->name('departments.store');
Route::post('/departments/update/{id}', [DepartmentsController::class, 'update']);
Route::get('/departments/delete/{id}', [DepartmentsController::class, 'destroy']);
Route::get('/remove_department_user/{u_id}/{d_id}', [DepartmentsController::class, 'remove_department_user']);
Route::post('/assign_user_teams', [DepartmentsController::class, 'assign_user_teams']);
Route::post('/assign_services_department', [DepartmentsController::class, 'assign_services_department']);
Route::post('/add_department_teams', [DepartmentsController::class, 'add_department_teams']);
Route::GET('/get_department_users/{dep_id}', [AjaxController::class, 'get_department_users']);

// escellations
Route::get('/escellations', [EscellationsController::class, 'index']);
Route::get('/escellations/edit/{id}', [EscellationsController::class, 'edit']);
Route::get('/escellations/create', [EscellationsController::class, 'create']);
Route::post('/escellations/store', [EscellationsController::class, 'store']);
Route::post('/escellations/update/{id}', [EscellationsController::class, 'update']);
Route::post('/escellations/delete/{id}', [EscellationsController::class, 'destroy']);

// Jobs
Route::get('/jobs', [JobsController::class, 'index']);
Route::get('/jobs/edit/{id}', [JobsController::class, 'edit']);
Route::get('/jobs/create', [JobsController::class, 'create']);
Route::post('/jobs/store', [JobsController::class, 'store']);
Route::post('/jobs/update/{id}', [JobsController::class, 'update']);
Route::post('/jobs/delete/{id}', [JobsController::class, 'destroy']);

//Users Routes
Route::get('users', [UsersController::class, 'index']);
Route::get('users/create', [UsersController::class, 'create']);
Route::post('users/store', [UsersController::class, 'store']);
Route::get('users/edit/{id}', [UsersController::class, 'edit']);
Route::post('users/update/{id}', [UsersController::class, 'update']);
Route::get('my_profile', [UsersController::class, 'profile_index']);

//Roles
Route::get('/roles', [RoleController::class, 'index']);
Route::get('/roles/add', [RoleController::class, 'create']);
Route::post('/roles/store/', [RoleController::class, 'store']);
Route::get('/roles/edit/{id}', [RoleController::class, 'edit']);
Route::post('/roles/edit/{id}', [RoleController::class, 'update']);
Route::post('/roles/delete', [RoleController::class, 'destroy']);

// Cities Routes
Route::get('/cities', [CityController::class, 'index']);
Route::get('/city/create', [CityController::class, 'create']);
Route::post('/city/store', [CityController::class, 'store']);
Route::get('/city/edit/{id}', [CityController::class, 'edit']);
Route::put('/city/update/{id}', [CityController::class, 'update']);
Route::delete('/city/delete/{id}', [CityController::class, 'destroy']); // Changed to DELETE method

// General Preferences Routes
Route::get('/general_preferences', [GeneralPreferencesController::class, 'index']);
Route::get('/general_preferences/create', [GeneralPreferencesController::class, 'create']);
Route::post('/general_preferences/store', [GeneralPreferencesController::class, 'store']);
Route::get('/general_preferences/edit/{id}', [GeneralPreferencesController::class, 'edit']);
Route::post('/general_preferences/update/{id}', [GeneralPreferencesController::class, 'update']);
Route::delete('/general_preferences/delete/{id}', [GeneralPreferencesController::class, 'destroy']); // Changed to DELETE method

//Countries
Route::get('/countries', [CountryController::class, 'index']);
Route::get('countries/create', [CountryController::class, 'create']);

//Admin Controller
Route::get('admin', [AdminController::class, 'index']);
Route::get('accounts_dashboard', [AdminController::class, 'account']);
Route::get('manager_dashboard', [AdminController::class, 'manager']);
Route::get('sales_dashboard', [AdminController::class, 'sale']);
Route::post('addTask', [AdminController::class, 'addTask']);
Route::post('deleteTask', [AdminController::class, 'deleteTask']);
Route::get('viewTask/{id}', [AdminController::class, 'viewTask']);

//Admin Controller
// Route::get('sales', [SalesController::class, 'index']);
// Route::post('addTask', [SalesController::class, 'addTask']);
// Route::post('deleteTask', [SalesController::class, 'deleteTask']);
// Route::get('viewTask/{id}', [SalesController::class, 'viewTask']);

//Permission management
Route::get('permission-management', [PermissionController::class, 'index']);
Route::get('permission/create', [PermissionController::class, 'create']);
Route::post('permission/create', [PermissionController::class, 'save']);
Route::get('permission/delete/{id}', [PermissionController::class, 'delete']);
Route::get('permission/edit/{id}', [PermissionController::class, 'edit']);
Route::post('permission/edit/{id}', [PermissionController::class, 'update']);

//Activity log
Route::get('activity-log', [LogViewerController::class, 'getActivityLog']);
Route::get('activity-log/data', [LogViewerController::class, 'data']);

//Log Viewer
//    Route::get('log-viewers', [\Arcanedev\LogViewer\Http\Controllers\LogViewerController@index::class, 'log-viewers']);
//    Route::get('log-viewers/logs', [\Arcanedev\LogViewer\Http\Controllers\LogViewerController@listLogs::class, 'log-viewers.logs']);
//    Route::delete('log-viewers/logs/delete', [\Arcanedev\LogViewer\Http\Controllers\LogViewerController@delete::class, 'log-viewers.logs.delete']);
//    Route::get('log-viewers/logs/{date}', [\Arcanedev\LogViewer\Http\Controllers\LogViewerController@show::class, 'log-viewers.logs.show']);
//    Route::get('log-viewers/logs/{date}/download', [\Arcanedev\LogViewer\Http\Controllers\LogViewerController@download::class, 'log-viewers.logs.download']);
//    Route::get('log-viewers/logs/{date}/{level}', [\Arcanedev\LogViewer\Http\Controllers\LogViewerController@showByLevel::class, 'log-viewers.logs.filter']);
//    Route::get('log-viewers/logs/{date}/{level}/search', [\Arcanedev\LogViewer\Http\Controllers\LogViewerController@search::class, 'log-viewers.logs.search']);
//    Route::get('log-viewers/logcheck', [\Arcanedev\LogViewer\Http\Controllers\LogViewerController@logCheck::class, 'log-viewers.logcheck']);
// Cost Center Routes
//    Route::get('/cost_center', [CostCenterController@index::class, 'cost_center']);
//    Route::get('/create_cost_center', [CostCenterController@create::class, 'create_cost_center']);
//    Route::post('/store_cost_center', [CostCenterController@store::class, 'store_cost_center']);
//    Route::get('/edit_cost_center/{id}', [CostCenterController@edit::class, 'edit_cost_center']);
//    Route::post('/update_cost_center/{id}', [CostCenterController@update::class, 'update_cost_center']);
//    Route::get('/delete_cost_center/{id}', [CostCenterController@destroy::class, 'delete_cost_center']);
// Activity Routes
Route::get('/activity', [ActivityController::class, 'index']);
Route::get('/create_activity', [ActivityController::class, 'create']);
Route::post('/store_activity', [ActivityController::class, 'store']);
Route::get('/edit_activity/{id}', [ActivityController::class, 'edit']);
Route::post('/update_activity/{id}', [ActivityController::class, 'update']);
Route::get('/delete_activity/{id}', [ActivityController::class, 'destroy']);

//Activity schedule routes
Route::get('/activity/schedule', [ActivityscheduleController::class, 'trainings/schedule']);
Route::get('/activity/schedule/create/{id}', [ActivityscheduleController::class, 'trainings/schedule/create']);
Route::post('/activity/schedule/store', [ActivityscheduleController::class, 'trainings/schedule/store']);
Route::post('/activity/getCustomersBySaleman', [ActivityscheduleController::class, 'activity/getCustomersBySaleman']);
Route::post('/activity/schedule/data', [ActivityscheduleController::class, 'activity/schedule/data']);
Route::post('/activity/schedule/update/time', [ActivityscheduleController::class, 'activity/schedule/update/time']);
Route::post('/activity/schedule/update/date', [ActivityscheduleController::class, 'activity/schedule/update/date']);
Route::post('/activity/schedule/edit/status/{id}', [ActivityscheduleController::class, 'activity/schedule/edit/status']);
Route::put('/activity/schedule/edit/status', [ActivityscheduleController::class, 'activity/schedule/edit/status']);
Route::post('/activity/schedule/comments', [ActivityscheduleController::class, 'activity/schedule/comments']);
Route::post('/activity/schedule/comments/insert', [ActivityscheduleController::class, 'activity/schedule/comments/insert']);
Route::post('/activity/schedule/edit', [ActivityscheduleController::class, 'activity/schedule/edit']);
Route::put('/activity/schedule/edit', [ActivityscheduleController::class, 'activity/schedule/edit']);

//FileUpload & Attachments
Route::get('/fileupload', [FileUploadController::class, 'index']);
Route::post('/fileupload', [FileUploadController::class, 'index']);
Route::get('/create_fileupload', [FileUploadController::class, 'create']);
Route::post('/create_fileupload', [FileUploadController::class, 'store']);
Route::get('/viewfileupload', [FileUploadController::class, 'viewFile']);
Route::get('/delete_file_upload/{id}', [FileUploadController::class, 'destroy']);
Route::post('/sharedwith', [FileUploadController::class, 'sharedwith']);
Route::post('/getusersforupload', [FileUploadController::class, 'getusers']);
Route::get('/sharedwithmelist', [FileUploadController::class, 'sharedwithmelist']);
Route::get('/sharewithmeview/{fileid}', [FileUploadController::class, 'sharewithmeview']);

//Permission
// Route::get('/roles/permission/{id}', [PermissionController::class, 'index']);
// Route::post('/roles/permission/{id}', [PermissionController::class, 'store']);
Route::get('roles/permission/{id?}', [PermissionController::class, 'index']);
Route::post('roles/permission/{role_id}', [PermissionController::class, 'store']);
// Route::get('roles/acc_permission/{id?}', [PermissionController::class, 'accindex']);
Route::post('roles/acc_permission/{role_id}', [PermissionController::class, 'accstore']);
// Route::post('roles/permission/acc/{arole_id}', [PermissionController::class, 'store_acc_per']);

Route::post('/transaction-account/toggle-status', [PermissionController::class, 'toggleTransactionAccountStatus'])->name('account.toggle-status');


Route::get('logout', [LoginController::class, 'logout']);
Route::get('cronjob', [CronJobController::class, 'run']);



// Office Working Hour
Route::get('/office_working_hours', [OfficeWorkingHourController::class, 'index']);
Route::get('/office_working_hours/edit/{id}', [OfficeWorkingHourController::class, 'edit']);
Route::get('/office_working_hours/create', [OfficeWorkingHourController::class, 'create']);
Route::post('/office_working_hours/store', [OfficeWorkingHourController::class, 'store']);
Route::post('/office_working_hours/update/{id}', [OfficeWorkingHourController::class, 'update']);
Route::post('/office_working_hours/delete/{id}', [OfficeWorkingHourController::class, 'destroy']);

// Follow Up TYpes
Route::get('/follow_up_types', [FollowUpTypeController::class, 'index']);
Route::get('/follow_up_types/edit/{id}', [FollowUpTypeController::class, 'edit']);
Route::get('/follow_up_types/create', [FollowUpTypeController::class, 'create']);
Route::post('/follow_up_types/store', [FollowUpTypeController::class, 'store']);
Route::post('/follow_up_types/update/{id}', [FollowUpTypeController::class, 'update']);
Route::post('/follow_up_types/delete/{id}', [FollowUpTypeController::class, 'destroy']);
// Performance Slabs
Route::get('/performance_slabs', [PerformanceSlabController::class, 'index']);
Route::get('/performance_slabs/edit/{id}', [PerformanceSlabController::class, 'edit']);
Route::get('/performance_slabs/create', [PerformanceSlabController::class, 'create']);
Route::post('/performance_slabs/store', [PerformanceSlabController::class, 'store']);
Route::post('/performance_slabs/update/{id}', [PerformanceSlabController::class, 'update']);
Route::post('/performance_slabs/delete/{id}', [PerformanceSlabController::class, 'destroy']);
// Other Serviees
Route::get('/other_services', [OtherServiceController::class, 'index']);
Route::get('/other_services/edit/{id}', [OtherServiceController::class, 'edit']);
Route::get('/other_services/create', [OtherServiceController::class, 'create']);
Route::post('/other_services/store', [OtherServiceController::class, 'store']);
Route::post('/other_services/update/{id}', [OtherServiceController::class, 'update']);
Route::post('/other_services/delete/{id}', [OtherServiceController::class, 'destroy']);

// Camapaign
Route::get('/campaigns', [CampaignController::class, 'index']);
Route::get('/campaigns/edit/{id}', [CampaignController::class, 'edit']);
Route::get('/campaigns/create', [CampaignController::class, 'create']);
Route::post('/campaigns/store', [CampaignController::class, 'store']);
Route::post('/campaigns/update/{id}', [CampaignController::class, 'update']);
Route::get('/campaigns/delete/{id}', [CampaignController::class, 'destroy']);
// Approval Group
Route::get('/approval_group', [ApprovalGroupController::class, 'index']);
Route::get('/approval_group/edit/{id}', [ApprovalGroupController::class, 'edit']);
Route::get('/approval_group/create', [ApprovalGroupController::class, 'create']);
Route::post('/approval_group/store', [ApprovalGroupController::class, 'store']);
Route::post('/approval_group/update/{id}', [ApprovalGroupController::class, 'update']);
Route::get('/approval_group/delete/{id}', [ApprovalGroupController::class, 'destroy']);
// Excilation Group
Route::get('/escalation_group', [EscalationGroupController::class, 'index']);
Route::get('/escalation_group/edit/{id}', [EscalationGroupController::class, 'edit']);
Route::get('/escalation_group/create', [EscalationGroupController::class, 'create']);
Route::post('/escalation_group/store', [EscalationGroupController::class, 'store']);
Route::post('/escalation_group/update/{id}', [EscalationGroupController::class, 'update']);
Route::get('/escalation_group/delete/{id}', [EscalationGroupController::class, 'destroy']);
// My Teams Jobs
Route::get('/my_teams_jobs', [TeamsJobsController::class, 'index']);
Route::post('/take_my_team_job', [TeamsJobsController::class, 'take_my_team_job']);
Route::post('/assign_my_team_job', [TeamsJobsController::class, 'assign_my_team_job']);
// My  Jobs
Route::get('/my_jobs', [MyJobController::class, 'index']);
Route::get('/my_jobs/create/{inq_id}/{team_id}', [MyJobController::class, 'create']);
Route::post('/assign_job', [MyJobController::class, 'assign_job']);
// Accounts
// Route::get('/quotation_invoices', [AccountsController::class, 'index']);
Route::get('/payment_invoice_list', [AccountsController::class, 'payment_invoice_list']);
Route::get('/pending_payment_list', [AccountsController::class, 'pending_payment_list']);
Route::get('/cheque_list', [AccountsController::class, 'cheque_list']);
Route::get('/roe_difference_list', [AccountsController::class, 'roe_difference_list']);
Route::get('/accounts_issuance_list', [AccountsController::class, 'accounts_issuance_list']);
Route::get('/get_pay_quotation_details/{q_id}', [AjaxController::class, 'get_pay_quotation_details']);
Route::get('/onchange_amount_val/{q_id}', [AjaxController::class, 'onchange_amount_val']);

// get inventory
Route::get('/get_inventory_details_airline/{airline_id}/{append_count}/{inq_id}', [AjaxController::class, 'get_inventory_details_airline']);
Route::get('/get_inventory_details_hotel/{hotel_id}/{append_count}/{inq_id}', [AjaxController::class, 'get_inventory_details_hotel']);
Route::get('/get_hotel_available_rooms/{hotel_id}/{append_count}/{inq_id}', [AjaxController::class, 'get_hotel_available_rooms']);
Route::get('/add_airline_inv_details/{inv_id}/{append_count}', [AjaxController::class, 'add_airline_inv_details']);
Route::get('/add_hotel_inv_details/{inv_id}/{append_count}', [AjaxController::class, 'add_hotel_inv_details']);
Route::get('/get_addons/{array_ids}', [AjaxController::class, 'get_addons']);

// Parsing Ajax
Route::get('/parsing_details/{append_count}', [AjaxController::class, 'parsing_details']);
Route::get('/get_team_users/{id}', [AjaxController::class, 'get_team_users']);
// Route::get('/update_DB', function () {
//     $get_cities = cities::all();
//     foreach ($get_cities as $i) {
//         $get_ci = cities_code::where('name', $i->name)->first();
//         dd($get_ci);
//     }
// });

// Route::get('/change_flight_class/{airline_inv_id}/{flight_class}', [AjaxController::class, 'change_flight_class']);



//});

Auth::routes();


//currency Exchange
Route::get('/currency_exchange', [CurrencyController::class, 'index']);
Route::get('/currency_exchange/create', [CurrencyController::class, 'create']);
Route::post('/currency_exchange/store', [CurrencyController::class, 'store']);
Route::get('/currency_exchange/edit/{id}', [CurrencyController::class, 'edit']);
Route::post('/currency_exchange/update/{id}', [CurrencyController::class, 'update']);

// My Bank Account Route Start
Route::get('/my_bank_accounts', [Bank_accountsController::class, 'index']);
Route::get('/my_bank_accounts/create', [Bank_accountsController::class, 'create']);
Route::post('/my_bank_accounts/store', [Bank_accountsController::class, 'store']);
Route::get('/my_bank_accounts/edit/{id}', [Bank_accountsController::class, 'edit']);
Route::post('/my_bank_accounts/update/{id}', [Bank_accountsController::class, 'update']);

// My Bank Account Route End

// Escalation Work
Route::get('/escalation_timer_for_not_assign', [EscalationController::class, 'escalation_timer_for_not_assign']);
Route::get('/escalation_timer_for_open', [EscalationController::class, 'escalation_timer_for_open']);


// Doucmentation
Route::post('/add_documentation', [DocumentationController::class, 'add_documentation']);
// Payments Quotation
Route::post('/pay_quotation_amount', [PaymentController::class, 'pay_quotation_amount']);
// Account Payment
Route::get('/view_invoice_payment_details/{id}', [AjaxController::class, 'view_invoice_payment_details']);
Route::post('/update_receiving_number', [AccountsController::class, 'update_receiving_number']);

// Update Quotation Cost Price Of Sale Person
// Route::get('/update_cost_price_sale_person', [QuotationApprovalController::class, 'update_cost_price_sale_person']);
Route::post('/update_cost_price_sale_person', [QuotationApprovalController::class, 'update_cost_price_sale_person']);
Route::post('/update_cost_price_sale_person', [QuotationApprovalController::class, 'update_cost_price_sale_person']);

// Customer Verification
Route::get('/customer_verification/{q_id}', [QuotationApprovalController::class, 'customer_verification']);


// New Work Start From Here For MDS Sabzi Mandi

Route::get('/measurement_unit', [MeasurementUnitController::class, 'index']);
Route::get('/measurement_unit/create', [MeasurementUnitController::class, 'create']);
Route::post('/measurement_unit/store', [MeasurementUnitController::class, 'store']);
Route::get('/measurement_unit/edit/{id}', [MeasurementUnitController::class, 'edit']);
Route::post('/measurement_unit/update/{id}', [MeasurementUnitController::class, 'update']);
Route::post('/measurement_unit/delete/{id}', [MeasurementUnitController::class, 'destroy']);

Route::get('unit_type', [UnitTypeController::class, 'index'])->name('unit_type.index');
Route::get('unit_type/create', [UnitTypeController::class, 'create'])->name('unit_type.create');
Route::post('unit_type/store', [UnitTypeController::class, 'store'])->name('unit_type.store');
Route::get('unit_type/{id}/edit', [UnitTypeController::class, 'edit'])->name('unit_type.edit');
Route::put('unit_type/update/{id}', [UnitTypeController::class, 'update'])->name('unit_type.update');
Route::post('/unit_type/delete/{id}', [UnitTypeController::class, 'destroy']);

// Route::get('/unit_type', [Unit_typeController::class, 'index']);
// Route::get('/unit_type/create', [Unit_typeController::class, 'create']);
// Route::post('/unit_type/store', [Unit_typeController::class, 'store']);
// Route::get('/unit_type/edit/{id}', [Unit_typeController::class, 'edit']);
// Route::post('/unit_type/update/{id}', [Unit_typeController::class, 'update']);

Route::get('/discounts', [DiscountsController::class, 'index']);
Route::get('/discounts/create', [DiscountsController::class, 'create']);
Route::post('/discounts/store', [DiscountsController::class, 'store']);
Route::get('/discounts/edit/{id}', [DiscountsController::class, 'edit']);
Route::post('/discounts/update/{id}', [DiscountsController::class, 'update']);
Route::post('/discounts/delete/{id}', [DiscountsController::class, 'destroy']);

Route::get('product_cate_main/list', [ProductsCategoryController::class, 'index']);
Route::get('product_cate_main/create', [ProductsCategoryController::class, 'create']);
Route::post('product_cate_main/store', [ProductsCategoryController::class, 'store']);
Route::get('product_cate_main/edit/{id}', [ProductsCategoryController::class, 'edit']);
Route::post('product_cate_main/update/{id}', [ProductsCategoryController::class, 'update']);
Route::post('product_cate_main/destroy/{id}', [ProductsCategoryController::class, 'destroy']);

Route::get('product_cate_parent/list/{id}', [ProductsCategoryController::class, 'product_cate_parent_list'])->name('product_sub_cat');
Route::post('product_cate_parent/store', [ProductsCategoryController::class, 'product_cate_parent_store']);
Route::post('product_cate_parent/update/{id}', [ProductsCategoryController::class, 'product_cate_parent_update']);
Route::post('product_cate_parent/destroy/{id}', [ProductsCategoryController::class, 'product_cate_parent_destroy']);

Route::get('product_cate_child/list/{p_id}/{id}', [ProductsCategoryController::class, 'product_cate_child_list']);
Route::post('product_cate_child/store', [ProductsCategoryController::class, 'product_cate_child_store']);
Route::post('product_cate_child/update/{id}', [ProductsCategoryController::class, 'product_cate_child_update']);
Route::post('product_cate_child/destroy/{id}', [ProductsCategoryController::class, 'product_cate_child_destroy']);

Route::get('products_all', [ProductsCategoryController::class, 'allProducts'])->name('products.all');

// Brands Route
// Route::group(['prefix' => 'brands', 'middleware' => ['auth']], function () {
//     Route::get('list', [App\Http\Controllers\BrandsController::class, 'index'])->name('brands.list');
//     Route::get('create', [App\Http\Controllers\BrandsController::class, 'create'])->name('brands.create');
//     Route::post('store', [App\Http\Controllers\BrandsController::class, 'store'])->name('brand.store');
//     Route::get('edit/{id}', [App\Http\Controllers\BrandsController::class, 'edit'])->name('brand.edit');
//     Route::put('update/{id}', [App\Http\Controllers\BrandsController::class, 'update'])->name('brand.update');
//     Route::post('destroy/{id}', [App\Http\Controllers\BrandsController::class, 'destroy'])->name('brand.destroy');
// });

// Products Route
// Route::group(['prefix' => 'products', 'middleware' => ['auth']], function () {
//     Route::get('list/{id}', [App\Http\Controllers\ProductsController::class, 'index'])->name('products.list');
//     Route::get('list', [App\Http\Controllers\ProductsController::class, 'allProducts'])->name('products.all');
//     Route::get('create/{id}', [App\Http\Controllers\ProductsController::class, 'create'])->name('products.create');
//     Route::post('store', [App\Http\Controllers\ProductsController::class, 'store'])->name('products.store');
//     Route::get('edit/{id}', [App\Http\Controllers\ProductsController::class, 'edit'])->name('products.edit');
//     Route::put('update/{id}', [App\Http\Controllers\ProductsController::class, 'update'])->name('products.update');
//     Route::post('destroy/{id}', [App\Http\Controllers\ProductsController::class, 'destroy'])->name('products.destroy');
//     Route::get('images-view/{id}', [App\Http\Controllers\ProductsController::class, 'imagesView'])->name('products.images.view');
//     Route::get('images/delete/{id}', [App\Http\Controllers\ProductsController::class, 'deleteImage'])->name('products.images.delete');
//     Route::get('images/delete-all/{id}', [App\Http\Controllers\ProductsController::class, 'deleteAllImages'])->name('products.images.delete.all');
// });

// // Products Stocks Route
// Route::group(['prefix' => 'products-stock', 'middleware' => ['auth']], function () {
//     Route::get('list/{brand_id}/{product_id}', [App\Http\Controllers\StocksController::class, 'index'])->name('products.stock.list');
//     Route::get('create/{brand_id}/{product_id}', [App\Http\Controllers\StocksController::class, 'create'])->name('products.stocks.create');
// });
// Products Stocks Route
// Route::group(['prefix' => 'products-stock', 'middleware' => ['auth']], function () {
//     Route::get('list/{brand_id}/{product_id}', [App\Http\Controllers\StocksController::class, 'index'])->name('products.stock.list');
//     Route::get('create/{brand_id}/{product_id}', [App\Http\Controllers\StocksController::class, 'create'])->name('products.stocks.create');
//     Route::post('store', [App\Http\Controllers\StocksController::class, 'store'])->name('products.stocks.store');
//     Route::get('edit/{id_stock}/{product_id}', [App\Http\Controllers\StocksController::class, 'edit'])->name('products.stocks.edit');
//     Route::put('update/{id_stock}/{product_id}', [App\Http\Controllers\StocksController::class, 'update'])->name('products.stocks.update');
//     Route::get('increase/{id_stock}/{product_id}', [App\Http\Controllers\StocksController::class, 'increase'])->name('products.stocks.increase');
//     Route::put('increase/{id_stock}/{product_id}', [App\Http\Controllers\StocksController::class, 'increaseStock'])->name('products.stocks.increase');
//     Route::get('damage/{id_stock}/{product_id}', [App\Http\Controllers\StocksController::class, 'damage'])->name('products.stocks.damage');
//     Route::put('damage/{id_stock}/{product_id}', [App\Http\Controllers\StocksController::class, 'addDamage'])->name('products.stocks.damage');
// });
Route::group(['prefix' => 'products-stock', 'middleware' => ['auth']], function () {
    Route::get('list/{brand_id}/{product_id}', [App\Http\Controllers\StocksController::class, 'index'])->name('products.stock.list');
    Route::get('create/{brand_id}/{product_id}', [App\Http\Controllers\StocksController::class, 'create'])->name('products.stocks.create');
    Route::post('store', [App\Http\Controllers\StocksController::class, 'store'])->name('products.stocks.store');
    Route::get('edit/{id_stock}/{product_id}', [App\Http\Controllers\StocksController::class, 'edit'])->name('products.stocks.edit');
    Route::put('update/{id_stock}/{product_id}', [App\Http\Controllers\StocksController::class, 'update'])->name('products.stocks.update');
    Route::get('increase/{id_stock}/{product_id}', [App\Http\Controllers\StocksController::class, 'increase'])->name('products.stocks.increase');
    Route::put('increase/{id_stock}/{product_id}', [App\Http\Controllers\StocksController::class, 'increaseStock'])->name('products.stocks.increaseStock');
    Route::get('damage/{id_stock}/{product_id}', [App\Http\Controllers\StocksController::class, 'damage'])->name('products.stocks.damage');
    Route::put('damage/{id_stock}/{product_id}', [App\Http\Controllers\StocksController::class, 'addDamage'])->name('products.stocks.addDamage');
});

Route::get('/employee', [App\Http\Controllers\EmployeesController::class, 'index'])->name('employees.index');
Route::get('/employee/create', [App\Http\Controllers\EmployeesController::class, 'create'])->name('employees.create');
Route::post('/employee/store', [App\Http\Controllers\EmployeesController::class, 'store'])->name('employees.store');
Route::get('/employee/edit/{id}', [App\Http\Controllers\EmployeesController::class, 'edit'])->name('employees.edit');
Route::post('/employee/update/{id}', [App\Http\Controllers\EmployeesController::class, 'update'])->name('employees.update');
Route::post('/employee/delete/{id}', [App\Http\Controllers\EmployeesController::class, 'destroy'])->name('employees.destroy');

Route::group(['prefix' => 'notification_management', 'middleware' => ['auth']], function () {
    Route::get('list', [App\Http\Controllers\NotificationManagementController::class, 'index'])->name('notification.list');
    Route::get('create', [App\Http\Controllers\NotificationManagementController::class, 'create'])->name('notification.create');
    Route::post('store', [App\Http\Controllers\NotificationManagementController::class, 'store'])->name('notification.store');
    Route::get('edit/{id}', [App\Http\Controllers\NotificationManagementController::class, 'edit'])->name('notification.edit');
    Route::put('update/{id}', [App\Http\Controllers\NotificationManagementController::class, 'update'])->name('notification.update');
    Route::get('destroy/{id}', [App\Http\Controllers\NotificationManagementController::class, 'destroy'])->name('notification.destroy');
});
// Invoice Route
Route::group(['prefix' => 'invoice', 'middleware' => ['auth']], function () {
    Route::get('list', [App\Http\Controllers\InvoiceController::class, 'index'])->name('invoice.list');
    Route::get('create', [App\Http\Controllers\InvoiceController::class, 'create'])->name('invoice.create');
    Route::post('store', [App\Http\Controllers\InvoiceController::class, 'store'])->name('invoice.store');
    Route::get('edit/{id}', [App\Http\Controllers\InvoiceController::class, 'edit'])->name('invoice.edit');
    Route::post('update/{id}', [App\Http\Controllers\InvoiceController::class, 'update'])->name('invoice.update');
    Route::get('destroy/{id}', [App\Http\Controllers\InvoiceController::class, 'destroy'])->name('invoice.destroy');
});

// Supplier Route
Route::group(['prefix' => 'supplier', 'middleware' => ['auth']], function () {
    Route::get('list', [App\Http\Controllers\SupplierController::class, 'index'])->name('supplier.list');
    Route::get('create', [App\Http\Controllers\SupplierController::class, 'create'])->name('supplier.create');
    Route::post('store', [App\Http\Controllers\SupplierController::class, 'store'])->name('supplier.store');
    Route::post('supplier/assign-brand', [App\Http\Controllers\SupplierController::class, 'assignBrand'])->name('supplier.assign.brand');
    Route::get('edit/{id}', [App\Http\Controllers\SupplierController::class, 'edit'])->name('supplier.edit');
    Route::post('update/{id}', [App\Http\Controllers\SupplierController::class, 'update'])->name('supplier.update');
    Route::post('destroy/{id}', [App\Http\Controllers\SupplierController::class, 'destroy'])->name('supplier.destroy');
    Route::get('supplier-view/{id}', [App\Http\Controllers\SupplierController::class, 'view'])->name('supplier.view');
    Route::get('print/{id}', [App\Http\Controllers\SupplierController::class, 'print'])->name('svoucher.print');




    // brand for supplier
    Route::get('brand/{id}', [App\Http\Controllers\SupplierController::class, 'brand'])->name('supplier.brand');
    Route::get('brand_create/{id}', [App\Http\Controllers\SupplierController::class, 'brand_create'])->name('supplier.brand_create');
    Route::post('brand_store', [App\Http\Controllers\SupplierController::class, 'brand_store'])->name('supplier.brand_store');
    Route::post('brand_destroy/{id}', [App\Http\Controllers\SupplierController::class, 'brand_destroy'])->name('supplier.brand_destroy');
});


// Purchasers Route
Route::group(['prefix' => 'purchaser', 'middleware' => ['auth']], function () {
    Route::get('list', [PurchaserController::class, 'index'])->name('purchaser.list');
    Route::get('create', [PurchaserController::class, 'create'])->name('purchaser.create');
    Route::post('store', [PurchaserController::class, 'store'])->name('purchaser.store');
    Route::post('purchaser/assign-brand', [PurchaserController::class, 'assignBrand'])->name('purchaser.assign.brand');
    Route::get('edit/{id}', [PurchaserController::class, 'edit'])->name('purchaser.edit');
    Route::post('update/{id}', [PurchaserController::class, 'update'])->name('purchaser.update');
    Route::post('destroy/{id}', [PurchaserController::class, 'destroy'])->name('purchaser.destroy');
    Route::get('purchaser-view/{id}', [PurchaserController::class, 'view'])->name('purchaser.view');
    Route::get('print/{id}', [PurchaserController::class, 'print'])->name('svoucher.print');




    // brand for supplier
    Route::get('brand/{id}', [App\Http\Controllers\SupplierController::class, 'brand'])->name('supplier.brand');
    Route::get('brand_create/{id}', [App\Http\Controllers\SupplierController::class, 'brand_create'])->name('supplier.brand_create');
    Route::post('brand_store', [App\Http\Controllers\SupplierController::class, 'brand_store'])->name('supplier.brand_store');
    Route::post('brand_destroy/{id}', [App\Http\Controllers\SupplierController::class, 'brand_destroy'])->name('supplier.brand_destroy');
});

Route::get('get-supplier-details/{id}', [AjaxController::class, 'getSupplierdetails'])->name('supplier.getDetails');
Route::get('get-purchaser-details/{id}', [AjaxController::class, 'getPurchaserdetails'])->name('purchaser.getDetails');
// General Ledger Route
Route::group(['prefix' => 'accounts', 'middleware' => ['auth']], function () {
    Route::get('ledger-list', [App\Http\Controllers\GeneralLedgerController::class, 'index'])->name('ledger.list');
    Route::get('ledger-create', [App\Http\Controllers\GeneralLedgerController::class, 'create'])->name('ledger.create');
    Route::post('ledger-store', [App\Http\Controllers\GeneralLedgerController::class, 'store'])->name('ledger.store');
    Route::get('ledger-edit/{id}', [App\Http\Controllers\GeneralLedgerController::class, 'edit'])->name('ledger.edit');
    Route::post('ledger-update/{id}', [App\Http\Controllers\GeneralLedgerController::class, 'update'])->name('ledger.update');
    Route::post('ledger-destroy/{id}', [App\Http\Controllers\GeneralLedgerController::class, 'destroy'])->name('ledger.destroy');
    Route::post('ledger-search', [App\Http\Controllers\GeneralLedgerController::class, 'searchLedgers'])->name('search.ledgers');
});

// Route::group(['prefix' => 'main_account', 'middleware' => ['auth']], function () {
//     Route::get('list', [App\Http\Controllers\Chart_of_accountController::class, 'index'])->name('main_account.list');
//     Route::get('create', [App\Http\Controllers\Chart_of_accountController::class, 'create'])->name('supplier.create');
//     Route::post('store', [App\Http\Controllers\Chart_of_accountController::class, 'store'])->name('supplier.store');
//     Route::get('edit/{id}', [App\Http\Controllers\Chart_of_accountController::class, 'edit'])->name('supplier.edit');
//     Route::post('update/{id}', [App\Http\Controllers\Chart_of_accountController::class, 'update'])->name('supplier.update');
//     Route::get('destroy/{id}', [App\Http\Controllers\Chart_of_accountController::class, 'destroy'])->name('supplier.destroy');
// });
Route::get('/main_account', [ChartOfAccountController::class, 'main_account']);
Route::post('/main_account/store', [ChartOfAccountController::class, 'main_account_store']);
Route::get('control_account/{id}', [ChartOfAccountController::class, 'control_account']);
Route::post('control_account/store', [ChartOfAccountController::class, 'control_account_store']);
Route::post('control_account/update/{id}', [ChartOfAccountController::class, 'control_account_update']);
Route::get('sub_control_account/{c_id}/{id}', [ChartOfAccountController::class, 'sub_control_account']);
Route::post('sub_control_account/store', [ChartOfAccountController::class, 'sub_control_account_store']);
Route::post('sub_control_account/update/{id}', [ChartOfAccountController::class, 'sub_control_account_update']);
Route::post('sub_control_account/delete/{id}', [ChartOfAccountController::class, 'destroy_sub_control_account']);
Route::get('transaction_account/{c_id}/{sc_id}/{id}', [ChartOfAccountController::class, 'transaction_account']);
Route::post('transaction_account/delete/{id}', [ChartOfAccountController::class, 'destroy_transaction_account']);
Route::post('transaction_account/store', [ChartOfAccountController::class, 'transaction_account_store']);
Route::post('transaction_account/update/{id}', [ChartOfAccountController::class, 'transaction_account_update']);


// // general ledger
// Route::get('general_ledger', [ChartOfAccountController::class, 'transaction_account']);
// Route::get('/general_ledger', [ChartOfAccountController::class, 'generalLedger'])->name('general_ledger');
// Route::any('/general_ledger_report/{bp_id?}/{ac_id?}/{type_id?}', [ChartOfAccountController::class, 'viewGeneralLedgerReport'])->name('general_ledger_report');


// profit & loss
Route::get('/profit_loss', [ChartOfAccountController::class, 'profit_loss'])->name('profit_loss');
Route::post('/profit_loss_report', [ChartOfAccountController::class, 'profitLossReport'])->name('profit_loss_report');




Route::group(['prefix' => 'service_purchase', 'middleware' => ['auth']], function () {
    Route::get('list', [App\Http\Controllers\ServicePurchaseController::class, 'index'])->name('service_purchase.list');
    Route::get('create', [App\Http\Controllers\ServicePurchaseController::class, 'create'])->name('service_purchase.create');
    Route::post('store', [App\Http\Controllers\ServicePurchaseController::class, 'store'])->name('service_purchase.store');
    Route::get('edit/{id}', [App\Http\Controllers\ServicePurchaseController::class, 'edit'])->name('service_purchase.edit');
    Route::put('/service_purchase/{id}', [App\Http\Controllers\ServicePurchaseController::class, 'update'])->name('service_purchase.update');
    Route::get('destroy/{id}', [App\Http\Controllers\ServicePurchaseController::class, 'destroy'])->name('service_purchase.destroy');
});

// For Goods Receipts
Route::group(['prefix' => 'good_receipts', 'middleware' => ['auth']], function () {
    Route::get('list', [App\Http\Controllers\GoodReceiptsController::class, 'index'])->name('good_receipts.list');
    Route::get('create', [App\Http\Controllers\GoodReceiptsController::class, 'create'])->name('good_receipts.create');
    Route::post('store', [App\Http\Controllers\GoodReceiptsController::class, 'store'])->name('good_receipts.store');
    Route::get('edit/{id}', [App\Http\Controllers\GoodReceiptsController::class, 'edit'])->name('good_receipts.edit');
    Route::put('update/{id}', [App\Http\Controllers\GoodReceiptsController::class, 'update'])->name('good_receipts.update');
    Route::get('destroy/{id}', [App\Http\Controllers\GoodReceiptsController::class, 'destroy'])->name('good_receipts.destroy');
    Route::get('check-cate-parent', [App\Http\Controllers\GoodReceiptsController::class, 'checkCateParent'])->name('check-cate-parent');
    Route::get('check-cate-child', [App\Http\Controllers\GoodReceiptsController::class, 'checkCateChild'])->name('check-cate-child');
});

// For Sales
Route::group(['prefix' => 'sales', 'middleware' => ['auth']], function () {
    Route::get('list', [App\Http\Controllers\SalesController::class, 'index'])->name('sales.list');
    Route::get('create', [App\Http\Controllers\SalesController::class, 'create'])->name('sales.create');
    Route::post('store', [App\Http\Controllers\SalesController::class, 'store'])->name('sales.store');
    Route::get('edit/{id}', [App\Http\Controllers\SalesController::class, 'edit'])->name('sales.edit');
    Route::put('update/{id}', [App\Http\Controllers\SalesController::class, 'update'])->name('sales.update');
    Route::get('destroy/{id}', [App\Http\Controllers\SalesController::class, 'destroy'])->name('sales.destroy');
    Route::get('get-truck-items/{truckId}', [App\Http\Controllers\SalesController::class, 'getItemsByTruck'])->name('get.truck.items');
    Route::get('get-items-by-marka/{truckId}/{marka}', [App\Http\Controllers\SalesController::class, 'getItemsByMarka'])->name('get.items.by.marka');
    Route::get('/get-item-details', [App\Http\Controllers\SalesController::class, 'getItemDetails'])->name('getItemDetails');
});

// For Sales Rate Application
Route::group(['prefix' => 'sale_rate', 'middleware' => ['auth']], function () {
    Route::get('list', [App\Http\Controllers\SalesRateApplicationController::class, 'index'])->name('sale_rate.list');
    Route::get('create', [App\Http\Controllers\SalesRateApplicationController::class, 'create'])->name('sale_rate.create');
    Route::post('apply', [App\Http\Controllers\SalesRateApplicationController::class, 'salesRateApply'])->name('sale_rate.apply');
});

Route::group(['prefix' => 'purchase_order', 'middleware' => ['auth']], function () {
    Route::get('list', [App\Http\Controllers\PurchaseorderController::class, 'index'])->name('po.list');
    Route::get('create', [App\Http\Controllers\PurchaseorderController::class, 'create'])->name('po.create');
    Route::post('store', [App\Http\Controllers\PurchaseorderController::class, 'store'])->name('po.store');
    Route::get('edit/{id}', [App\Http\Controllers\PurchaseorderController::class, 'edit'])->name('po.edit');
    Route::put('update/{id}', [App\Http\Controllers\PurchaseorderController::class, 'update'])->name('po.update');
    Route::get('destroy/{id}', [App\Http\Controllers\PurchaseorderController::class, 'destroy'])->name('po.destroy');
    Route::get('patient_list/{query?}', [AjaxController::class, 'patient_search']);
    Route::get('get_supplier_details', [AjaxController::class, 'get_supplier_details']);
    Route::get('get_supplier_brands', [AjaxController::class, 'get_supplier_brands']);
    Route::get('get_supplier_brands_products', [AjaxController::class, 'get_supplier_brands_products']);
});

// Journal Voucher //
Route::group(['prefix' => 'voucher', 'middleware' => ['auth']], function () {
    Route::get('list', [App\Http\Controllers\VoucherController::class, 'index'])->name('voucher.list');
    Route::get('voucherlisting', [App\Http\Controllers\VoucherController::class, 'voucher_listing'])->name('voucherlisting');
    Route::get('create', [App\Http\Controllers\VoucherController::class, 'create'])->name('voucher.create');
    Route::post('store', [App\Http\Controllers\VoucherController::class, 'store'])->name('voucher.store');
    Route::get('/voucher/print/{id}', [VoucherController::class, 'print'])->name('voucher.print');
    Route::get('edit/{id}', [App\Http\Controllers\VoucherController::class, 'edit'])->name('voucher.edit');
    Route::get('view/{id}', [App\Http\Controllers\VoucherController::class, 'view'])->name('voucher.view');
    Route::post('update/{id}', [App\Http\Controllers\VoucherController::class, 'update'])->name('voucher.update');
    Route::post('destroy/{id}', [App\Http\Controllers\VoucherController::class, 'destroy'])->name('voucher.destroy');
    // Route::get('print/{id}', [App\Http\Controllers\VoucherController::class, 'print'])->name('voucher.print');
    Route::get('/get-partner-data', [App\Http\Controllers\VoucherController::class, 'getPartnerData'])->name('get-partner-data');
    // Route::post('/save-vendor', [App\Http\Controllers\VoucherController::class, 'saveVendor'])->name('save-vendor');
    Route::post('/save-vendor', [VoucherController::class, 'saveVendor'])->name('save-vendor');
    Route::get('/get-transaction-accounts', [VoucherController::class, 'getTransactionAccounts'])->name('get-transaction-accounts');
});

// Paymet Voucher //
Route::group(['prefix' => 'payment', 'middleware' => ['auth']], function () {
    Route::get('list', [App\Http\Controllers\PaymentVoucherController::class, 'index'])->name('payment.list');
    Route::get('paymentvoucherlisting', [App\Http\Controllers\PaymentVoucherController::class, 'voucher_listing'])->name('paymentvoucherlisting');
    Route::get('create', [App\Http\Controllers\PaymentVoucherController::class, 'create'])->name('payment_voucher.create');
    Route::post('store', [App\Http\Controllers\PaymentVoucherController::class, 'store'])->name('payment_voucher.store');
    Route::get('edit/{id}', [App\Http\Controllers\PaymentVoucherController::class, 'edit'])->name('payment_voucher.edit');
    Route::post('update/{id}', [App\Http\Controllers\PaymentVoucherController::class, 'update'])->name('payment_voucher.update');
    Route::get('view/{id}', [App\Http\Controllers\PaymentVoucherController::class, 'view'])->name('voucher.p_view');
    Route::put('update/{id}', [App\Http\Controllers\PaymentVoucherController::class, 'update'])->name('payment_voucher.update');
    Route::get('destroy/{id}', [App\Http\Controllers\PaymentVoucherController::class, 'destroy'])->name('payment_voucher.destroy');
});

// Receipts Voucher //
Route::group(['prefix' => 'receipt_voucher', 'middleware' => ['auth']], function () {
    Route::get('list', [App\Http\Controllers\ReceiptVoucherController::class, 'index'])->name('receipt_voucher.list');
    Route::get('receiptvoucherlisting', [App\Http\Controllers\ReceiptVoucherController::class, 'voucher_listing'])->name('receiptvoucherlisting');
    Route::get('create', [App\Http\Controllers\ReceiptVoucherController::class, 'create'])->name('receipt_voucher.create');
    Route::post('store', [App\Http\Controllers\ReceiptVoucherController::class, 'store'])->name('receipt_voucher.store');
    Route::get('edit/{id}', [App\Http\Controllers\ReceiptVoucherController::class, 'edit'])->name('receipt_voucher.edit');
    Route::get('view/{id}', [App\Http\Controllers\ReceiptVoucherController::class, 'view'])->name('voucher.r_view');
    Route::put('update/{id}', [App\Http\Controllers\ReceiptVoucherController::class, 'update'])->name('receipt_voucher.update');
    Route::delete('receipt_voucher/destroy/{id}', [App\Http\Controllers\ReceiptVoucherController::class, 'destroy'])->name('receipt_voucher.destroy');
});

// Service purchase Voucher //
// Route::group(['prefix' => 'service_voucher', 'middleware' => ['auth']], function () {
//     Route::get('list', [App\Http\Controllers\ServicePurchaseVoucherController::class, 'index'])->name('service_voucher.list');
//     Route::get('servicevoucherlisting', [App\Http\Controllers\ServicePurchaseVoucherController::class, 'voucher_listing'])->name('servicevoucherlisting');
//     Route::get('create', [App\Http\Controllers\ServicePurchaseVoucherController::class, 'create'])->name('service_voucher.create');
//     Route::post('store', [App\Http\Controllers\ServicePurchaseVoucherController::class, 'store'])->name('service_voucher.store');
//     Route::get('edit/{id}', [App\Http\Controllers\ServicePurchaseVoucherController::class, 'edit'])->name('service_voucher.edit');
//     Route::get('view/{id}', [App\Http\Controllers\ServicePurchaseVoucherController::class, 'view'])->name('voucher.s_view');
//     Route::put('update/{id}', [App\Http\Controllers\ServicePurchaseVoucherController::class, 'update'])->name('service_voucher.update');
//     Route::get('destroy/{id}', [App\Http\Controllers\ServicePurchaseVoucherController::class, 'destroy'])->name('service_voucher.destroy');
// });

Route::group(['prefix' => 'b_cheque', 'middleware' => ['auth']], function () {
    Route::get('list', [App\Http\Controllers\BchequeController::class, 'index'])->name('b_cheque.list');
    Route::get('create', [App\Http\Controllers\BchequeController::class, 'create'])->name('b_cheque.create');
    Route::post('store', [App\Http\Controllers\BchequeController::class, 'store'])->name('b_cheque.store');
    Route::get('edit/{id}', [App\Http\Controllers\BchequeController::class, 'edit'])->name('b_cheque.edit');
    Route::put('update/{id}', [App\Http\Controllers\BchequeController::class, 'update'])->name('b_cheque.update');
    Route::delete('destroy/{id}', [App\Http\Controllers\BchequeController::class, 'destroy'])->name('b_cheque.destroy');
    Route::get('get-truck-items/{truckId}', [App\Http\Controllers\BchequeController::class, 'getItemsByTruck'])->name('get.truck.items');
    Route::get('get-items-by-marka/{truckId}/{marka}', [App\Http\Controllers\BchequeController::class, 'getItemsByMarka'])->name('get.items.by.marka');


    Route::get('invoice/printview/{id}', [App\Http\Controllers\BchequeController::class, 'bChequeInvoicePrintView'])->name('b_cheque.invoice.printview');
});
Route::group(['prefix' => 'printView', 'middleware' => ['auth']], function () {
    Route::get('receipt_vouchers', [App\Http\Controllers\PrintviewsController::class, 'receipt'])->name('print.receipt_voucher');
    Route::get('payment_voucher', [App\Http\Controllers\PrintviewsController::class, 'payment'])->name('print.payment_voucher');
    Route::get('cash_voucher', [App\Http\Controllers\PrintviewsController::class, 'cash'])->name('print.cash_voucher');
    Route::get('supplier_voucher', [App\Http\Controllers\PrintviewsController::class, 'supplier'])->name('print.supplier_voucher');
});


// Stock Report
Route::get('/stock_report', [ReportController::class, 'showStockReportForm'])->name('stock_report.form');
// Route::post('/stock_report', [App\Http\Controllers\ReportController::class, 'generateStockReport'])->name('stock_report.generate');
// Fetching Products & trucks with there Categories For Reports
Route::post('/get-trucks', [ReportController::class, 'getTrucks'])->name('get.trucks');
Route::post('/get-main-categories', [ReportController::class, 'getMainCategories'])->name('get.main.categories');
Route::post('/get-parent-categories', [ReportController::class, 'getParentCategories'])->name('get.parent.categories');
Route::post('/get-child-categories', [ReportController::class, 'getChildCategories'])->name('get.child.categories');


// New Routes
Route::get('/get-suppliers/{truck}', [ReportController::class, 'getSuppliersByTruck'])->name('get-suppliers');
Route::get('/truck-details/{truck}', [ReportController::class, 'getDetailsByTruck'])->name('get-truck-details');
Route::post('/stock-report/generate', [ReportController::class, 'generateStockReport'])->name('stock_report.generate');


// Route::get('/fetch-main-categories', [ReportController::class, 'fetchMainCategories']);
// Route::get('/fetch-parent-categories', [CategoryController::class, 'fetchParentCategories'])->name('fetchParentCategories');
// Route::get('/fetch-child-categories', [CategoryController::class, 'fetchChildCategories'])->name('fetchChildCategories');

// Sale Report
Route::get('/saleReportDetail', [App\Http\Controllers\ReportController::class, 'saleReportDetail'])->name('saleReportDetail');

// Ageing Report
Route::get('/ageing', [App\Http\Controllers\ReportController::class, 'ageingSummary'])->name('ageingSummary');
Route::post('/ageing', [App\Http\Controllers\ReportController::class, 'ageingSummaryData'])->name('ageingSummaryData');

// CustomerWise Report
Route::get('/customerWise', [App\Http\Controllers\ReportController::class, 'customerWiseReport'])->name('customerWiseReport');
Route::post('/customerWise', [App\Http\Controllers\ReportController::class, 'customerWiseReport'])->name('customerWiseReport');

// Sale Bill Report
Route::get('/sale-bill/report', [ReportController::class, 'salebill'])->name('sale-bill.report');
// Route::post('/sale-bill', [App\Http\Controllers\ReportController::class, 'salebill'])->name('sale-bill');
Route::get('/fetchCustomerData', [ReportController::class, 'fetchCustomerData'])->name('fetchCustomerData');
Route::get('/fetch-report-data', [ReportController::class, 'fetchReportData'])->name('fetchReportData');
Route::get('sale-bill/print', [ReportController::class, 'saleBillPrintView'])->name('sale-bill.print');


// Route::get('/customer-details/{customer}', [ReportController::class, 'getDetailsByCustomer'])->name('get-customer-details');
// Route::post('/saleBill/report', [ReportController::class, 'saleBillreport'])->name('saleBill.generate');

// Receivables Report

Route::get('receivables/report', [App\Http\Controllers\ReportController::class, 'receivables'])->name('receivables.report');
Route::get('receivables/print', [ReportController::class, 'receivablesPrintView'])->name('receivables.print');


// Sale Register Report

Route::get('sale-register/report', [ReportController::class, 'saleRegister'])->name('sale-register.report');
Route::get('sale-register/print', [ReportController::class, 'saleRegisterPrintView'])->name('sale-register.report.print');


// Truck Sale Register Report

Route::get('truck-sale-register/report', [ReportController::class, 'TruckSaleRegister'])->name('truck-sale-register.report');
Route::get('truck-sale-register/print', [ReportController::class, 'truckSaleRegisterPrintView'])->name('truck-sale-register.report.print');


// Daily Sale Report
Route::get('/dailySale', [App\Http\Controllers\ReportController::class, 'dailysales'])->name('dailySale');
Route::post('/dailySale', [App\Http\Controllers\ReportController::class, 'dailysales'])->name('dailySale');


// sale Register Report


// Purchase Report
// Route::get('/purchaseReport', [App\Http\Controllers\ReportController::class, 'purchaseReport'])->name('purchaseReport.form');
// Route::post('/purchaseReport', [App\Http\Controllers\ReportController::class, 'generatepurchaseReport'])->name('purchaseReport.generate');
// Route::get('/fetch-main-categories', [CategoryController::class, 'fetchMainCategories'])->name('fetchMainCategories');

Route::get('/purchaseReport', [App\Http\Controllers\ReportController::class, 'purchaseReportShow'])->name('purchaseReport.form');
Route::post('/purchase-report/generate', [ReportController::class, 'generatePurchaseReport'])->name('purchase_report.generate');



Route::get('/general-ledger/report', [App\Http\Controllers\ReportController::class, 'generalLedger'])->name('generalLedger.register');
Route::get('/general-ledger/print', [ReportController::class, 'generalLedgerPrintView'])->name('generalLedger.report.print');


// Stock In Hand Register
Route::get('/stock-in-hand-register/report', [ReportController::class, 'stockInHandRegister'])->name('stockInHandRegister.report');
Route::get('/stock-in-hand-register/print', [ReportController::class, 'stockInHandRegisterPrintView'])->name('stockInHandRegister.report.print');


// Route::group(['prefix' => 'printPreference', 'middleware' => ['auth']], function () {
//     Route::get('/list', [App\Http\Controllers\PrintPreferenceController::class, 'index'])->name('printPreference.index');
//     Route::get('/create', [App\Http\Controllers\PrintPreferenceController::class, 'create'])->name('printPreference.create');
//     Route::post('/store', [App\Http\Controllers\PrintPreferenceController::class, 'store'])->name('printPreference.store');
//     Route::post('/update-permission/{id}', [App\Http\Controllers\PrintPreferenceController::class, 'printPreference.updatePermission']);
// });



Route::group(['prefix' => 'shortkut', 'middleware' => ['auth']], function () {
    Route::get('/list', [App\Http\Controllers\ShortkutController::class, 'index'])->name('shortkut.index');
    Route::get('/create', [App\Http\Controllers\ShortkutController::class, 'create'])->name('shortkut.create');
    Route::post('/store', [App\Http\Controllers\ShortkutController::class, 'store'])->name('shortkut.store');
    Route::get('/shortkut/{id}/edit', [App\Http\Controllers\ShortkutController::class, 'edit'])->name('shortkut.edit');
    Route::put('/shortkut/{id}', [App\Http\Controllers\ShortkutController::class, 'update'])->name('shortkut.update');
    Route::delete('/destroy/{id}', [App\Http\Controllers\ShortkutController::class, 'destroy'])->name('shortkut.destroy');
    Route::get('/fetch-shortcuts', [App\Http\Controllers\ShortcutController::class, 'fetchShortcuts']);
});

// Designation Route
Route::prefix('designations')->middleware(['auth'])->group(function () {
    Route::get('/', [DesignationController::class, 'index'])->name('designations.index');
    Route::get('/create', [DesignationController::class, 'create'])->name('designations.create');
    Route::post('/store', [DesignationController::class, 'store'])->name('designations.store');
    Route::get('/edit/{id}', [DesignationController::class, 'edit'])->name('designations.edit');
    Route::post('/update/{id}', [DesignationController::class, 'update'])->name('designations.update');
    Route::get('/delete/{id}', [DesignationController::class, 'destroy'])->name('designations.destroy');
});

// Attendene Routes
Route::get('/attendance', [EmployeeAttendanceController::class, 'index'])->name('attendance');
Route::post('/attendance/check-in', [EmployeeAttendanceController::class, 'checkIn'])->name('attendance.checkin');
Route::post('/attendance/check-out', [EmployeeAttendanceController::class, 'checkOut'])->name('attendance.checkout');
Route::get('/attendance/details/{employee}', [EmployeeAttendanceController::class, 'attendanceDetails']);



Route::get('/payrolls', [PayrollController::class, 'index'])->name('payroll.index');
Route::post('/payrolls/generate', [PayrollController::class, 'generate'])->name('payroll.generate');
Route::post('/payroll/{id}/pay', [PayrollController::class, 'pay'])->name('payroll.pay');
Route::post('/payroll/pay-all', [PayrollController::class, 'payAll'])->name('payroll.payall');

// AjaxController

Route::get('truck/get-goods-receipt/{id}', [AjaxController::class, 'getGoodReceiptTruck'])->name('get.goods-receipt.truck');

// Service Voucher

Route::group(['prefix' => 'service_voucher', 'middleware' => ['auth']], function () {
    Route::get('index', [ServiceVoucherController::class, 'index'])->name('service_vouchers.index');
    Route::get('create', [ServiceVoucherController::class, 'create'])->name('service_vouchers.create');
    Route::post('store', [ServiceVoucherController::class, 'store'])->name('service_vouchers.store');
    Route::get('edit/{id}', [ServiceVoucherController::class, 'edit'])->name('service_vouchers.edit');
    Route::get('view/{id}', [ServiceVoucherController::class, 'view'])->name('vouchers_view');
    Route::put('update/{id}', [ServiceVoucherController::class, 'update'])->name('service_vouchers.update');
    Route::delete('destroy/{id}', [ServiceVoucherController::class, 'destroy'])->name('service_vouchers.destroy');
});





// Route::get('/create-table', [App\Http\Controllers\Admin\AdminController::class, 'createtable']);
// Route::get('/assignrole', [App\Http\Controllers\Admin\AdminController::class, 'assignSuperAdminRole']);
// });
