@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Journal Voucher</span>
    </div>
    <h2 class="az-content-title" style="display: inline">Journal Voucher
        <span>
            <a href="{{ route('voucher.create') }}" class="btn btn-az-primary" id="addbtn" style="float: right">
                <i class="fa-solid fa-plus"></i> Add Journal Voucher
            </a>
        </span>
    </h2>

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-20">
                <div>
                    {{-- <table id="example2" class="table table-striped">
                        <thead>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-10p">Created Date</th>
                                <th class="wd-10p">Debit</th>
                                <th class="wd-10p">Credit</th>
                                <th class="wd-10p">Business Partner</th>
                                <th class="wd-10p">Payment Mode</th>
                                <th class="wd-10p">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($vouchersNumber as $vouchersUnique)
                                <tr class="group group-start">
                                    <td colspan="7">
                                        {{ $vouchersUnique->voucher_number }}
                                    </td>
                                </tr>
                                @foreach ($vouchersUnique->vouchers as $key => $voucher)
                                    <tr role="row">
                                        <td>{{ $key + 1 }}</td>
                                        <td>{{ date('d-m-Y', strtotime($voucher->date)) }}</td>
                                        <td>{{ $voucher->debit }}</td>
                                        <td>{{ $voucher->credit }}</td>
                                        <td>{{ $voucher->partner_name }}</td>
                                        <td>{{ $voucher->payment_mode }}</td>
                                        <td>
                                            @can('Journal Journal Vouchers edit')
                                                <a class="btn btn-primary"
                                                    href="{{ route('voucher.edit', \Crypt::encrypt($voucher->id_vouchers)) }}">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                            @endcan
                                            @can('Journal Journal Vouchers delete')
                                                <a href="#" class="btn btn-danger" data-toggle="modal"
                                                    data-target="#deleteModal" data-id="{{ $voucher->id_vouchers }}">
                                                    <i class="fas fa-trash"></i>
                                                </a>
                                            @endcan
                                        </td>
                                    </tr>
                                @endforeach
                            @endforeach
                        </tbody>
                    </table> --}}

                    {{-- <table id="example2" class="table table-striped table-hover table-bordered align-middle">
                        <thead class="table-dark">
                            <tr>
                                <th scope="col">S.No</th>
                                <th scope="col">Voucher Number</th>
                                <th scope="col" class="text-center">Expand Vouchers</th>
                                <th scope="col" class="text-center">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($vouchersNumber as $vouchersUnique)
                                <tr>
                                    <td class="align-middle">{{ $loop->iteration }}</td>
                                    <td class="align-middle">{{ $vouchersUnique->voucher_number }}</td>
                                    <td class="align-middle">
                                        <table class="table table-bordered table-sm mb-0">
                                            <thead class="table-light">
                                                <tr>
                                                    <th>#</th>
                                                    <th>Created Date</th>
                                                    <th>Debit</th>
                                                    <th>Credit</th>
                                                    <th>Business Partner</th>
                                                    <th>Payment Mode</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($vouchersUnique->vouchers as $key => $voucher)
                                                    <tr>
                                                        <td>{{ $key + 1 }}</td>
                                                        <td>{{ date('d-m-Y', strtotime($voucher->date)) }}</td>
                                                        <td>{{ $voucher->debit }}</td>
                                                        <td>{{ $voucher->credit }}</td>
                                                        <td>{{ $voucher->partner_name }}</td>
                                                        <td>{{ $voucher->payment_mode }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </td>
                                    <td class="align-middle text-center">
                                        <a class="btn btn-outline-success btn-sm rounded-pill shadow-sm"
                                            title="View Journal Voucher"
                                            href="{{ route('voucher.view', \Crypt::encrypt($vouchersUnique->id_vouchers_unique_number)) }}">
                                            <i class="fa-solid fa-eye"></i> View
                                        </a>
                                        <a class="btn btn-outline-danger btn-sm rounded-pill shadow-sm"
                                            title="Delete Journal Voucher" data-toggle="modal" data-target="#deleteModal"
                                            data-id="{{ Crypt::encrypt($vouchersUnique->id_vouchers_unique_number) }}">
                                            <i class="fa-solid fa-trash-can"></i> Remove
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot class="">
                            <tr>
                                <th>S.No</th>
                                <th>Voucher Number</th>
                                <th class="text-center">Expand Vouchers</th>
                                <th class="text-center">Action</th>
                            </tr>
                        </tfoot>
                    </table> --}}

                    <table id="example23" class="display nowrap" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>created date</th>
                                <!-- th>Description</th> -->
                                <th>Debit</th>
                                <th>Credit</th>
                                <th>Account Name</th>
                                <th>Business Partner Type</th>
                                <th>Business Partner</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tfoot>
                            <tr>
                                <th>created date</th>
                                <!-- <th>Description</th> -->
                                <th>Debit</th>
                                <th>Credit</th>
                                <th>Account Name</th>
                                <th>Business Partner Type</th>
                                <th>Business Partner</th>
                                <th>Action</th>
                            </tr>
                        </tfoot>

                        <tbody>

                        </tbody>
                    </table>

                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this voucher?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" action="" method="POST">
                        @csrf
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        document.addEventListener('keydown', function(event) {
            // Check if CTRL + A (or CMD + A) is pressed
            if ((event.ctrlKey || event.metaKey) && event.key.toLowerCase() === 'a') {
                event.preventDefault(); // Prevent default "Select All" behavior

                // Trigger the click event on the "Add Goods Receipts" button
                document.getElementById('addbtn').click();
            }
        });
        // $(document).ready(function() {
        //     $('#example2').DataTable({
        //         dom: 'Bfrtip',
        //         buttons: [{
        //                 extend: 'csv',
        //                 text: 'CSV',
        //                 title: 'Journal Voucher List',
        //                 className: 'btn btn-default',
        //                 exportOptions: {
        //                     columns: 'th:not(:last-child)'
        //                 }
        //             },
        //             {
        //                 extend: 'excel',
        //                 text: 'Excel',
        //                 title: 'Journal Voucher List',
        //                 className: 'btn btn-default',
        //                 exportOptions: {
        //                     columns: 'th:not(:last-child)'
        //                 }
        //             },
        //             {
        //                 extend: 'pdf',
        //                 text: 'PDF',
        //                 title: 'Journal Voucher List',
        //                 className: 'btn btn-default',
        //                 exportOptions: {
        //                     columns: 'th:not(:last-child)'
        //                 }
        //             },
        //             {
        //                 extend: 'print',
        //                 text: 'Print',
        //                 title: 'Journal Voucher List',
        //                 className: 'btn btn-default',
        //                 exportOptions: {
        //                     columns: 'th:not(:last-child)'
        //                 }
        //             }
        //         ],
        //         responsive: true
        //     });

        //     $('#deleteModal').on('show.bs.modal', function(event) {
        //         var button = $(event.relatedTarget);
        //         var id = button.data('id');
        //         var actionUrl = '{{ url('voucher/destroy') }}/' + id;
        //         var modal = $(this);
        //         modal.find('#deleteForm').attr('action', actionUrl);
        //     });
        // });

        $(document).ready(function() {
            var id = 0;
            oTable = $('#example23').DataTable({
                "stateSave": true,
                "processing": true,
                "serverSide": true,
                ajax: {
                    url: "{{ route('voucherlisting') }}",
                    data: function(d) {
                        d._token = '{{ csrf_token() }}';
                        d.id = id;
                    }
                },
                "columns": [{
                        data: 'voucher_date',
                        name: 'created_at'
                    },
                    {
                        data: 'debit',
                        name: 'debit'
                    },
                    {
                        data: 'credit',
                        name: 'credit'
                    },
                    {
                        data: 'account_title',
                        name: 'account_title' // Ensure this matches your returned data
                    },
                    {
                        data: 'bp_type',
                        name: 'business_partner_type'
                    },
                    {
                        data: 'bp_name',
                        name: 'partner_name'
                    },
                    {
                        data: 'action',
                        name: 'action'
                    }
                ],
                columnDefs: [{
                    targets: 0,
                    render: function(data) {
                        return moment(data).format('D MMMM YYYY');
                    }
                }],
                rowGroup: {
                    dataSrc: 'voucher_number'
                },
                dom: 'Bfrtip',
                buttons: [
                    'copy', 'csv', 'excel', 'pdf', 'print'
                ],
                initComplete: function() {
                    this.api().columns([0, 3, 4, 5]).every(function() {
                        var column = this;
                        var input = document.createElement("input");
                        $(input).addClass('form-control input-sm');
                        $(input).appendTo($(column.footer()).empty())
                            .on('keyup', function() {
                                column.search($(this).val(), false, false, true).draw();
                            });
                    });
                },
            });
        });
    </script>
@endpush
