<?php

namespace App;

//use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BCheque extends Model
{
//    use HasFactory;

    protected $table = 'b_cheque';
    protected $primaryKey = 'id_b_cheque';

    protected $fillable = [
        'business_id',
        'good_receipts_truck_id',
        'customer_id',
        'supplier_id',
        'detail',
        'date',
        'pb_no',
        'bilty_no',
        'detail',
        'status',
        'created_by'
    ];

    protected $casts = [
        'date'=>'datetime'
    ];
    public function goodReceiptTruck()
    {
        return $this->belongsTo(GoodReceiptTruck::class, 'good_receipts_truck_id', 'id_truck');
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customer_id', 'id_customers');
    }

    public function supplier()
    {
        return $this->belongsTo(Suppliers::class, 'supplier_id', 'id_supplier');
    }

    public function items()
    {
        return $this->hasMany(BChequeItem::class, 'b_cheque_id', 'id_b_cheque');
    }

    public function details()
    {
        return $this->hasOne(BChequeDetail::class, 'b_cheque_id', 'id_b_cheque');
    }

}
