<?php

namespace App\Http\Controllers;

use App\Sale;
use App\SalesItemDetail;
use App\SalesPerBoriWeight;
use App\Customer;
use App\Suppliers;
use App\GoodReceipts;
use App\GoodReceiptTruck;
use App\GoodReceiptDetail;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\DB;

class SalesController extends Controller
{

    protected string $module = 'Sales';

    public function __construct()
    {
        $module = $this->module;

        $this->middleware("permission:$module list")->only(['index']);
        $this->middleware("permission:$module view")->only(['show']);
        $this->middleware("permission:$module add")->only(['create', 'store']);
        $this->middleware("permission:$module edit")->only(['edit', 'update']);
        $this->middleware("permission:$module delete")->only(['destroy']);
    }

    // protected $role_id;
    // public function __construct()
    // {
    //     $this->middleware('auth');
    //     $this->middleware(function ($request, $next) {
    //         $this->role_id = Auth::user()->role_id;
    //     //    $slug_filter = preg_replace('/[0-9]+/', '', $request->path());
    //     //    $slug_filter = preg_replace('/[0-9]+/', '', $request->path());
    //     $ex = explode('/',$request->path());
    //     if(count($ex)>=3){
    //         $sliced = array_slice($ex, 0, -1);

    //     }else{
    //         $sliced = $ex;
    //     }

    //     $string = implode("/", $sliced);
    //         if (checkConstructor($this->role_id, count($ex)>=3 ? $string.'/': $string) == 1) {
    //             return $next($request);
    //         }else if(strpos($request->path(), 'store') !== false){
    //             return $next($request);
    //         }else if(strpos($request->path(), 'update') !== false){
    //             return $next($request);
    //         } else {
    //             abort(404);
    //         }
    //     });
    // }

    public function index()
    {
        $sales = Sale::with(['salesItemsDetails', 'salesPerBoriWeight', 'customer', 'goodReceiptTruck', 'goodReceiptTruck.goodReceiptDetails'])->OrderBy('id_sales', 'DESC')->get();
        //        dd($sales);
        return view('sales.index', compact('sales'));
    }

    // public function create()
    // {
    //     // $trucks = GoodReceiptTruck::with('goodReceipts.goodReceiptDetails')->get();
    //     $trucks = GoodReceiptTruck::with([
    //         'goodReceipts' => function ($query) {
    //             $query->with(['goodReceiptDetails.productMainCate', 'goodReceiptDetails.productParentCate', 'goodReceiptDetails.productChildCate', 'supplier']);
    //         }
    //     ])->get();
    //     $customers = Customer::all();
    //     return view('sales.create', compact('trucks', 'customers'));
    // }

    public function create()
    {
        $trucks = GoodReceiptTruck::with([
            'goodReceipts' => function ($query) {
                $query->with([
                    'goodReceiptDetails' => function ($query) {
                        // Only get good receipt details where bori is greater than 0
                        $query->where('bori', '>', 0)
                            ->with(['productMainCate', 'productParentCate', 'productChildCate']);
                    },
                    'supplier'
                ]);
            }
        ])->get();
        $customers = Customer::all();
        return view('sales.create', compact('trucks', 'customers'));
    }


    // public function store(Request $request)
    // {
    //     // Validate the request data
    //     $request->validate([
    //         'sales_date' => 'required|date',
    //         // 's_no' => 'required|string',
    //         'good_receipts_truck_id' => 'required|exists:good_receipts_truck,id_truck',
    //         'customer_id' => 'required|exists:customers,id_customers',
    //         'bill_no' => 'nullable|string',
    //         'details' => 'nullable|string',
    //         'bori_details' => 'nullable|string',
    //         'total_bori' => 'nullable|numeric',
    //         'remaining_amount' => 'nullable|numeric',
    //         'cash_received' => 'nullable|numeric',
    //         'total_amount' => 'nullable|numeric',
    //         'items_name.*' => 'nullable|string',
    //         'marka.*' => 'nullable|string',
    //         'bori.*' => 'nullable|numeric',
    //         'weight.*' => 'nullable|numeric',
    //         'rate.*' => 'nullable|numeric',
    //         'amount.*' => 'nullable|numeric',
    //         'bori_number.*' => 'nullable|string',
    //         'per_bori_weight.*' => 'nullable|numeric',
    //     ]);
    //     // Sales
    //     // dd($request);
    //     $sale = Sale::create([
    //         'business_id' => auth()->user()->business_id,
    //         'good_receipts_truck_id' => $request->good_receipts_truck_id,
    //         'customer_id' => $request->customer_id,
    //         'date' => $request->sales_date,
    //         // 's_no' => $request->s_no,
    //         'bill_no' => $request->bill_no,
    //         'details' => $request->details,
    //         'bori_details' => $request->bori_details,
    //         'balance' => $request->remaining_amount,
    //         'paid' => $request->cash_received,
    //         'total_amount' => $request->total_amount,
    //         'status' => $request->sales_status,
    //         'created_by' => auth()->id(),
    //     ]);

    //     // Handle Item Details
    //     $items = $request->items_name ?? [];
    //     $marka = $request->marka ?? [];
    //     $bori = $request->bori ?? [];
    //     $weight = $request->weight ?? [];
    //     $rate = $request->rate ?? [];
    //     $amount = $request->amount ?? [];

    //     foreach ($items as $index => $item) {
    //         // Ensure that all related fields are set
    //         SalesItemDetail::create([
    //             'sales_id' => $sale->id_sales,
    //             'items_name' => $item,
    //             'marka' => $marka[$index] ?? null,
    //             'bori' => $bori[$index] ?? null,
    //             'weight' => $weight[$index] ?? null,
    //             'rate' => $rate[$index] ?? null,
    //             'amount' => $amount[$index] ?? 0,
    //             'notes' => 'N/A',
    //             'status' => '1',
    //         ]);
    //     }

    //     // Handle Additional Bori Details
    //     $bori_num = $request->bori_number ?? [];
    //     $bori_weight = $request->per_bori_weight ?? [];

    //     foreach ($bori_num as $index => $bori) {
    //         SalesPerBoriWeight::create([
    //             'sales_id' => $sale->id_sales,
    //             'bori_number' => $bori,
    //             'per_bori_weight' => $bori_weight[$index] ?? null,
    //         ]);
    //     }

    //     return redirect()->route('sales.list')->with('success', 'Sale created successfully');
    // }
    public function store(Request $request)
    {
        // dd($request);
        // Validate the request data
        $request->validate([
            'sales_date' => 'required|date',
            'good_receipts_truck_id' => 'required|exists:good_receipts_truck,id_truck',
            'customer_id' => 'required|exists:customers,id_customers',
            'bill_no' => 'nullable|string',
            'details' => 'nullable|string',
            'bori_details' => 'nullable|string',
            'total_bori' => 'nullable|string',
            'remaining_amount' => 'nullable|string',
            'cash_received' => 'nullable|string',
            'total_amount' => 'nullable|string',
            'bori' => 'nullable|string',
            'weight' => 'nullable|string',
            'rate' => 'nullable|string',
            'amount' => 'nullable|string',
            'getGoodsDetailId' => 'required|exists:good_receipts_details,id_grd'
        ]);

        // Update the stock
        // $goodDetails = GoodReceiptDetail::where('id_grd', $request->getGoodsDetailId)->first();
        // if (isset($request->bori) && $goodDetails->bori >= $request->bori || isset($request->weight) && $goodDetails->weight >= $request->weight) {
        //     $goodDetails->weight -= $request->weight;
        //     $goodDetails->bori -= $request->bori;
        //     $goodDetails->save();
        // } else {
        //     return redirect()->back()->with('error', 'Stock not available!');
        // }
        $goodDetails = GoodReceiptDetail::where('id_grd', $request->getGoodsDetailId)->first();

        if (!$goodDetails) {
            return redirect()->back()->with('error', 'Stock record not found!');
        }

        $boriRequested = $request->bori ?? 0; // Default to 0 if not set
        $weightRequested = $request->weight ?? 0; // Default to 0 if not set

        // Ensure sufficient stock is available for both `bori` and `weight`
        if (($boriRequested <= $goodDetails->bori)) {
            // Update only the requested fields
            if ($boriRequested > 0) {
                $goodDetails->bori -= $boriRequested;
            }
            $goodDetails->save();
        } else {
            return redirect()->back()->with('error', 'Stock not available!');
        }
        // Create the sale
        $sale = Sale::create([
            'business_id' => auth()->user()->business_id,
            'good_receipts_truck_id' => $request->good_receipts_truck_id,
            'customer_id' => $request->customer_id,
            'date' => $request->sales_date,
            'bill_no' => $request->bill_no,
            'details' => $request->details,
            'bori_details' => $request->bori_details,
            'balance' => $request->remaining_amount,
            'paid' => $request->cash_received,
            'total_amount' => $request->total_amount,
            'status' => $request->sales_status,
            'created_by' => auth()->user()->id,
        ]);

        // Create the sales item detail
        SalesItemDetail::create([
            'sales_id' => $sale->id_sales,
            'good_detail_id' => $request->getGoodsDetailId,
            'items_main_cate' => $request->getMainCateName ?? null,
            'items_parent_cate' => $request->getParentCateName ?? null,
            'items_child_cate' => $request->getChildCateName ?? null,
            'marka' => $request->getItemsMarka ?? null,
            'bori' => $request->bori ?? null,
            'weight' => $request->weight ?? null,
            'rate' => $request->rate ?? null,
            'amount' => $request->amount ?? 0,
            'notes' => 'N/A',
            'status' => '1',
        ]);
        // dd($sale);
        return redirect()->route('sales.list')->with('success', 'Sale created successfully');
    }


    public function edit($id)
    {
        $sale = Sale::with('salesItemsDetails', 'salesPerBoriWeight')->findOrFail(Crypt::decrypt($id));
        // $trucks = GoodReceiptTruck::all();
        // $trucks = GoodReceiptTruck::with([
        //     'goodReceipts' => function ($query) {
        //         $query->with(['goodReceiptDetails.productMainCate', 'goodReceiptDetails.productParentCate', 'goodReceiptDetails.productChildCate', 'supplier']);
        //     }
        // ])->get();
        $trucks = GoodReceiptTruck::with([
            'goodReceipts' => function ($query) {
                $query->with([
                    'goodReceiptDetails' => function ($query) {
                        // Only get good receipt details where bori is greater than 0
                        $query->where('bori', '>', 0)
                            ->with(['productMainCate', 'productParentCate', 'productChildCate']);
                    },
                    'supplier'
                ]);
            }
        ])->get();
        $customers = Customer::all();

        return view('sales.edit', compact('sale', 'trucks', 'customers'));
    }

    public function update(Request $request, $id)
    {
        // dd($request);
        // Validate the request data
        $request->validate([
            'sales_date' => 'required|date',
            'good_receipts_truck_id' => 'required|exists:good_receipts_truck,id_truck',
            'customer_id' => 'required|exists:customers,id_customers',
            'bill_no' => 'nullable|string',
            'details' => 'nullable|string',
            'bori_details' => 'nullable|string',
            'total_bori' => 'nullable|string',
            'remaining_amount' => 'nullable|string',
            'cash_received' => 'nullable|string',
            'total_amount' => 'nullable|string',
            'bori' => 'nullable|string',
            'weight' => 'nullable|numeric',
            'rate' => 'nullable|string',
            'amount' => 'nullable|string',
            'getGoodsDetailId' => 'nullable|exists:good_receipts_details,id_grd',
            'saleItemDetailsId' => 'required|exists:sales_items_details,id_sid',
        ]);
        // dd($request);
        // Update the stock
        $salesItemDetail = SalesItemDetail::where('good_detail_id', $request->getGoodsDetailId)->first();

        if ($salesItemDetail && !empty($request->bori)) {
            $newAddedQuantity = $request->bori - $salesItemDetail->bori;
        } else {
            $newAddedQuantity = $request->bori;
        }

        $goodDetails = GoodReceiptDetail::where('id_grd', $request->getGoodsDetailId)->first();

        if ($goodDetails && $goodDetails->bori >= $newAddedQuantity) {
            $newadd = $goodDetails->bori -= $newAddedQuantity;
            $goodDetails->save();
        } else {
            return redirect()->back()->with('error', 'Stock not available for the requested quantity.');
        }

        // Start transaction
        DB::beginTransaction();

        try {
            // Find the sale to update
            $sale = Sale::findOrFail(Crypt::decrypt($id));

            // Update sale details
            $sale->update([
                'date' => $request->sales_date,
                'good_receipts_truck_id' => $request->good_receipts_truck_id,
                'customer_id' => $request->customer_id,
                'bill_no' => $request->bill_no,
                'details' => $request->details,
                'bori_details' => $request->bori_details,
                'balance' => $request->remaining_amount,
                'paid' => $request->cash_received,
                'total_amount' => $request->total_amount,
                'status' => $request->sales_status,
            ]);

            // Find and update the sales item details
            $salesDetail = SalesItemDetail::findOrFail($request->saleItemDetailsId);

            $salesDetail->update([
                'good_detail_id' => $request->getGoodsDetailId,
                'items_main_cate' => $request->getMainCateName,
                'items_parent_cate' => $request->getParentCateName,
                'items_child_cate' => $request->getChildCateName,
                'marka' => $request->getItemsMarka,
                'bori' => $request->bori, // Updated with the new value
                'weight' => $request->weight,
                'rate' => $request->rate,
                'amount' => $request->amount ?? 0,
                'notes' => 'N/A',
                'status' => '1',
            ]);

            DB::commit();

            return redirect()->route('sales.list')->with('success', 'Sale updated successfully');
        } catch (\Exception $e) {

            DB::rollBack();
            return redirect()->back()->with('error', 'Error updating sale: ' . $e->getMessage());
        }
    }

    // old base
    // public function update(Request $request, $id)
    // {
    //     // Validate the request data
    //     $request->validate([
    //         'sales_date' => 'required|date',
    //         // 's_no' => 'required|string',
    //         'good_receipts_truck_id' => 'required|exists:good_receipts_truck,id_truck',
    //         'customer_id' => 'required|exists:customers,id_customers',
    //         'bill_no' => 'required|string',
    //         'details' => 'nullable|string',
    //         'bori_details' => 'nullable|string',
    //         'total_bori' => 'nullable|numeric',
    //         'remaining_amount' => 'nullable|numeric',
    //         'cash_received' => 'nullable|numeric',
    //         'total_amount' => 'nullable|numeric',
    //         'items_name.*' => 'nullable|string',
    //         'marka.*' => 'nullable|string',
    //         'bori.*' => 'nullable|numeric',
    //         'weight.*' => 'nullable|numeric',
    //         'rate.*' => 'nullable|numeric',
    //         'amount.*' => 'nullable|numeric',
    //         'item_detail_ids.*' => 'nullable|integer',
    //         'bori_number.*' => 'nullable|string',
    //         'per_bori_weight.*' => 'nullable|numeric',
    //         'bori_detail_ids.*' => 'nullable|integer',
    //     ]);

    //     // Start transaction
    //     DB::beginTransaction();

    //     try {
    //         // Find the sale to update
    //         $sale = Sale::findOrFail(Crypt::decrypt($id));

    //         // Update sale details
    //         $sale->update([
    //             'date' => $request->sales_date,
    //             // 's_no' => $request->s_no,
    //             'good_receipts_truck_id' => $request->good_receipts_truck_id,
    //             'customer_id' => $request->customer_id,
    //             'bill_no' => $request->bill_no,
    //             'details' => $request->details,
    //             'bori_details' => $request->bori_details,
    //             'balance' => $request->remaining_amount,
    //             'paid' => $request->cash_received,
    //             'total_amount' => $request->total_amount,
    //             'status' => $request->sales_status,
    //         ]);

    //         // Handle SalesItemDetails
    //         $itemsNames = $request->items_name ?? [];
    //         $existingItemIds = $request->item_detail_ids ?? [];
    //         $existingItems = $sale->salesItemsDetails->pluck('id_sid')->toArray();

    //         foreach ($itemsNames as $index => $itemName) {
    //             $itemData = [
    //                 'items_name' => $itemName,
    //                 'marka' => $request->marka[$index] ?? null,
    //                 'bori' => $request->bori[$index] ?? null,
    //                 'weight' => $request->weight[$index] ?? null,
    //                 'rate' => $request->rate[$index] ?? null,
    //                 'amount' => $request->amount[$index] ?? 0,
    //                 'notes' => 'N/A',
    //                 'status' => '1',
    //             ];

    //             $itemId = $request->item_detail_ids[$index] ?? null;

    //             if ($itemId) {
    //                 // Update existing item
    //                 $itemDetail = SalesItemDetail::find($itemId);
    //                 if ($itemDetail) {
    //                     $itemDetail->update($itemData);
    //                 }
    //             } else {
    //                 // Create new item
    //                 $sale->salesItemsDetails()->create($itemData);
    //             }
    //         }

    //         // Delete removed items
    //         $itemsToDelete = array_diff($existingItems, $existingItemIds);
    //         SalesItemDetail::whereIn('id_sid', $itemsToDelete)->delete();

    //         // Handle SalesPerBoriWeight
    //         $boriNumbers = $request->bori_number ?? [];
    //         $existingBoriIds = $request->bori_detail_ids ?? [];
    //         $existingBoris = $sale->salesPerBoriWeight->pluck('id_sales_per_bw')->toArray();

    //         foreach ($boriNumbers as $index => $boriNumber) {
    //             $boriData = [
    //                 'bori_number' => $boriNumber,
    //                 'per_bori_weight' => $request->per_bori_weight[$index] ?? null,
    //             ];

    //             $boriId = $request->bori_detail_ids[$index] ?? null;

    //             if ($boriId) {
    //                 // Update existing bori detail
    //                 $boriDetail = SalesPerBoriWeight::find($boriId);
    //                 if ($boriDetail) {
    //                     $boriDetail->update($boriData);
    //                 }
    //             } else {
    //                 // Create new bori detail
    //                 $boriData['sales_id'] = $sale->id_sales;
    //                 SalesPerBoriWeight::create($boriData);
    //             }
    //         }

    //         // Delete removed bori details
    //         $borisToDelete = array_diff($existingBoris, $existingBoriIds);
    //         SalesPerBoriWeight::whereIn('id_sales_per_bw', $borisToDelete)->delete();

    //         // Commit transaction
    //         DB::commit();

    //         return redirect()->route('sales.list')->with('success', 'Sale updated successfully');
    //     } catch (\Exception $e) {
    //         // Rollback transaction
    //         DB::rollBack();
    //         return redirect()->back()->with('error', 'Error updating sale: ' . $e->getMessage());
    //     }
    // }

    public function destroy($id)
    {
        $sale = Sale::with([
            'salesItemsDetails',
            'salesItemsDetails.goodReceiptDetail'
        ])->findOrFail(Crypt::decrypt($id));


        foreach ($sale->salesItemsDetails as $detail) {

            $grDetail = $detail->goodReceiptDetail;

            if ($grDetail) {
                $grDetail->bori += $detail->bori;
                $grDetail->save();
            }
        }
        $sale->salesItemsDetails()->delete();
        $sale->delete();


        return redirect()->route('sales.list')->with('success', 'Sale deleted successfully');
    }

    public function getItemsByTruck($truckId)
    {
        $items = GoodReceiptDetail::where('truck_id', $truckId)->pluck('goods_name', 'id_grd')->toArray();
        $markas = GoodReceiptDetail::where('truck_id', $truckId)->pluck('marka')->unique()->toArray();

        return response()->json([
            'items' => $items,
            'markas' => $markas
        ]);
    }

    public function getItemsByMarka($truckId, $marka)
    {
        $items = GoodReceiptDetail::where('truck_id', $truckId)->where('marka', $marka)->pluck('goods_name', 'id_grd')->toArray();

        return response()->json($items);
    }

    public function getItemDetails(Request $request)
    {
        $marka = $request->input('marka');
        $item = $request->input('item');

        // Fetch the item details based on Marka and Item
        $itemDetails = GoodReceiptDetail::where('marka', $marka)
            ->where('goods_name', $item)
            ->first();

        // echo $itemDetails->bori;

        if ($itemDetails) {
            return response()->json([
                'bori' => $itemDetails->bori,
                'weight' => $itemDetails->weight,
                'rate' => $itemDetails->rate,
            ]);
        }

        return response()->json([], 404);
    }


    public function print($id)
    {
        $dec_id = Crypt::decrypt($id);
        $sales = Sale::with('salesItemsDetails', 'customer')->where('id_sales', $dec_id)->get();
        return view('sales.print', compact('sales'));
    }
}
