@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>User Management</span>
        <span>Add User</span>
    </div>

    <h2 class="az-content-title" style="display: inline">
        Add New User
        <span>
            <a href="{{ url('users') }}" class="btn border" style="float: right">
                <i class="fa-solid fa-bars-staggered"></i> Back to Users
            </a>
        </span>
    </h2>

    <div class="separator-breadcrumb border-top"></div>

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <h5 class="card-title mg-b-20">Add User Details</h5>

                {{-- Alerts --}}
                @if (Session('alert'))
                    <div class="alert alert-card alert-{{ Session('alert-class') }}" role="alert">
                        {{ Session('alert') }}
                        <button class="close" type="button" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif

                {{-- Validation Errors --}}
                @if ($errors->any())
                    <div class="p-1">
                        @foreach ($errors->all() as $error)
                            <div class="alert alert-warning alert-danger fade show" role="alert">
                                {{ $error }}
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                        @endforeach
                    </div>
                @endif

                {{-- Form --}}
                <form action="{{ url('users/store') }}" method="post" enctype="multipart/form-data">
                    @csrf

                    {{-- Checkbox: Create user for employee --}}
                    <div class="row">
                        <div class="col-md-12">
                          <div class="form-group form-check form-switch">
    <input type="checkbox" class="form-check-input" id="create_employee" name="create_employee">
    <label class="form-check-label" for="create_employee">
        Create user for an existing employee
    </label>
</div>
                        </div>
                    </div>

                    {{-- Employee Select (hidden initially) --}}
                    <div class="row">
                        <div class="col-md-4" id="employee_select_div" style="display: none;">
                            <div class="form-group">
                                <label for="employee_id">Select Employee</label>
                                <select id="employee_id" name="employee_id" class="form-control">
                                    <option value="">Select Employee</option>
                                    @foreach ($employees as $employee)
                                        <option
                                            value="{{ $employee->id }}"
                                            data-name="{{ $employee->first_name.' '.$employee->last_name }}"
                                            data-email="{{ $employee->email }}"
                                        >
                                            {{ $employee->first_name.' '.$employee->last_name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>

                    {{-- User Name, Email, Role --}}
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Full Name <span style="color:red;">*</span></label>
                                <input name="name" id="name" class="form-control" value="{{ old('name') }}" />
                                @error('name')
                                    <span class="form-text text-muted"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600" for="email">Email <span style="color:red;">*</span></label>
                                <input name="email" id="email" class="form-control" value="{{ old('email') }}" />
                                @error('email')
                                    <span class="form-text text-muted"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600" for="role_id">Role <span style="color:red;">*</span></label>
                                <select id="role_id" name="role_id" class="form-control">
                                    <option value="0">Select</option>
                                    @foreach ($roles as $role)
                                        <option {{ old('role_id') == $role['id'] ? 'selected' : '' }} value="{{ $role['id'] }}">
                                            {{ $role['name'] }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('role_id')
                                    <span class="form-text text-muted"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>
                        </div>
                    </div>

                    {{-- Password & Confirm Password --}}
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600" for="password">Password <span style="color:red;">*</span></label>
                                <input type="password" name="password" id="password" class="form-control" />
                                @error('password')
                                    <span class="form-text text-muted"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600" for="confirm_password">Confirm Password <span style="color:red;">*</span></label>
                                <input type="password" name="password_confirmation" id="confirm_password" class="form-control" />
                                @error('password_confirmation')
                                    <span class="form-text text-muted"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>
                        </div>
                    </div>

                    {{-- Buttons --}}
                    <a href="{{ url('users') }}" class="btn btn-danger btn-block mt-2">Cancel</a>
                    <button type="submit" class="btn btn-az-primary btn-block mt-2" style="float: right">Submit</button>
                </form>
            </div>
        </div>
    </div>

    {{-- Scripts --}}
    <script src="https://cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const checkbox = document.getElementById('create_employee');
            const employeeDiv = document.getElementById('employee_select_div');
            const employeeSelect = document.getElementById('employee_id');
            const usernameInput = document.getElementById('name');
            const emailInput = document.getElementById('email');

            // Toggle employee select box
            checkbox.addEventListener('change', function() {
                if(this.checked) {
                    employeeDiv.style.display = 'block';
                } else {
                    employeeDiv.style.display = 'none';
                    employeeSelect.value = '';
                    usernameInput.value = '';
                    emailInput.value = '';
                }
            });

            // Auto-fill username and email on employee selection
            employeeSelect.addEventListener('change', function() {
                const selectedOption = this.options[this.selectedIndex];
                usernameInput.value = selectedOption.getAttribute('data-name') || '';
                emailInput.value = selectedOption.getAttribute('data-email') || '';
            });
        });
    </script>
@endsection
