@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Users</span>
    </div>
    <h2 class="az-content-title" style="display: inline"> Users List<span>
            @can('Users Management add')
                <a href="{{ url('users/create') }}" class="btn btn-az-primary" style="float: right">
                    <i class="fa-solid fa-plus"></i> Add User</a>
            @endcan
        </span>
    </h2>
    {{-- <div class="az-content-body pd-lg-l-40 d-flex flex-column"> --}}
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-20">

                <div>
                    <table id="example2" class="table table-bordered">
                        <thead>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-20p">User Name</th>
                                <th class="wd-15p">User Role</th>
                                <th class="wd-10p">Status</th>
                                <th class="wd-10p">Created</th>
                                <th class="wd-10p">Updated</th>
                                <th class="wd-10p">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($users as $key => $my_user)
                                <tr>
                                    <td>{{ $key + 1 }}</td>
                                    <td>{{ $my_user->name }}</td>
                                    <td>{{ $my_user->getRoleNames()->first() ?? 'No Role' }}</td>
                                    <td>
                                        @if ($my_user->status == 1)
                                            <button class="btn btn-rounded btn-success" style="color:#fff;">
                                                Active
                                            </button>
                                        @else
                                            <button class="btn btn-rounded btn-danger" style="color:#fff;">
                                                In-Active
                                            </button>
                                        @endif
                                    </td>
                                    <td>{{ $my_user->created_at->format('d-m-Y') }}</td>
                                    <td>{{ $my_user->updated_at->format('d-m-Y') }}</td>
                                    <td>
                                        @can('Users Management edit')
                                            <a class="btn rounded shadow-base" title="Edit User"
                                                href="{{ url('users/edit/' . Crypt::encrypt($my_user->id)) }}">
                                                <i class="text-primary fa-regular fa-pen-to-square"></i>
                                                <span class="text-primary">Edit</span>
                                            </a>
                                        @endcan
                                    </td>
                                </tr>
                            @endforeach

                        </tbody>
                        <tfoot>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-20p">User Name</th>
                                <th class="wd-15p">User Role</th>
                                <th class="wd-10p">Status</th>
                                <th class="wd-10p">Created</th>
                                <th class="wd-10p">Updated</th>
                                <th class="wd-10p">Action</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
            <!-- card -->
        </div>
        <!-- col -->
    </div>


    {{-- </div><!-- az-content-body --> --}}
@endsection
@push('scripts')
    <script>
        $(function() {
            oTable = $('#example2').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'csv',
                        text: 'CSV',
                        title: 'Supplier List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'excel',
                        text: 'Excel',
                        title: 'Supplier List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'pdf',
                        text: 'PDF',
                        title: 'Supplier List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'print',
                        text: 'Print',
                        title: 'Supplier List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    }
                ],
                responsive: !0
            });
        });
    </script>
@endpush
