@extends('layouts.master')

@section('content')
    <div class="az-content-breadcrumb">
        <span>B-Cheque</span>
    </div>
    <h2 class="az-content-title" style="display: inline">
        B-Cheque List
        <span>
            @can('B-Cheque add')
                <a id="addbtn" href="{{ route('b_cheque.create') }}" class="btn btn-az-primary" style="float: right">
                    <i class="fa-solid fa-plus"></i> Create B-Cheque </a>
            @endcan
        </span>
    </h2>

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-20">
                <div>
                    <table id="example2" class="table table-striped">
                        <thead>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-10p">Date</th>
                                <th class="wd-10p">PB No</th>
                                <th class="wd-10p">Vehicle</th>
                                <th class="wd-10p">Bilty No</th>
                                <th class="wd-10p">Supplier</th>
                                <th class="none">Item Details</th>
                                <th class="wd-10p">Total Amount</th>
                                <th class="wd-10p">Total Expanse</th>
                                <th class="wd-10p">Save Amount</th>
                                <th class="none">View</th>
                                <th class="wd-10p">Created By</th>
                                <th class="none">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($b_cheques as $bCheque)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $bCheque->date }}</td>
                                    <td>{{ $bCheque->pb_no }}</td>
                                    <td>{{ $bCheque->goodReceiptTruck->truck_no ?? '' }}</td>
                                    <td>{{ $bCheque->bilty_no }}</td>
                                    <td>{{ $bCheque->supplier->supplier_name ?? 'N/A' }}</td>
                                    <td>
                                        <table class="table table-bordered">
                                            <tr>
                                                <th>Main Category</th>
                                                <th>Parent Category</th>
                                                <th>Child Category</th>
                                                <th>Marka</th>
                                                <th>Bori</th>
                                                <th>Weight</th>
                                                <th>Price</th>
                                                <th>Amount</th>
                                            </tr>
                                            @foreach ($bCheque->mergedItems as $item)
                                                <tr>
                                                    <td>{{ $item['main_cate'] }}</td>
                                                    <td>{{ $item['parent_cate'] }}</td>
                                                    <td>{{ $item['child_cate'] }}</td>
                                                    <td>{{ $item['marka'] }}</td>
                                                    <td>{{ $item['bori'] }}</td>
                                                    <td>{{ $item['weight'] }}</td>
                                                    <td>{{ number_format($item['rate'], 0) }}</td>
                                                    <td>{{ number_format($item['amount'], 0) }}</td>
                                                </tr>
                                            @endforeach
                                        </table>
                                    </td>
                                    <td>{{ number_format($bCheque->details?->total_amount, 0) ?? 'N/A' }}</td>
                                    <td>{{ number_format($bCheque->details?->total_expanse_amount, 0) ?? 'N/A' }}</td>
                                    <td>{{ number_format($bCheque->details?->save_amount, 0) ?? 'N/A' }}</td>
                                    <td>
                                        @can('B-Cheque print')
                                            <a class="btn rounded shadow-base" title="Print B-Cheque"
                                                href="{{ route('b_cheque.invoice.printview', Crypt::encrypt($bCheque->id_b_cheque)) }}">
                                                <i class="text-primary fa-regular fa-pen-to-square"></i>
                                                <span class="text-primary">Print</span>
                                            </a>
                                        @endcan
                                    </td>
                                    <td>{{ $bCheque->created_by }}</td>
                                    <td>
                                        @can('B-Cheque edit')
                                            <a class="btn rounded shadow-base" title="Edit B-Cheque"
                                                href="{{ route('b_cheque.edit', Crypt::encrypt($bCheque->id_b_cheque)) }}">
                                                <i class="text-primary fa-regular fa-pen-to-square"></i>
                                                <span class="text-primary">Edit</span>
                                            </a>
                                        @endcan
                                        @can('B-Cheque delete')
                                            <a class="btn rounded shadow-base" title="Delete B-Cheque" data-toggle="modal"
                                                data-target="#deleteModal"
                                                data-id="{{ Crypt::encrypt($bCheque->id_b_cheque) }}">
                                                <i class="text-danger fa-solid fa-trash-can"></i>
                                                <span class="text-danger">Remove</span>
                                            </a>
                                        @endcan
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-10p">Date</th>
                                <th class="wd-10p">PB No</th>
                                <th class="wd-10p">Vehicle</th>
                                <th class="wd-10p">Bilty No</th>
                                <th class="wd-10p">Supplier</th>
                                <th class="none">Item Details</th>
                                <th class="wd-10p">Total Amount</th>
                                <th class="wd-10p">Total Expanse Amount</th>
                                <th class="wd-10p">Save Amount</th>
                                <th class="none">View</th>
                                <th class="wd-10p">Created By</th>
                                <th class="none">Action</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this B-Cheque?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" action="" method="POST">
                        @csrf
                        @method('DELETE')
                        <button type="button" class="btn btn-secondary text-light" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script type="text/javascript">
        document.addEventListener('keydown', function(event) {
            // Check if CTRL + A (or CMD + A) is pressed
            if ((event.ctrlKey || event.metaKey) && event.key.toLowerCase() === 'a') {
                event.preventDefault(); // Prevent default "Select All" behavior

                // Trigger the click event on the "Add Goods Receipts" button
                document.getElementById('addbtn').click();
            }
        });
        $(function() {
            oTable = $('#example2').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'csv',
                        text: 'CSV',
                        title: 'B-Cheques List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'excel',
                        text: 'Excel',
                        title: 'B-Cheques List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'pdf',
                        text: 'PDF',
                        title: 'B-Cheques List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'print',
                        text: 'Print',
                        title: 'B-Cheques List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    }
                ],
                responsive: true
            });
        });

        $(document).ready(function() {
            $('#deleteModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget);
                var id = button.data('id');
                var actionUrl = '{{ url('b_cheque/destroy') }}/' + id;
                var modal = $(this);
                modal.find('#deleteForm').attr('action', actionUrl);
            });
        });
    </script>
@endpush
