@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Customers</span>
        {{-- <span>Add Airline</span> --}}
        {{-- <span>Forms</span> --}}
        {{-- <span>Form Layouts</span> --}}
    </div>
    <h2 class="az-content-title" style="display: inline"> Customers List <span>
            @can('Customers add')
                <a id="addbtn" href="{{ url('customers/create') }}" class="btn btn-az-primary" style="float: right">
                    <i class="fa-solid fa-plus"></i>
                    Add Customers</a></span>
        @endcan
    </h2>
    {{-- <h2 style="float: right" class="az-content-title"></h2> --}}
    {{-- <div class="az-content-body pd-lg-l-40 d-flex flex-column"> --}}
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-20">
                <div>
                    <table id="example2" class="table table-striped">
                        <thead>
                            <tr>
                                <th class="wd-5">S.No</th>
                                <th class="wd-5">IM</th>
                                <th class="wd-15p">Name</th>
                                <th class="wd-15p">کھا تہ</th>
                                <th class="wd-15p">Email</th>
                                <th class="wd-15p ">Address </th>
                                <th class="wd-10p ">City</th>
                                <th class="wd-15p">Number</th>
                                <th class="wd-15p">Whatsapp</th>
                                <th class="none ">Created</th>
                                <th class="none ">Updated</th>
                                <th class="none">Operations</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($customers as $key => $cus)
                                <?php
                                if (!empty($hotel['customer_image'])) {
                                    $image = url('/uploads/customer_images/' . $hotel['customer_image']);
                                } else {
                                    $image = url('/img/default_user.png');
                                }
                                $sale_person = \App\User::select('users.name')->where('id', '=', $cus->sale_person)->first();
                                $whatsapp_enabled = '';
                                if ($cus->whatsapp_check == 1) {
                                    $whatsapp_enabled = '<img src="img/whatsapp.png" style="height:20px;width:20px;border-radius: 50%" alt="" srcset="">';
                                }
                                ?>
                                <tr>
                                    <td>{{ $key + 1 }}</td>
                                    <td><img src="<?= $image ?>" style="height:20px;width:20px;border-radius: 50%"
                                            alt="" srcset=""></td>
                                    <td>{{ $cus->customer_name }}</td>
                                    <td>{{ $cus->customer_name_urdu }}</td>
                                    <td>{{ $cus->customer_email }}</td>
                                    <td>{{ $cus->customer_address }}</td>
                                    <td>{{ getCity($cus->customer_city) }}</td>
                                    <td>{{ $cus->customer_cell }}</td>
                                    <td>{{ $cus->whatsapp_number }}</td>
                                    <td><?= date('d-m-Y', strtotime($cus->created_at)) ?></td>
                                    <td><?= date('d-m-Y', strtotime($cus->updated_at)) ?></td>
                                    <td>
                                        @can('Customers edit')
                                            <a class="btn rounded shadow-base" title="Edit Discount"
                                                href="{{ url('customers/edit/' . Crypt::encrypt($cus->id_customers)) }}">
                                                <i class="text-primary fa-regular fa-pen-to-square"></i> <span
                                                    class="text-primary"> Edit </span>
                                            </a>
                                        @endcan
                                        @can('Customers view')
                                            <a class="btn rounded shadow-base" title="Customer Details"
                                                href="{{ url('customers/view/' . Crypt::encrypt($cus->id_customers)) }}">
                                                <span class="mdi mdi-account-details-outline text-success"></span> <span
                                                    class="text-success">
                                                    Summary</span>
                                            </a>
                                        @endcan
                                        @can('Customers delete')
                                            <a class="btn rounded shadow-base" title="Delete Product"
                                                href="{{ url('customers/destroy/' . Crypt::encrypt($cus->id_customers)) }}">
                                                <i class="text-danger fa-solid fa-trash-can"></i> <span
                                                    class="text-danger">Remove</span>
                                            </a>
                                        @endcan
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th class="wd-5">S.No</th>
                                <th class="wd-5">IM</th>
                                <th class="wd-15p">Name</th>
                                <th class="wd-15p">کھا تہ</th>
                                <th class="wd-15p">Email</th>
                                <th class="wd-15p ">Address </th>
                                <th class="wd-10p ">City</th>
                                <th class="wd-15p">Number</th>
                                <th class="wd-15p">Whatsapp</th>
                                <th class="none ">Created</th>
                                <th class="none ">Updated</th>
                                <th class="none">Operations</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
            <!-- card -->
        </div>
        <!-- col -->
    </div>
    {{-- </div><!-- az-content-body --> --}}
@endsection
@push('scripts')
    <script type="text/javascript">
        document.addEventListener('keydown', function(event) {
            if ((event.ctrlKey || event.metaKey) && event.key === 'a') {
                event.preventDefault(); // Prevent default CTRL + A behavior (Select All)

                // Trigger the click on the "Add Customers" button
                document.getElementById('addbtn').click();
            }
        });

        $(function() {
            oTable = $('#example2').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'csv',
                        text: 'CSV',
                        title: 'Customers List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'excel',
                        text: 'Excel',
                        title: 'Customers List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'pdf',
                        text: 'PDF',
                        title: 'Customers List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'print',
                        text: 'Print',
                        title: 'Customers List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    }
                ],
                responsive: !0
            });
        });
    </script>
@endpush
