@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>General Preferences</span>
    </div>
    <div class="d-flex justify-content-between align-items-center">
        <h2 class="az-content-title" style="display: inline">General Preferences List</h2>
        <span>
            @can('General Preferences add')
                <button id="addbtn" type="button" class="btn btn-az-primary" data-toggle="modal" data-target="#exampleModal">
                    <i class="fa-solid fa-plus"></i>
                    Add
                </button>
            @endcan
        </span>
    </div>
    <div class="card card-body pd-20">
        <div class="row dataTables_wrapper">
            <div class="col-md-12 col-lg-12 col-xl-12">
                <div>
                    <table id="example2" class="table">
                        <thead>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-10p">Name</th>
                                <th class="wd-10p">Rate</th>
                                <th class="wd-10p">Amount Type</th>
                                <th class="wd-10p">Date</th>
                                <th class="wd-10p">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($pref as $key => $pre)
                                <tr>
                                    <td>{{ $key + 1 }}</td>
                                    <td>{{ $pre->name }}</td>
                                    <td>{{ number_format($pre->rate, 2) }}
                                        @if ($pre->amount_type == 'percentage')
                                            <span>%</span>
                                        @endif
                                    </td>
                                    <td>{{ $pre->amount_type }}</td>
                                    <td>{{ $pre->created_at }}</td>
                                    <td>
                                        @can('General Preferences edit')
                                            <a type="button" class="btn rounded shadow-base" data-toggle="modal"
                                                data-target="#exampleModal2" data-id="{{ $pre->id_general_preferrences }}"
                                                data-name="{{ $pre->name }}" data-rate="{{ $pre->rate }}"
                                                data-amounttype="{{ $pre->amount_type }}">
                                                <i class="text-primary fa-regular fa-pen-to-square"></i>
                                                <strong class="text-primary">Edit</strong>
                                            </a>
                                        @endcan
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-10p">Name</th>
                                <th class="wd-10p">Rate</th>
                                <th class="wd-10p">Amount Type</th>
                                <th class="wd-10p">Date</th>
                                <th class="wd-10p">Action</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <!-- Add General Preferences Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Add General Preferences</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="addMainAccountForm" action="{{ url('general_preferences/store') }}" method="POST">
                        @csrf
                        <div class="form-group mt-2">
                            <label for="Name">Name<span style="color:red;">*</span></label>
                            <input type="text" class="form-control" id="name" name="name" required>
                        </div>

                        <div class="form-group mt-2">
                            <label for="Rate">Rate<span style="color:red;">*</span></label>
                            <input type="text" class="form-control" id="rate" name="rate" required>
                        </div>
                        <div class="form-group mt-2">
                            <label for="Amount Type">Amount Type<span style="color:red;">*</span></label>
                            {{-- <input type="text" class="form-control" id="rate" name="rate" required> --}}
                            <select class="form-control" name="amount_type" id="amount_type">
                                <option value="amount">Amount</option>
                                <option value="percentage">Percentage</option>
                            </select>
                        </div>


                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-az-primary">Save</button>
                    </form>
                    <button type="button" class="btn btn-secondary text-white" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    {{-- Edit General Preferences Modal --}}
    <div class="modal fade" id="exampleModal2" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Edit Sub Control Account</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="editForm" method="POST">
                        @csrf

                        {{-- <div class="form-group mt-2">
                            <label for="Name">Name<span style="color:red;">*</span></label>
                            <input type="text" class="form-control" id="name" name="name" required>
                        </div> --}}

                        <div class="form-group mt-2">
                            <label for="Rate">Rate<span style="color:red;">*</span></label>
                            <input type="text" class="form-control" id="rate" name="rate" required>
                        </div>
                        <div class="form-group mt-2">
                            <label for="Amount Type">Amount Type<span style="color:red;">*</span></label>
                            {{-- <input type="text" class="form-control" id="rate" name="rate" required> --}}
                            <select class="form-control" name="amount_type" id="amount_type">
                                <option value="percentage">Percentage</option>
                                <option value="amount">Amount</option>
                            </select>
                        </div>

                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Save</button>
                    </form>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

    <script>
        // // Restrict input to Urdu characters only
        // document.getElementById('a_urdu_name_add').addEventListener('input', function(e) {
        //     var urduPattern = /[\u0600-\u06FF\u0750-\u077F ]/g;
        //     var inputValue = e.target.value;
        //     e.target.value = inputValue.replace(/[^\u0600-\u06FF\u0750-\u077F ]/g, '');
        // });

        document.addEventListener('keydown', function(event) {
            if ((event.ctrlKey || event.metaKey) && event.key === 'a') {
                event.preventDefault(); // Prevent default CTRL + A behavior (Select All)

                // Trigger the click on the "Add Customers" button
                document.getElementById('addbtn').click();
            }
        });
        document.addEventListener('keydown', function(event) {
            if ((event.ctrlKey || event.metaKey) && event.key === 's') {
                event.preventDefault();

                document.getElementById('addMainAccountForm').submit();
            }

            if (event.key === 'Enter') {
                event.preventDefault();
            }
        });
        $(function() {
            $('#example2').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'csv',
                        text: 'CSV',
                        title: 'General Preferences List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: ':not(:last-child)'
                        }
                    },
                    {
                        extend: 'excel',
                        text: 'Excel',
                        title: 'General Preferences List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: ':not(:last-child)'
                        }
                    },
                    {
                        extend: 'pdf',
                        text: 'PDF',
                        title: 'General Preferences List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: ':not(:last-child)'
                        }
                    },
                    {
                        extend: 'print',
                        text: 'Print',
                        title: 'General Preferences List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: ':not(:last-child)'
                        }
                    }
                ],
                responsive: true
            });
        });


        $('#exampleModal2').on('show.bs.modal', function(event) {
            var button = $(event.relatedTarget);
            var id = button.data('id');
            var name = button.data('name');
            var rate = button.data('rate');
            var amounttype = button.data('amounttype');

            var modal = $(this);
            modal.find('#editForm').attr('action', '{{ url('general_preferences/update') }}/' + id);
            modal.find('#name').val(name);
            modal.find('#name').val(name);
            modal.find('#rate').val(rate);
            modal.find('#amount_type').val(amounttype);
        });
    </script>
@endpush
