@extends('layouts.master')

@section('content')

    <style>
        @font-face {
            font-family: 'Jameel Noori Nastaleeq';
            src: url('path/to/JameelNooriNastaleeq.woff') format('woff'),
                url('path/to/JameelNooriNastaleeq.ttf') format('truetype');
        }

        .az-content-label-ur {
            font-family: 'Jameel Noori Nastaleeq', serif;
            font-size: 2vh;

            /* margin-bottom: 15px; */
            line-height: 2;
        }

        .urdu-font {
            font-size: 17px;
        }
    </style>
    <!-- Breadcrumb and Page Title -->
    <div class="az-content-breadcrumb">
        <span>Goods Receipts</span>
        <span>Add Goods Receipts</span>
    </div>
    <h2 class="az-content-title" style="display: inline">Add New Goods Receipts
        <span>
            <a href="{{ route('good_receipts.list') }}" class="btn border" style="float: right">
                <i class="fa-solid fa-bars-staggered"></i> Back to List
            </a>
        </span>
    </h2>
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <h5 class="card-title mg-b-20">Add Goods Receipts</h5>
                <form method="post" action="{{ route('good_receipts.store') }}" id="goodReceiptsForm">
                    @csrf
                    <!-- Error Display -->
                    @if (count($errors) > 0)
                        <div class="p-1">
                            @foreach ($errors->all() as $error)
                                <div class="alert alert-warning alert-danger fade show" role="alert">{{ $error }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    <!-- Basic Details -->
                    <div class="row row-sm mg-b-20">
                        <!-- Date, PNo, Truck Number -->
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="az-content-label" for="goods_date">Date</label>
                                <input type="text" id="goods_date" name="goods_date" class="form-control"
                                    value="{{ old('goods_date') }}" placeholder="dd/mm/yyyy" readonly />
                            </div>
                            @error('goods_date')
                                <span class="form-text text-danger"><strong>{{ $message }}</strong></span>
                            @enderror
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="az-content-label urdu-font" style="float: inline-end;">
                                    <span style="color:red;">*</span>
                                    ٹرک نمبر
                                </label>
                                <input type="text" name="truck_number" class="form-control" required
                                    value="{{ old('truck_number') }}" />
                            </div>
                            @error('truck_number')
                                <span class="form-text text-danger"><strong>{{ $message }}</strong></span>
                            @enderror
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">

                                <label class="az-content-label urdu-font" style="float: inline-end;">
                                    <span style="color:red;">*</span>
                                    سپلائرز
                                </label>

                                <select class="form-control select2" name="suppliers" id="suppliers" required>
                                    <option value="">- Select -</option>
                                    @foreach ($suppliers as $key => $supplier)
                                        <option value="{{ $supplier->id_supplier }}">
                                            {{ $supplier->supplier_name }} | {{ $supplier->supplier_name_urdu }}
                                        </option>
                                    @endforeach
                                </select>
                                <button type="button" style="color:#fff;" class="btn btn-sm btn-info mt-2 float-end"
                                    data-toggle="modal" data-target="#addSupplierModal">
                                    + Add Supplier
                                </button>
                            </div>
                            @error('suppliers')
                                <span class="form-text text-danger">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>

                    <!-- Suppliers, Builty Number, Rent Received -->
                    <div class="row row-sm mg-b-20">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="az-content-label urdu-font" style="float: inline-end;">
                                    بلٹی نمبر
                                </label>
                                <input type="text" name="builty_number" class="form-control"
                                    value="{{ old('truck_number') }}" />
                            </div>
                            @error('builty_number')
                                <span class="form-text text-danger"><strong>{{ $message }}</strong></span>
                            @enderror
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="az-content-label urdu-font" style="float: inline-end;">
                                    کرایہ وصول
                                </label>
                                <input type="text" name="rent_received" id="rent_received" class="form-control n-amount"
                                    value="{{ old('rent_received') }}"  />
                            </div>
                            @error('rent_received')
                                <span class="form-text text-danger"><strong>{{ $message }}</strong></span>
                            @enderror
                        </div>
                        <div class="col-md-4">
                            <label class="az-content-label" for="goods_status">Status</label>
                            <select id="goods_status" name="goods_status" class="form-control">
                                <option value="">Select</option>
                                <option value="1" {{ old('goods_status') == '1' ? 'selected' : 'selected' }}>
                                    Active
                                </option>
                                <option value="0" {{ old('goods_status') == '0' ? 'selected' : '' }}>
                                    In-Active
                                </option>
                            </select>
                            @error('goods_status')
                                <span class="form-text text-danger">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>

                    <!-- Details -->
                    <div class="row row-sm mg-b-20">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="az-content-label urdu-font" style="float: inline-end;">تفصیلات</label>
                                <textarea class="form-control" name="details" id="details">{{ old('details') }}</textarea>
                            </div>
                            @error('details')
                                <span class="form-text text-danger"><strong>{{ $message }}</strong></span>
                            @enderror
                        </div>
                    </div>

                    <!-- Items Section -->
                    <hr class="my-5">
                    <div id="items-wrapper">
                        <div class="row delete_row row-sm mg-b-20 shadow p-3 bg-light rounded" id="item-row-0">
                            {{-- For Main Category --}}
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label class="az-content-label" for="productMainCate">Main Category</label>
                                    <select name="productMainCate[]" id="productMainCate" class="form-control"
                                        onchange="checkForParentCate(this.value)">
                                        <option value="">Select Main Category</option>
                                        @foreach ($productCateMain as $key => $main)
                                            <option value="{{ $main->id_pro_cate_main }}">
                                                {{ $main->products_category_name }} |
                                                {{ $main->products_category_name_urdu }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                @error('productMainCate')
                                    <span class="form-text text-danger"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>

                            {{-- For Parent Category --}}
                            <div class="col-md-2" id="productParentCatShow" style="display: none;">
                                <div class="form-group">
                                    <label class="az-content-label" for="productParentCate">Parent Category</label>
                                    <select name="productParentCate[]" id="productParentCate" class="form-control"
                                        onchange="checkForChildCate(this.value)">
                                        <option value="">Select Parent Category</option>
                                    </select>
                                </div>
                                @error('productParentCate')
                                    <span class="form-text text-danger"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>

                            {{-- For Child Category --}}
                            <div class="col-md-2" id="productChildCatShow" style="display: none;">
                                <div class="form-group">
                                    <label class="az-content-label" for="productChildCate">Child Category</label>
                                    <select name="productChildCate[]" id="productChildCate" class="form-control">
                                        <option value="">Select Child Category</option>
                                    </select>
                                </div>
                                @error('productChildCate')
                                    <span class="form-text text-danger"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>

                            <div class="col-md-2">
                                <div class="form-group">
                                    <label class="az-content-label">Marka (مارکہ)</label>
                                    <input type="text" name="marka[]" class="form-control" />
                                </div>
                                @error('marka')
                                    <span class="form-text text-danger"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label class="az-content-label">Bori (بوری)</label>
                                    <input type="text" name="bori[]" required class="form-control n-amount" />
                                </div>
                                @error('bori')
                                    <span class="form-text text-danger"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label class="az-content-label">Weight (وزن)</label>
                                    <input type="text" name="weight[]" oninput="calculateAmount(this)"
                                        class="form-control weight-input n-amount" />
                                </div>
                                @error('weight')
                                    <span class="form-text text-danger"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label class="az-content-label">Remarks (ریمارکس)</label>
                                    <textarea class="form-control remarks-input" name="remarks[]"></textarea>
                                </div>
                                @error('remarks')
                                    <span class="form-text text-danger"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-12">
                        <button type="button" class="btn btn-az-primary btn-block mt-2" id="add-more">
                            <span class="mdi mdi-arrow-expand-up"></span> Add More
                        </button>
                    </div>

                    <!-- Show Total -->
                    <div class="row row-sm mg-b-20 mt-5" style="float: right;">
                        <div class="col-12">
                            <h3 style="line-height: 2.5rem;">
                                <span>
                                    Total Bori: <span id="total-bori">0</span>
                                </span>
                                <br>
                                <span>
                                    Total Weight: <span id="total-weight">0</span>
                                </span>
                            </h3>
                        </div>
                    </div>

                    <!-- Submit and Cancel Buttons -->
                    <div class="mt-5">
                        <a href="{{ route('good_receipts.list') }}" class="btn btn-danger pd-x-20">Cancel</a>
                        <button type="submit" class="btn btn-az-primary pd-x-20">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div id="errorNotification" class="alert alert-danger position-fixed top-0 end-0 m-3" style="display: none;">
        <strong>Error!</strong> <span id="errorMessage">Please select the row you want to delete.</span>
    </div>
    <div class="modal fade" id="addSupplierModal" tabindex="-1" role="dialog" aria-labelledby="addCustomerModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <form id="addSupplierForm" method="POST">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Add New Supplier</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span>&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label>Supplier Name (English)</label>
                            <input type="text" name="supplier_name" id="customer_name" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label>Supplier Name (Urdu)</label>
                            <input type="text" name="supplier_name_urdu" id="customer_name_urdu"
                                class="form-control urdu-font" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success" style="color:#fff;">Save</button>
                        <button type="button" id="mdcancelBtn" class="btn btn-secondary" style="color:#fff;"
                            data-dismiss="modal">Cancel</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@push('scripts')
    {{-- Instant Add Supplier Modal Script  --}}
    <script>
        $(document).ready(function() {

            document.querySelectorAll('.n-amount').forEach(function(el) {
                new AutoNumeric(el, {
                    digitGroupSeparator: ',',
                    decimalCharacter: '.',
                    unformatOnSubmit: true
                });
            });
            // Attach submit event
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $(document).on('submit', '#addSupplierForm', function(e) {
                e.preventDefault(); // stops page reload ✅

                let form = $(this);

                $.ajax({
                    url: "{{ route('supplier.store') }}",
                    method: "POST",
                    data: form.serialize(),
                    beforeSend: function() {
                        // optional: disable button or show loader
                    },
                    success: function(response) {
                        if (response.success) {
                            $('#mdcancelBtn').click();
                            $('#suppliers').empty().append(
                                '<option value="">- Select -</option>');
                            // Loop through suppliers and create <option> tags
                            response.suppliers.forEach(function(supplier) {
                                const option = `<option value="${supplier.id_supplier}">
                                    ${supplier.supplier_name} | ${supplier.supplier_name_urdu}
                                </option>`;
                                $('#suppliers').append(option);
                            });
                            $('#customer_name').val('')
                            $('#customer_name_urdu').val('')
                            toastr.success('Supplier added successfully!');

                        }
                    },
                    error: function(response) {
                        if (!response.success) {
                            let errors = response.responseJSON.errors;

                            if (errors) {
                                // Print each field error
                                Object.keys(errors).forEach(function(key) {
                                    errors[key].forEach(function(msg) {
                                        toastr.error(msg);
                                    });
                                });
                            } else {
                                // Fallback message
                                toastr.error(response.responseJSON.message);
                            }
                        }
                    }
                });
            });
        });
    </script>
    <script>
        document.addEventListener('keydown', function(event) {
            if ((event.ctrlKey || event.metaKey) && event.key === 's') {
                event.preventDefault();

                document.getElementById('goodReceiptsForm').submit();
            }

            if (event.key === 'Enter') {
                event.preventDefault();
            }
        });

        function calculateAmount(element) {
            // Get the closest parent with class "row"
            let row = element.closest('.row');

            // Get the values for weight and rate, with default to 0 if empty
            let weight = parseFloat(row.querySelector('.weight-input').value) || 0;
            let rate = parseFloat(row.querySelector('.rate-input').value) || 0;

            // Calculate the amount (rate * weight / 40)
            let amount = (rate * weight) / 40;

            // Set the calculated amount in the "amount-input" field
            row.querySelector('.amount-input').value = amount.toFixed(2);
        }

        function checkForParentCate(productMainCateId) {
            $.ajax({
                url: 'check-cate-parent',
                type: 'GET',
                data: {
                    productMainCateId: productMainCateId
                },
                success: function(response) {
                    if (response.productParentCate.length > 0) {
                        let options = '<option value="">Select Item</option>';
                        response.productParentCate.forEach(function(subParentCategory) {
                            options +=
                                `<option value="${subParentCategory.id_pro_sub_cat_parent}">${subParentCategory.name} | ${subParentCategory.name_urdu}</option>`;
                        });
                        $('#productParentCate').html(options);
                        $('#productParentCatShow').show();
                    } else {
                        $('#productParentCatShow').hide();
                        $('#productChildCatShow').hide();
                    }
                },
                error: function() {
                    alert('Error checking Product Parent Category!');
                }
            });
        }

        function checkForChildCate(productParentCateId) {
            $.ajax({
                url: 'check-cate-child',
                type: 'GET',
                data: {
                    productParentCateId: productParentCateId
                },
                success: function(response) {
                    if (response.productChildCate.length > 0) {
                        let options = '<option value="">Select Item</option>';
                        response.productChildCate.forEach(function(subChildCategory) {
                            options +=
                                `<option value="${subChildCategory.id_pro_sub_cat_child}">${subChildCategory.name} | ${subChildCategory.name_urdu}</option>`;
                        });
                        $('#productChildCate').html(options);
                        $('#productChildCatShow').show();
                    } else {
                        $('#productChildCatShow').hide();
                    }
                },
                error: function() {
                    alert('Error checking Product Child Category!');
                }
            });
        }

        $(document).ready(function() {
            // $("#goods_date").datepicker({
            //     dateFormat: "yy-mm-dd"
            // });
            var today = new Date();
            var formattedDate = today.getFullYear() + '-' + ('0' + (today.getMonth() + 1)).slice(-2) + '-' + ('0' +
                today.getDate()).slice(-2);

            $("#goods_date").val(formattedDate);

            // Initialize datepicker with custom format
            $("#goods_date").datepicker({
                dateFormat: "yy-mm-dd" // Customize the date format here
            });

            $('#suppliers').select2({
                theme: 'default'
            });

            $('#productMainCate').select2({
                // theme: 'default',
                placeholder: "Select Main Category",
                allowClear: true
            });

            $('#productParentCate').select2({
                // theme: 'default',
                placeholder: "Select Panret Category",
                allowClear: true
            });

            $('#productChildCate').select2({
                // theme: 'default',
                placeholder: "Select Child Category",
                allowClear: true
            });
        });

        function initAutoNumeric() {
            document.querySelectorAll('.n-amount').forEach(function(el) {
                if (!AutoNumeric.getAutoNumericElement(el)) { // prevent duplicate init
                    new AutoNumeric(el, {
                        digitGroupSeparator: ',',
                        decimalCharacter: '.',
                        unformatOnSubmit: true
                    });
                }
            });
        }
        document.addEventListener("DOMContentLoaded", function() {
            let itemIndex = 1;

            // Function to calculate and update total bori and weight
            function calculateTotals() {
                let totalBori = 0;
                let totalWeight = 0;

                document.querySelectorAll('input[name="bori[]"]').forEach(function(boriInput) {
                    let val = boriInput.value.replace(/,/g, ""); // remove commas
                    totalBori += parseFloat(val) || 0;
                });


                document.querySelectorAll('input[name="weight[]"]').forEach(function(weightInput) {
                    let val = weightInput.value.replace(/,/g, ""); // remove commas
                    totalWeight += parseFloat(val) || 0;
                });
                let formattedBori = AutoNumeric.format(Number(totalBori), {
                    digitGroupSeparator: ',',
                    decimalCharacter: '.'
                });
                let formattedWeight = AutoNumeric.format(Number(totalWeight), {
                    digitGroupSeparator: ',',
                    decimalCharacter: '.'
                });

                document.getElementById('total-bori').innerText = formattedBori;
                document.getElementById('total-weight').innerText = formattedWeight;
            }

            // Event listener to recalculate totals when bori or weight fields are changed
            document.getElementById('items-wrapper').addEventListener('input', function(event) {
                if (event.target.name === 'bori[]' || event.target.name === 'weight[]') {
                    calculateTotals();
                }
            });
        });

        let itemIndex = 1;
        document.getElementById('add-more').addEventListener('click', function() {
            // Generate the new row HTML
            let newRow = `
                <div class="row delete_row row-sm mg-b-20 shadow p-3 bg-light rounded mt-5" id="item-row-${itemIndex}">
                    <div class="col-md-2">
                        <div class="form-group">
                            <label class="az-content-label" for="productMainCate">Main Category</label>
                            <select name="productMainCate[]" class="form-control item-select productMainCateSelect" onchange="checkForParentCateRow(this.value, ${itemIndex})"
                                data-row-id="${itemIndex}">
                                <option value="">Select Main Category</option>
                                @foreach ($productCateMain as $key => $main)
                                    <option value="{{ $main->id_pro_cate_main }}">
                                        {{ $main->products_category_name }} |
                                        {{ $main->products_category_name_urdu }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2" id="productParentCatShow-${itemIndex}" style="display: none;">
                        <div class="form-group">
                            <label class="az-content-label" for="productParentCate">Parent Category</label>
                            <select name="productParentCate[]" class="form-control item-select productParentCateSelect" onchange="checkForChildCateRow(this.value, ${itemIndex})"
                                data-row-id="${itemIndex}">
                                <option value="">Select Parent Category</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2" id="productChildCatShow-${itemIndex}" style="display: none;">
                        <div class="form-group">
                            <label class="az-content-label" for="productChildCate">Child Category</label>
                            <select name="productChildCate[]" class="form-control item-select">
                                <option value="">Select Child Category</option>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-2">
                        <div class="form-group">
                            <label class="az-content-label">Marka (مارکہ)</label>
                            <input type="text" name="marka[]" class="form-control" />
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label class="az-content-label">Bori (بوری)</label>
                            <input type="text" name="bori[]" required class="form-control n-amount" />
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label class="az-content-label">Weight (وزن)</label>
                            <input type="text" name="weight[]" class="form-control weight-input n-amount" oninput="calculateAmount(this)" />
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label class="az-content-label">Remarks (ریمارکس)</label>
                            <textarea class="form-control" name="remarks[]" cols="30" rows="2"></textarea>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <i class="fa fa-trash-alt text-light remove-item bg-danger p-2 rounded-1" style="cursor: pointer; float: right; margin-top: 10px;"></i>
                    </div>
                </div>
            `;

            // Append the new row
            document.getElementById('items-wrapper').insertAdjacentHTML('beforeend', newRow);

            // Re-initialize select2 for the new item-select
            $(`#item-row-${itemIndex} .item-select`).select2({
                placeholder: "Select Products",
                allowClear: true
            });

            initAutoNumeric();

            // Add event listener for remove icon
            document.querySelector(`#item-row-${itemIndex} .remove-item`).addEventListener('click', function() {
                if (document.querySelectorAll('#items-wrapper .row').length > 1) {
                    this.closest('.row').remove();
                    calculateTotals();
                } else {
                    alert("You cannot delete the last remaining item.");
                }
            });


            // Increment the item index for the next row
            itemIndex++;
        });

        function checkForParentCateRow(productMainCateId, rowId) {
            $.ajax({
                url: 'check-cate-parent',
                type: 'GET',
                data: {
                    productMainCateId: productMainCateId
                },
                success: function(response) {
                    if (Array.isArray(response.productParentCate) && response.productParentCate.length >
                        0) {
                        let options = '<option value="">Select Item</option>';
                        response.productParentCate.forEach(function(subParentCategory) {
                            options +=
                                `<option value="${subParentCategory.id_pro_sub_cat_parent}">${subParentCategory.name} | ${subParentCategory.name_urdu}</option>`;
                        });
                        $(`#productParentCatShow-${rowId} select`).html(options);
                        $(`#productParentCatShow-${rowId}`).show();
                    } else {
                        $(`#productParentCatShow-${rowId}`).hide();
                        $(`#productChildCatShow-${rowId}`).hide();
                    }
                },
                error: function() {
                    alert('Error checking Product Parent Category!');
                }
            });
        }

        function checkForChildCateRow(productParentCateId, rowId) {
            $.ajax({
                url: 'check-cate-child',
                type: 'GET',
                data: {
                    productParentCateId: productParentCateId
                },
                success: function(response) {
                    if (Array.isArray(response.productChildCate) && response.productChildCate.length >
                        0) {
                        let options = '<option value="">Select Item</option>';
                        response.productChildCate.forEach(function(subChildCategory) {
                            options +=
                                `<option value="${subChildCategory.id_pro_sub_cat_child}">${subChildCategory.name} | ${subChildCategory.name_urdu}</option>`;
                        });
                        $(`#productChildCatShow-${rowId} select`).html(options);
                        $(`#productChildCatShow-${rowId}`).show();
                    } else {
                        $(`#productChildCatShow-${rowId}`).hide();
                    }
                },
                error: function() {
                    alert('Error checking Product Child Category!');
                }
            });
        }

        document.addEventListener('keydown', function(event) {
            const activeElement = document.activeElement;

            // Check for Tab key press
            if (event.key === "Tab") {
                const allRemarksInputs = document.querySelectorAll('textarea[name="remarks[]"]');
                const lastRemarksInput = allRemarksInputs[allRemarksInputs.length - 1];

                // If activeElement is the last remarks input, add a new row
                if (activeElement === lastRemarksInput) {
                    event.preventDefault(); // Prevent default tab behavior

                    // Trigger the click event of the 'Add More' button
                    document.getElementById('add-more').click();

                    // Focus on the newly added row's first input field (e.g., items select)
                    setTimeout(function() {
                        const newItemsInput = document.querySelectorAll('select[name="productCat[]"]');
                        newItemsInput[newItemsInput.length - 1].focus(); // Focus on the last added input
                    }, 0);
                }
            }

            // Detect Alt + D to delete the selected row
            if (event.altKey && event.key === 'd') {
                event.preventDefault();

                const focusedElement = document.activeElement;
                const focusedRow = focusedElement.closest('.delete_row'); // Find the closest row (div.row)

                // If a row is focused, remove it
                if (focusedRow) {
                    focusedRow.remove(); // Remove the focused row

                    // You can add additional functionality like recalculating totals here
                    // Example: updateTotals();
                } else {
                    showErrorNotification(
                        'Please select the row you want to delete.\nبراہ کرم اس صف کو منتخب کریں جسے آپ حذف کرنا چاہتے ہیں۔'
                    );
                }
            }
        });

        // Function to show error notification
        function showErrorNotification(message) {
            const notification = document.getElementById('errorNotification');
            const errorMessage = document.getElementById('errorMessage');

            errorMessage.innerText = message;
            notification.style.display = 'block';

            setTimeout(() => {
                notification.style.display = 'none';
            }, 5000); // Hide after 5 seconds
        }

        // Optional: Define updateBoriDetails if necessary
        function updateBoriDetails() {
            // Your logic to update details after deleting a row
        }

        // Custom Keys Work
        document.addEventListener('DOMContentLoaded', function() {
            // Prevent form submission on Enter key
            document.getElementById('goodReceiptsForm').addEventListener('keydown', function(e) {
                if (e.key === 'Enter') {
                    e.preventDefault();
                }
            });

            // Submit form when Ctrl + S is pressed
            document.addEventListener('keydown', function(e) {
                if (e.ctrlKey && e.key === 's') {
                    e.preventDefault(); // Prevent the default save dialog in the browser
                    document.getElementById('goodReceiptsForm').submit(); // Submit the form
                }
            });
        });
    </script>
@endpush
