@extends('layouts.master')

@section('content')
    <div class="az-content-breadcrumb">
        <span>Sales</span>
    </div>
    <h2 class="az-content-title" style="display: inline">
        Sales List
        <span>
            @can('Sales add')
                <a id="addbtn" href="{{ route('sales.create') }}" class="btn btn-az-primary" style="float: right">
                    <i class="fa-solid fa-plus"></i> Create Sale </a>
            @endcan
        </span>
    </h2>

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-20">
                <div>
                    <table id="example2" class="table table-striped">
                        <thead>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-10p">Date</th>
                                <th class="wd-10p">Vehicle No</th>
                                <th class="wd-10p">Customer</th>
                                <th class="wd-10p">Balance</th>
                                <th class="wd-10p">Price</th>
                                <th class="wd-10p">Cash Received</th>
                                <th class="wd-10p">Total</th>
                                <th class="none">Item Details</th>
                                <th class="none">Marks</th>
                                <th class="none">Remarks</th>

                                <th class="none">Created By</th>
                                <th class="wd-20p">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($sales as $key => $sale)
                                <tr>
                                    <td>{{ $key + 1 }}</td>
                                    <td>{{ $sale->date }}</td>
                                    <td>{{ $sale->goodReceiptTruck->truck_no ?? 'N/A' }}</td>
                                    <td>{{ $sale->customer?->customer_name }}</td>
                                    <td>{{ number_format($sale->balance) }}</td>
                                    <td>{{ number_format($sale->total_amount) }}</td>
                                    <td>{{ $sale->paid ? number_format($sale->paid) : 0 }}</td>
                                    <td>{{ number_format($sale->salesItemsDetails->sum('amount')) }}</td>
                                    <td>
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>Main Category Name</th>
                                                    <th>Parent Category Name</th>
                                                    <th>Child Category Name</th>
                                                    <th>Marka</th>
                                                    <th>Bori</th>
                                                    <th>Weight</th>
                                                    <th>Rate</th>
                                                    <th>Amount</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($sale->salesItemsDetails as $item)
                                                    <tr>
                                                        <td>{{ $item->productMainCate->products_category_name ?? 'N/A' }}
                                                        </td>
                                                        <td>{{ $item->productParentCate->name ?? 'N/A' }}</td>
                                                        <td>{{ $item->productChildCate->name ?? 'N/A' }}</td>

                                                        <td>{{ $item->marka }}</td>
                                                        <td>{{ number_format((int)$item->bori) }}</td>
                                                        <td>{{ number_format((int)$item->weight) }}</td>
                                                        <td>{{ number_format((int)$item->rate) }}</td>
                                                        <td>{{ number_format((int)$item->amount) }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </td>
                                    <td>{{ $sale->details }}</td>

                                    <td>{{ $sale->bori_details }}</td>
                                    <td>{{ $sale->createdBy?->name }}</td>
                                    <td>
                                        @can('Sales edit')
                                            <a class="btn rounded shadow-base" title="Edit Sales"
                                                href="{{ route('sales.edit', Crypt::encrypt($sale->id_sales)) }}">
                                                <i class="text-primary fa-regular fa-pen-to-square"></i>
                                                <span class="text-primary">Edit</span>
                                            </a>
                                        @endcan
                                        @can('Sales delete')
                                            <a class="btn rounded shadow-base" title="Delete Sales" data-toggle="modal"
                                                data-target="#deleteModal" data-id="{{ Crypt::encrypt($sale->id_sales) }}">
                                                <i class="text-danger fa-solid fa-trash-can"></i>
                                                <span class="text-danger">Remove</span>
                                            </a>
                                        @endcan
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-10p">Date</th>
                                <th class="wd-10p">Vehicle No</th>
                                <th class="wd-10p">Customer</th>
                                <th class="wd-10p">Balance</th>
                                <th class="wd-10p">Price</th>
                                <th class="wd-10p">Cash Received</th>
                                <th class="wd-10p">Total</th>
                                <th class="none">Item Details</th>
                                <th class="none">Marks</th>
                                <th class="none">Remarks</th>

                                <th class="none">Created By</th>
                                <th class="wd-20p">Action</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this sale? Deleting it will reverse the stock back to the goods receipt.
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" action="" method="POST">
                        @csrf
                        @method('GET')
                        <button type="button" class="btn btn-secondary text-light" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script type="text/javascript">
        document.addEventListener('keydown', function(event) {
            if ((event.ctrlKey || event.metaKey) && event.key === 'a') {
                event.preventDefault(); // Prevent default CTRL + A behavior (Select All)

                // Trigger the click on the "Add Customers" button
                document.getElementById('addbtn').click();
            }
        });
        $(function() {
            oTable = $('#example2').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'csv',
                        text: 'CSV',
                        title: 'Goods Receipts List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'excel',
                        text: 'Excel',
                        title: 'Goods Receipts List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'pdf',
                        text: 'PDF',
                        title: 'Goods Receipts List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'print',
                        text: 'Print',
                        title: 'Goods Receipts List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    }
                ],
                responsive: !0
            });
        });

        $(document).ready(function() {
            $('#deleteModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget);
                var id = button.data('id');
                var actionUrl = '{{ url('sales/destroy') }}/' + id;
                var modal = $(this);
                modal.find('#deleteForm').attr('action', actionUrl);
            });
        });
    </script>
@endpush
