@extends('layouts.master')

@section('content')
    <div class="az-content-breadcrumb">
        <span>Stock</span>
        <span>Record Damage</span>
    </div>
    <h2 class="az-content-title" style="display: inline">Record Product Damage
        <span>
            <a href="{{ route('products.stock.list', ['brand_id' => Crypt::encrypt($product->brands_id), 'product_id' => Crypt::encrypt($product->id_products)]) }}"
                class="btn border" style="float: right">
                <i class="fa-solid fa-bars-staggered"></i> Back to Stock
            </a>
        </span>
    </h2>
    <div class="separator-breadcrumb border-top"></div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Damage Details</h5>

                    @if (Session::has('alert'))
                        <div class="alert alert-card alert-{{ Session::get('alert-class') }}" role="alert">
                            {{ Session::get('alert') }}
                            <button class="close" type="button" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif

                    <form
                        action="{{ route('products.stocks.addDamage', ['id_stock' => Crypt::encrypt($stock->id_stock), 'product_id' => Crypt::encrypt($product->id_products)]) }}"
                        method="POST">
                        @csrf
                        @method('PUT')

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Product Name</label>
                                    <input type="text" class="form-control" value="{{ $product->products_name }}"
                                        disabled>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Batch Number</label>
                                    <input type="text" class="form-control" value="{{ $stock->stock_batch_number }}"
                                        disabled>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Store Name</label>
                                    <input type="text" class="form-control"
                                        value="{{ optional($stock->store)->store_name }}" disabled>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Batch Date</label>
                                    <input type="date" class="form-control" value="{{ $stock->stock_purchase_date }}"
                                        disabled>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Expiry Date</label>
                                    <input type="date" class="form-control" value="{{ $stock->stock_expiry_date }}"
                                        disabled>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Damage Quantity</label>
                                    <input type="number" class="form-control" name="stock_damage_qty" required>
                                    @error('stock_damage_qty')
                                        <span class="form-text text-danger">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Damage Date</label>
                                    <input type="date" class="form-control" name="stock_damage_date" required>
                                    @error('stock_damage_date')
                                        <span class="form-text text-danger">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Remarks</label>
                                <textarea class="form-control" name="stock_remarks" rows="3" required></textarea>
                                @error('stock_remarks')
                                    <span class="form-text text-danger">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <button type="submit" class="btn btn-az-primary btn-block mt-2 float-end"><i
                                class="fa-regular fa-floppy-disk"></i> <strong>Save</strong></button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
