<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmployeePayroll extends Model
{
    use HasFactory;
        protected $fillable = [
        'employee_id',
        'year',
        'month',
        'gross_salary',
        'deductions',
        'net_salary',
        'paid_at',
        'status',
    ];

    /**
     * The attributes that should be cast.
     */
    protected $casts = [
        'gross_salary' => 'decimal:2',
        'deductions' => 'decimal:2',
        'net_salary' => 'decimal:2',
        'paid_at' => 'datetime',
    ];


    public function employee()
    {
        return $this->belongsTo(Employees::class);
    }


    public function scopeForMonthYear($query, $month, $year)
    {
        return $query->where('month', $month)->where('year', $year);
    }


    public function isPaid()
    {
        return $this->status === 'paid';
    }
}
