<?php

namespace App;

use App\Suppliers;
//use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PurchaseOrder extends Model
{
//    use HasFactory;

    // Define the table associated with the model
    protected $table = 'purchase_order';

    // Define the primary key
    protected $primaryKey = 'id_purchase_order';

    // Define the fillable attributes
    protected $fillable = [
        'business_id',
        'supplier_id',
        'date',
        'po_no',
        'details',
        'rent_recieve',
        'labour',
    ];

    /**
     * Relationship: A Purchase Order belongs to a Supplier
     */
    public function supplier()
    {
        return $this->belongsTo(Suppliers::class, 'supplier_id', 'id_supplier');
    }

    /**
     * Relationship: A Purchase Order has many Purchase Order Details
     */
    public function Purchasedetails()
    {
        return $this->hasMany(PurchaseOrderDetails::class, 'purchase_order_id', 'id_purchase_order');
    }
}
