@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Employees list</span>
        <span>Edit Employee</span>
    </div>
    <h2 class="az-content-title" style="display: inline">
        Edit Employee
        <span>
            <a href="{{ url('employee') }}" class="btn border" style="float: right">
                <i class="fa-solid fa-bars-staggered"></i> Back to Employees
            </a>
        </span>
    </h2>

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <h5 class="card-title mg-b-20">Edit Employee Details</h5>
                <form id="myForm" method="POST" action="{{ url('employee/update/' . \Crypt::encrypt($edit->id)) }}">
                    @csrf

                    @if ($errors->any())
                        <div class="p-1">
                            @foreach ($errors->all() as $error)
                                <div class="alert alert-warning alert-danger fade show" role="alert">{{ $error }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    <div class="row row-sm mg-b-20">
                        <div class="col-md-4">
                            <label>First Name</label>
                            <input type="text" name="first_name" class="form-control" value="{{ $edit->first_name }}"
                                required>
                        </div>
                        <div class="col-md-4">
                            <label>Last Name</label>
                            <input type="text" name="last_name" class="form-control" value="{{ $edit->last_name }}">
                        </div>
                        <div class="col-md-4">
                            <label>Email</label>
                            <input type="email" name="email" class="form-control" value="{{ $edit->email }}">
                        </div>
                    </div>



                    <div class="row row-sm mg-b-20">
                        <div class="col-md-6">
                            <label>Phone</label>
                            <input type="text" name="phone" class="form-control" value="{{ $edit->phone }}">
                        </div>
                        <div class="col-md-6">
                            <label>DOB</label>
                            <input type="date" name="dob" class="form-control"
                                value="{{ $edit->dob?->format('Y-m-d') }}">
                        </div>
                    </div>

                    <div class="row row-sm mg-b-20">
                        <div class="col-md-6">
                            <label>Gender</label>
                            <select name="gender" class="form-control">
                                <option value="">Select Gender</option>
                                <option value="male" {{ $edit->gender == 'male' ? 'selected' : '' }}>Male</option>
                                <option value="female" {{ $edit->gender == 'female' ? 'selected' : '' }}>Female</option>
                                <option value="other" {{ $edit->gender == 'other' ? 'selected' : '' }}>Other</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label>Joining Date</label>
                            <input type="date" name="joining_date" class="form-control"
                                value="{{ $edit->joining_date?->format('Y-m-d') }}">
                        </div>
                    </div>

                    <div class="row row-sm mg-b-20">

                        <div class="col-md-6">
                            <label>Designation</label>
                            <select name="designation_id" class="form-control">
                                <option value="">Select Designation</option>
                                @foreach ($designations as $designation)
                                    <option value="{{ $designation->id }}"
                                        {{ $edit->designation_id == $designation->id ? 'selected' : '' }}>
                                        {{ $designation->title }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="row row-sm mg-b-20">
                        <div class="col-md-6">
                            <label>Basic Salary</label>
                            <input type="number" name="basic_salary" class="form-control" step="0.01"
                                value="{{ $edit->basic_salary }}">
                        </div>
                        <div class="col-md-6">
                            <label>Status</label>
                            <select name="status" class="form-control">
                                <option value="active" {{ $edit->status == 'active' ? 'selected' : '' }}>Active</option>
                                <option value="inactive" {{ $edit->status == 'inactive' ? 'selected' : '' }}>Inactive
                                </option>
                                <option value="terminated" {{ $edit->status == 'terminated' ? 'selected' : '' }}>Terminated
                                </option>
                            </select>
                        </div>
                    </div>

                    <a href="{{ url('/employee') }}" class="btn btn-danger btn-block mt-2">Cancel</a>
                    <button type="submit" class="btn btn-az-primary btn-block mt-2" style="float: right">Update</button>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        document.addEventListener('keydown', function(event) {
            if ((event.ctrlKey || event.metaKey) && event.key === 's') {
                event.preventDefault();
                document.getElementById('myForm').submit();
            }
            if (event.key === 'Enter') {
                event.preventDefault();
            }
        });
    </script>
@endpush
