@extends('layouts.master')

@section('content')
    <div class="az-content-breadcrumb">
        <span>Brands</span>
    </div>
    <h2 class="az-content-title" style="display: inline">
        Brands List
        <span>
            @can('Brands add')
                <a href="{{ route('brands.create') }}" class="btn btn-az-primary" style="float: right">
                    <i class="fa-solid fa-plus"></i>
                    Add New Brand
                </a>
            </span>
        @endcan
    </h2>
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-20">

                <div>
                    <table id="example2" class="table table-responsive">
                        <thead>
                            <tr>
                                <th class="wd-5-f">S.No</th>
                                <th class="wd-5-f">Logo</th>
                                <th class="wd-20p">Name</th>
                                <th class="wd-10p">Abbrevation</th>
                                <th class="wd-10p">Created By</th>
                                <th class="wd-10p">Created At</th>
                                <th class="wd-10p">Status</th>
                                <th class="wd-30p">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($brands as $key => $brand)
                                <?php
                                if (!empty($brand->brands_logo)) {
                                    $image = url('/uploads/brand_images/' . $brand->brands_logo);
                                } else {
                                    $image = url('/img/default_user.png');
                                }
                                ?>
                                <tr>

                                    <td>{{ $key + 1 }}</td>
                                    <td>
                                        <img src="<?= $image ?>" style="height:40px;width:40px;border-radius: 50%"
                                            alt="" srcset="">
                                    </td>
                                    <td>{{ $brand->brands_name }}</td>
                                    <td>{{ $brand->brands_abbrevation }}</td>
                                    <td>{{ $brand->created_by }}</td>
                                    <td><?= date('d-m-Y', strtotime($brand->created_at)) ?></td>
                                    <td>
                                        @if ($brand->brands_status == 1)
                                            <button class="btn btn-rounded btn-success" style="color:#fff;">
                                                <strong>Active</strong> <span class="badge badge-primary"></span>
                                            </button>
                                        @else
                                            <button class="btn btn-rounded btn-danger" style="color:#fff;">
                                                <i class="fa-solid fa-ban"></i> <strong>Deactivated</strong> <span
                                                    class="badge badge-primary"></span>
                                            </button>
                                        @endif
                                    </td>
                                    <td>
                                        @can('Products list')
                                            <a class="btn rounded shadow-base" title="Products"
                                                href="{{ route('products.list', Crypt::encrypt($brand->id_brands)) }}">
                                                <i class="text-info fa-solid fa-arrow-up-right-from-square"></i> <span
                                                    class="text-info">Products</span>
                                            </a>
                                        @endcan
                                        @can('Brands edit')
                                            <a class="btn rounded shadow-base" title="Edit Product"
                                                href="{{ route('brand.edit', Crypt::encrypt($brand->id_brands)) }}">
                                                <i class="text-primary fa-regular fa-pen-to-square"></i> <span
                                                    class="text-primary">Edit</span>
                                            </a>
                                        @endcan
                                        @can('Brands delete')
                                            <a class="btn rounded shadow-base" data-toggle="modal" data-target="#deleteModal"
                                                data-id="{{ $brand->id_brands }}">
                                                <i class="text-danger fa-solid fa-trash-can"></i> <span
                                                    class="text-danger">Remove</span>
                                            </a>
                                        @endcan
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th class="wd-5-f">S.No</th>
                                <th class="wd-5-f">Logo</th>
                                <th class="wd-20p">Name</th>
                                <th class="wd-10p">Abbrevation</th>
                                <th class="wd-10p">Created By</th>
                                <th class="wd-10p">Created At</th>
                                <th class="wd-10p">Status</th>
                                <th class="wd-30p">Action</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
            <!-- card -->
        </div>
        <!-- col -->
    </div>


    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this Measurement Unit?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" action="" method="POST">
                        @csrf
                        <button type="button" class="btn btn-secondary text-light" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script type="text/javascript">
        $(function() {
            oTable = $('#example2').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'csv',
                        text: 'CSV',
                        title: 'Brands List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'excel',
                        text: 'Excel',
                        title: 'Brands List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'pdf',
                        text: 'PDF',
                        title: 'Brands List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'print',
                        text: 'Print',
                        title: 'Brands List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    }
                ],
                responsive: !0
            });
        });

        $(document).ready(function() {
            $('#deleteModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget);
                var id = button.data('id');
                var actionUrl = '{{ url('brands/destroy') }}/' + id;
                var modal = $(this);
                modal.find('#deleteForm').attr('action', actionUrl);
            });
        });
    </script>
    {{-- <script>
        $(document).ready(function() {
            $('#example2 tfoot th').each(function() {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control" placeholder="' + title + '" />');
            });
            $('#example2').DataTable({
                "ordering": true,
                "dom": 'Blfrtip',
                "buttons": [
                    'excel', 'pdf', 'print'
                ],
                responsive: !0,
                columnDefs: [{
                    className: 'control',
                    orderable: false
                }],
                initComplete: function() {
                    // Apply the search
                    this.api()
                        .columns()
                        .every(function() {
                            var that = this;
                            $('input', this.footer()).on('keyup change clear', function() {
                                if (that.search() !== this.value) {
                                    that.search(this.value).draw();
                                }
                            });
                        });
                }
            });
        });
    </script> --}}
@endpush
