@extends('layouts.master')

@section('content')
    <div class="az-content-breadcrumb">
        <span>Designations</span>
        <span>Manage Designations</span>
    </div>


 <h2 class="az-content-title" style="display: inline">
        Designations List
        <span>
            <a href="{{ route('designations.create') }}" class="btn btn-az-primary" style="float: right">
                <i class="fa-solid fa-plus"></i> Add Designation
            </a>
        </span>
    </h2>
    <div class="card">
        <div class="card-body">


            <table class="table table-bordered table-striped" id="designationTable">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Title</th>
                        <th>Department</th>
                        <th>Status</th>
                        <th>Created At</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($designations as $key => $designation)
                        <tr>
                            <td>{{ $key + 1 }}</td>
                            <td>{{ $designation->title }}</td>
                            <td>{{ $designation->department->name ?? 'N/A' }}</td>
                            <td>
                                <span class="badge bg-{{ $designation->status == 'active' ? 'success' : 'secondary' }}">
                                    {{ ucfirst($designation->status) }}
                                </span>
                            </td>
                            <td>{{ $designation->created_at->format('d M, Y') }}</td>
                            <td>
                                <a href="{{ route('designations.edit', \Crypt::encrypt($designation->id)) }}"
                                    class="btn btn-sm btn-primary">Edit</a>
                                <form action="{{ route('designations.destroy', \Crypt::encrypt($designation->id)) }}"
                                    method="POST" class="d-inline">
                                    @csrf @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger"
                                        onclick="return confirm('Are you sure you want to delete this designation?')">Delete</button>
                                </form>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    @push('scripts')
     <script>
        $(document).ready(function() {
            $('#designationTable').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'csv',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: ':not(:last-child)'
                        }
                    },
                    {
                        extend: 'excel',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: ':not(:last-child)'
                        }
                    },
                    {
                        extend: 'pdf',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: ':not(:last-child)'
                        }
                    },
                    {
                        extend: 'print',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: ':not(:last-child)'
                        }
                    }
                ],
                responsive: true
            });
        });
    </script>
    @endpush
@endsection
