@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Employees list</span>
        <span>Edit Employees</span>
        {{-- <span>Forms</span> --}}
        {{-- <span>Form Layouts</span> --}}
    </div>
    <h2 class="az-content-title" style="display: inline">Edit Employees <span><a href="{{ url('employee') }}"
                class="btn btn-az-primary" style="float: right">Employees List</a></span></h2>
    {{-- <h2 style="float: right" class="az-content-title"></h2> --}}


    {{-- <div class="az-content-body pd-lg-l-40 d-flex flex-column"> --}}
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <h5 class="card-title mg-b-20">Edit Employees Details</h5>
                <form id="myForm" method="POST"
                    action="{{ url('employee/update/' . \Crypt::encrypt($edit->id_employee)) }}">
                    @csrf
                    @if (count($errors) > 0)
                        <div class="p-1">
                            @foreach ($errors->all() as $error)
                                <div class="alert alert-warning alert-danger fade show" role="alert">{{ $error }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            @endforeach
                        </div>
                    @endif
                    <div class="row row-sm mg-b-20">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Employee Name</label>
                                <input type="text" value="{{$edit->employee_name}}" name="employee_name" class="form-control" required />
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Employee Number</label>
                                <input type="text" value="{{$edit->employee_no}}" name="employee_no" class="form-control" required />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Employee Email</label>
                                <input type="text" value="{{$edit->employee_email}}" name="employee_email" class="form-control" required />
                            </div>
                        </div>


                    </div>
                    <div class="row row-sm mg-b-20">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Employee Address</label>
                                <input type="text" value="{{$edit->employee_address}}" name="employee_address" class="form-control" required />
                            </div>
                        </div>


                    </div>

                    <a type="button" href="{{ url('/employee') }}" class="btn btn-danger btn-block mt-2">
                        Cancel
                    </a>
                    <button type="submit" class="btn btn-az-primary btn-block mt-2" style="float: right">
                        Update
                    </button>
                </form>
            </div>
            <!-- card -->
        </div>
        <!-- col -->
    </div>






    {{-- </div><!-- az-content-body --> --}}
@endsection
@push('scripts')
    <script>
        document.addEventListener('keydown', function(event) {
            if ((event.ctrlKey || event.metaKey) && event.key === 's') {
                event.preventDefault();

                document.getElementById('myForm').submit();
            }

            if (event.key === 'Enter') {
                event.preventDefault();
            }
        });
    </script>
@endpush
