<?php

namespace App;

//use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BChequeItem extends Model
{
//    use HasFactory;

    protected $table = 'b_cheque_items';
    protected $primaryKey = 'id_b_cheque_items';

    protected $fillable = [
        'b_cheque_id',
        'sales_d_id',
        'main_cate',
        'parent_cate',
        'child_cate',
        'marka',
        'item',
        'bori',
        'weight',
        'rate',
        'amount',
        'created_by'
    ];

    public function bCheque()
    {
        return $this->belongsTo(BCheque::class, 'b_cheque_id', 'id_b_cheque');
    }

      public function productMainCate()
    {
        return $this->belongsTo(ProductsCategoryMain::class, 'main_cate', 'id_pro_cate_main');
    }

    public function productParentCate()
    {
        return $this->belongsTo(ProductsSubCategoryParent::class, 'parent_cate', 'id_pro_sub_cat_parent');
    }

    public function productChildCate()
    {
        return $this->belongsTo(ProductsSubCategoryChild::class, 'child_cate', 'id_pro_sub_cat_child');
    }
}
