@extends('layouts.master')

@section('content')
    <div class="az-content-breadcrumb">
        <span>Payment Voucher</span>
    </div>
    <h2 class="az-content-title" style="display: inline">Payment Vouchers List<span>
            <a id="addbtn" href="{{ route('payment_voucher.create') }}" class="btn btn-az-primary" style="float: right">
                <i class="fa-solid fa-plus"></i> Add Payment Voucher
            </a>
        </span></h2>

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-20">
                <div>
                    <table id="paymentVoucherTable" class="display nowrap" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>RV #</th>
                                <th>Date</th>
                                <th>Customers</th>
                                <th>Net Amount</th>
                                <th>Payment Mode</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tfoot>
                            <tr>
                                <th>RV #</th>
                                <th>Date</th>
                                <th>Customers</th>
                                <th>Net Amount</th>
                                <th>Payment Mode</th>
                                <th>Action</th>
                            </tr>
                        </tfoot>
                        <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this voucher?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" action="" method="POST">
                        @csrf
                        @method('DELETE')
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        document.addEventListener('keydown', function(event) {
            if ((event.ctrlKey || event.metaKey) && event.key.toLowerCase() === 'a') {
                event.preventDefault();
                document.getElementById('addbtn').click();
            }
        });

        $(document).ready(function() {
            var table = $('#paymentVoucherTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('paymentvoucherlisting') }}",
                    data: function(d) {
                        d._token = '{{ csrf_token() }}';
                    }
                },
                columns: [{
                        data: 'voucher_number',
                        name: 'voucher_number'
                    },
                    {
                        data: 'voucher_date',
                        name: 'voucher_date',
                        render: function(data) {
                            return moment(data).format('D MMMM YYYY');
                        }
                    },
                    {
                        data: 'suppliers',
                        name: 'suppliers'
                    },
                    {
                        data: 'net_amount',
                        name: 'net_amount',
                    },
                    {
                        data: 'payment_mode',
                        name: 'payment_mode',
                        render: function(data) {
                            return data.charAt(0).toUpperCase() + data.slice(1);
                        }
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false,
                        className: 'text-center'
                    }
                ],
                dom: 'Bfrtip',
                buttons: [
                    'copy', 'csv', 'excel', 'pdf', 'print'
                ],
                order: [
                    [1, 'desc']
                ],
                initComplete: function() {
                    
                    // For payment mode dropdown
                    this.api().columns(4).every(function() {
                        var column = this;
                        var select = $(
                                '<select class="form-control form-control-sm"><option value="">All</option><option value="cash">Cash</option><option value="bank">Bank</option></select>'
                            )
                            .appendTo($(column.footer()).empty())
                            .on('change', function() {
                                column.search($(this).val()).draw();
                            });
                    });

                   
                }
            });

            // Delete button handler
            $('#paymentVoucherTable').on('click', '.delete-btn', function() {
                var url = $(this).data('url');
                $('#deleteForm').attr('action', url);
                $('#deleteModal').modal('show');
            });
            document.querySelectorAll('[data-bs-dismiss="modal"]').forEach(button => {
                button.addEventListener('click', function() {
                    var modal = bootstrap.Modal.getInstance(document.getElementById('deleteModal'));
                    modal.hide();
                });
            });
        });
    </script>
@endpush
