<!DOCTYPE html>
<html lang="ur" dir="rtl">
<head>
    <title>Sales Invoice - Print</title>
    <style>
        body { font-family: Arial, sans-serif; font-size: 12px; }
        .container { width: 95%; margin: auto; }
        h2 { text-align: center; margin-bottom: 5px; }

        .sections-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 20px;
            flex-wrap: wrap;
        }

        .section {
            padding: 10px;
            margin-top: 12px;
            border-bottom: 2px dashed black;
            width: 48%;
            box-sizing: border-box;
            margin-bottom: 10px;
        }

        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th, td { padding: 6px; text-align: right; }

        .no-print { margin-top: 20px; display: block; padding: 10px 20px; background: #007bff; color: white; border: none; cursor: pointer; }

        @media print {
            .no-print { display: none; }
            .section { width: 48%; page-break-inside: avoid; }
            .page-break { page-break-after: always; clear: both; }
        }
    </style>
</head>

<body>
    <div class="container">
        @php $globalIndex = 0; @endphp

        @foreach ($sales as $customerName => $customerBills)

            {{-- Naya row shuru karein har 2 customers ke baad --}}
            @if ($globalIndex % 2 == 0)
                <div class="sections-row">
            @endif

            <div class="section">
                <h2>{{ $customerName }}</h2>

                {{-- Date range dikhane ke liye (Optional) --}}
                <p style="text-align: right; font-size: 10px;">Report Date: {{ now()->format('d/m/y') }}</p>

                <table>
                    <thead>
                        <tr>
                            <th>مال</th>
                            <th>قیمت</th>
                            <th>وزن</th>
                            <th>بوری</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $totalCustomerAmount = 0;
                            $totalCustomerBori = 0;
                            $totalCustomerWeight = 0;
                            // Sabeqa balance aakhri sale se uthayenge
                            $lastSale = $customerBills->last();
                            $sabeqaBalance = (float) str_replace(',', '', $lastSale->customerBalance());
                        @endphp

                        @foreach ($customerBills as $sale)
                            @php
                                $totalCustomerAmount += (float) str_replace(',', '', $sale->total_amount);
                            @endphp

                            @foreach ($sale->salesItemsDetails as $item)
                                @php
                                    $totalCustomerBori += $item->bori;
                                    $totalCustomerWeight += $item->weight;
                                @endphp
                                <tr>
                                    <td>{{ $item->productChildCate?->name_urdu }}</td>
                                    <td>{{ number_format((int) $item->amount, 0) }}</td>
                                    <td>{{ $item->weight }}</td>
                                    <td>{{ $item->bori }}</td>
                                </tr>
                            @endforeach
                        @endforeach

                        <tr style="border-top: 1px solid #000;">
                            <th>{{ number_format($totalCustomerAmount, 0) }}</th>
                            <th>{{ $totalCustomerWeight }}</th>
                            <th>{{ $totalCustomerBori }}</th>
                            <th>ٹوٹل</th>
                        </tr>

                        <tr>
                            <th style="padding-top: 15px;">{{ number_format($totalCustomerAmount, 0) }}</th>
                            <th colspan="3" style="padding-top: 15px;">بنام (موجودہ بل)</th>
                        </tr>
                        <tr>
                            <th>{{ number_format($sabeqaBalance, 0) }}</th>
                            <th colspan="3">سابِقہ بیلنس</th>
                        </tr>
                        <tr style="border-top: 1px double #000;">
                            <th>{{ number_format($totalCustomerAmount + $sabeqaBalance, 0) }}</th>
                            <th colspan="3">حالیہ بیلنس (ٹوٹل)</th>
                        </tr>
                    </tbody>
                </table>
            </div>

            @php $globalIndex++; @endphp

            @if ($globalIndex % 2 == 0 || $loop->last)
                </div>
            @endif

            @if ($globalIndex % 6 == 0 && !$loop->last)
                <div class="page-break"></div>
            @endif

        @endforeach

        <button class="no-print" onclick="window.print()">Print Report</button>
    </div>
</body>
</html>
