<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class GoodReceipts extends Model
{
    protected $primaryKey = 'id_good_rec';
    protected $table = 'good_receipts';
    protected $fillable = [
        'business_id',
        'supplier_id',
        'good_receipts_truck_id',
        'date',
        'p_no',
        'builty_no',
        'rent_recieve',
        'details',
        'goods_entities_json',
        'status',
        'created_by',
    ];

    public function supplier()
    {
        // return $this->belongsTo(Suppliers::class, 'supplier_id');
        return $this->belongsTo(Suppliers::class, 'supplier_id', 'id_supplier');
    }

    public function goodReceiptTruck()
    {
        return $this->belongsTo(GoodReceiptTruck::class, 'good_receipts_truck_id');
    }

    public function goodReceiptDetails()
    {
        return $this->hasMany(GoodReceiptDetail::class, 'good_receipts_id');
    }

      public function createdBy()
    {
        return $this->belongsTo(User::class,  'created_by');
    }

}
