<?php

namespace App\Http\Controllers;

use App\AssignDepartmentUser;
use App\Departments;
use App\Countries;
// use App\department_service;
use App\DepartmentTeam;
// use App\department_sub_service;
use App\DepartmentService;
use App\DepartmentSubService;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\OtherService;
use App\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Session;
use Yajra\DataTables\Facades\DataTables;

class DepartmentsController extends Controller
{
    protected string $module = 'Departments';

    public function __construct()
    {
        $module = $this->module;

        $this->middleware("permission:$module list")->only(['index']);
        $this->middleware("permission:$module view")->only(['show']);
        $this->middleware("permission:$module add")->only(['create', 'store']);
        $this->middleware("permission:$module edit")->only(['edit', 'update']);
        $this->middleware("permission:$module delete")->only(['destroy']);
    }
    /**
     * Display a listing of the resource.
     */

    public function createModulePermissions($moduleId, $moduleName)
    {
        // Normalize module name
        // dd('sd');
        $moduleSlug = strtolower(str_replace(' ', '-', $moduleName));

        // Permission types
        // $actions = ['list', 'add', 'edit', 'delete'];
        $actions = ['list'];

        foreach ($actions as $action) {

            $permissionSlug = $moduleSlug . ' ' . $action;

            DB::table('permissions')->updateOrInsert(
                [
                    'name'       => str_replace(' ', ' ', $permissionSlug),
                    'parent_id'  => $moduleId,    // 👈 Parent ID = main module row ID
                    // 'guard'      => 'web',
                    'created_at' => now(),
                    'updated_at' => now(),
                ]
            );
        }

        return "Permissions created successfully for module: $moduleName (Parent ID: $moduleId)";
    }
    public function index()
    {

        // $this->createModulePermissions(268, 'Attendance');
        try {
            $departments = Departments::orderBy('created_at', 'desc')->get();
            return view('departments.index', compact('departments'));
        } catch (\Exception $e) {
            Log::error('Department Index Error: ' . $e->getMessage());
            return redirect()->back()->with('error', 'Failed to load departments.');
        }
        // if (isset(request()->q)) {
        //     $departments = Departments::where('id_departments', request()->q)->get();
        // } else {
        //     $departments = Departments::all();
        // }
        // $users = User::all();
        // // $dep_users=assign_department_user::where();
        // // dd()
        // $services = OtherService::where('status', 'Active')
        //     ->where('parent_id', null)
        //     ->get();
        // $department_teams = DepartmentTeam::all();
        // return view('departments.index', compact('departments', 'department_teams', 'users', 'services'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        // $countries = countries::all();
        // $services = OtherService::where('status', 'Active')
        //     ->where('parent_id', null)
        //     ->get();
        // return view('departments.create', compact('countries', 'services'));

        return view('departments.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        // $request->validate([
        //     'department_name' => 'required',
        //     // 'services' => 'required',
        //     // 'sub_services' => 'required'
        // ]);

        // $department = new Departments();
        // $department->department_name = $request->department_name;
        // // $department->services = $request->services;
        // // $department->sub_services = json_encode($request->sub_services);
        // $department->save();

        // if ($department) {
        //     session()->flash('success', 'Department Added Successfully!');

        //     return redirect()->back();
        // } else {
        //     toastr()->error('An error has occurred please try again later.');
        //     //            session()->flash('error', $th->getMessage());
        //     return redirect()->back();
        // }
        $request->validate([
            'name' => 'required|string|max:255',
            'code' => 'nullable|string|max:100|unique:departments,code',
            'description' => 'nullable|string',
        ]);

        try {
            DB::beginTransaction();

            Departments::create([
                'name' => $request->name,
                'code' => $request->code,
                'description' => $request->description,
            ]);

            DB::commit();
            return redirect()->route('departments.index')->with('success', 'Department created successfully.');
        } catch (\Exception $e) {
            DB::rollBack();
            Log::error('Department Store Error: ' . $e->getMessage());
            return redirect()->back()->withInput()->with('error', 'Failed to create department.');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(department $department)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        // $dec_id = \Crypt::decrypt($id);
        // $edit_department = Departments::where('id_departments', $dec_id)->first();
        // $services = OtherService::where('status', 'Active')
        //     ->where('parent_id', null)
        //     ->get();
        // return view('departments.edit', compact('edit_department', 'services'));
        try {

            $id = Crypt::decrypt($id);
            $department = Departments::findOrFail($id);
            return view('departments.edit', compact('department'));
        } catch (\Exception $e) {
            Log::error('Department Edit Error: ' . $e->getMessage());
            return redirect()->route('departments.index')->with('error', 'Department not found.');
        }
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        // //        echo 'working';exit;
        // $request->validate([
        //     'department_name' => 'required',
        // ]);
        // // dd($request);

        // $dec_id = \Crypt::decrypt($request->a_id);

        // //            echo $dec_id;exit;
        // $department = Departments::where('id_departments', $dec_id)->first();
        // //             dd($department);
        // $department->department_name = $request->department_name;
        // // $department->services = $request->services;
        // // $department->sub_services = json_encode($request->sub_services);
        // $department->status = $request->department_status;

        // $department->save();
        // if ($department) {
        //     session()->flash('success', 'Department Updated Successfully!');

        //     return redirect()->back();
        // } else {
        //     toastr()->error('An error has occurred please try again later.');
        //     return redirect()->back();
        // }
        // try {
        $id = Crypt::decrypt($id);
        $department = Departments::findOrFail($id);
        // dd($department);

        $request->validate([
            'name' => 'required|string|max:255',
            'code' => 'nullable|string|max:100|unique:departments,code,' . $department->id,
            'description' => 'nullable|string',
        ]);
        // dd($request->status);
        DB::beginTransaction();

        $department->update([
            'name' => $request->name,
            'code' => $request->code,
            'description' => $request->description,
            'status' => $request->status,
        ]);


        DB::commit();
        return redirect()->route('departments.index')->with('success', 'Department updated successfully.');
        // } catch (\Exception $e) {
        //     DB::rollBack();
        //     Log::error('Department Update Error: ' . $e->getMessage());
        //     return redirect()->back()->withInput()->with('error', 'Failed to update department.');
        // }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        // $department_id = \Crypt::decrypt($id);
        // $destroy_department = Departments::findOrfail($department_id);
        // $destroy_department->delete();
        // session()->flash('success', 'Department Removed!');
        // return back();
        $id = Crypt::decrypt($id);
        try {
            $department = Departments::findOrFail($id);
            $department->delete();
            return redirect()->route('departments.index')->with('success', 'Department deleted successfully.');
        } catch (\Exception $e) {
            Log::error('Department Delete Error: ' . $e->getMessage());
            return redirect()->route('departments.index')->with('error', 'Failed to delete department.');
        }
    }
    public function remove_department_user($user_id, $d_id)
    {
        $dec_user_id = \Crypt::decrypt($user_id);
        // dd($dec_user_id);
        $dec_d_id = \Crypt::decrypt($d_id);
        // dd($dec_d_id);
        $department_team_user = DepartmentTeam::findOrFail($dec_d_id);
        $get_all_users = json_decode($department_team_user->user_id);
        // if(count($get_all_users_count)>0){
        //     $get_all_users = json_decode($department_team_user->user_id);
        // }else{
        //     $get_all_users=$department_team_user->user_id
        // }
        // dd($get_all_users);
        // dd(json_encode($get_all_users));
        // dd(is_array($get_a ll_users));
        if (($key = array_search($dec_user_id, $get_all_users)) !== false) {
            unset($get_all_users[$key]);
        }

        $get_users_ids = [];
        foreach ($get_all_users as $item_user) {
            $get_users_ids[] = $item_user;
        }
        // dd($get_all_users);

        $department_team_user->user_id = json_encode($get_users_ids);
        $department_team_user->save();
        session()->flash('success', 'User Removed!');
        return back();
    }
    public function assign_user_teams(Request $request)
    {
        // dd($request);
        $request->validate([
            'user_id' => 'required',
        ]);
        $update = DepartmentTeam::where('id_department_teams', $request->team_id)->first();
        // dd($update);
        if ($update) {
            $get_table_users = json_decode($update->user_id);
            if ($get_table_users == null) {
                $get_table_users = [];
            }
            // dd($get_table_users);
            $check_user = in_array($request->user_id, $get_table_users);
            if (isset($request->is_head)) {
                $update->head_id = $request->user_id;
                $update->save();
            }

            if (!$check_user) {
                if (isset($request->is_head)) {
                    $update->head_id = $request->user_id;
                    $update->save();
                }
                $get_reqs_user[] = $request->user_id;
                $all_users = array_merge($get_table_users, $get_reqs_user);
                $update->user_id = json_encode($all_users);
                $update->save();

                //    User Teams Update Start
                $user_team = User::where('id', $request->user_id)->first();
                $get_users_team_id = json_decode($user_team->team_id);
                if ($get_users_team_id == null) {
                    $get_users_team_id = [];
                }
                $get_team_id[] = $update->id_department_teams;
                $merge_teams_users = array_merge($get_users_team_id, $get_team_id);
                $user_team->team_id = $merge_teams_users;
                $user_team->save();
                //    User Teams Update End
                session()->flash('success', 'Assign User');
                return back();
            } else {
                session()->flash('warning', 'User Already Added !');
                return back();
            }
        } else {
            session()->flash('error', 'Invalid Details');
            return back();
        }
    }
    public function assign_services_department(Request $request)
    {
        // dd($request);
        $department_id = $request->d_id;
        $department = Departments::find($department_id);
        $services_count = count($request->services);
        // dd($services_count);
        $data = $request->all();
        // dd($data);
        for ($i = 0; $i < $services_count; $i++) {
            // dd($i);
            $services = $data['services'][$i];
            // dd($services);
            if ($i == 0) {
                $store_services = new DepartmentService();
                $store_services->department_id = $department_id;
                $store_services->service_id = $services;
                $store_services->save();
                $service_id = $store_services->id;
                // dd($service_id);
                $store_sub_services = new DepartmentSubService();
                $store_sub_services->departments_id = $department_id;
                $store_sub_services->services_id = $service_id;
                $store_sub_services->sub_services_id = json_encode($data['sub_services']);
                $store_sub_services->save();
            } else {
                $store_services = new DepartmentService();
                $store_services->department_id = $department_id;
                $store_services->service_id = $services;
                $store_services->save();

                $service_id = $store_services->id;

                $store_sub_services = new DepartmentSubService();
                $store_sub_services->departments_id = $department_id;
                $store_sub_services->services_id = $service_id;
                $store_sub_services->sub_services_id = json_encode($data['sub_services' . $i]);
                $store_sub_services->save();
            }
        }

        $department->department_services_id = $store_services->id_department_services;
        $department->save();
        // dd($department);

        session()->flash('success', 'Assign User');
        return back();
    }
    public function add_department_teams(Request $request)
    {
        // dd($request);
        $request->validate([
            'department_teams' => 'required',
        ]);

        $services_count = count($request->services);
        // dd($services_count);
        $data = $request->all();
        // dd($data);
        for ($i = 0; $i < $services_count; $i++) {
            // dd($i);
            $services[] = $data['services'][$i];
            if ($i == 0) {
                $sub_services[] = $services[$i] . '/' . implode(',', $data['sub_services']);
            } else {
                $sub_services[] = $services[$i] . '/' . implode(',', $data['sub_services' . $i]);
            }
        }

        $update = DepartmentTeam::where('team_name', $request->department_teams)->first();
        if ($update) {
            $update->services = json_encode($sub_services);
            $update->department_id = $request->d_id;
            $update->save();
        } else {
            $store = new DepartmentTeam();
            $store->team_name = $request->department_teams;
            $store->services = json_encode($sub_services);
            $store->department_id = $request->d_id;
            $store->save();
        }

        session()->flash('success', 'Team Added Successfully');
        return redirect()->back();
    }
}
