@extends('layouts.master')

@push('css')
@endpush

@section('content')
<?php //echo "<pre>"; print_r($po_data); exit(); ?>
<style type="text/css">
    .tborder {border: 1px solid black !important;}
    table.customtble tbody tr td{
        padding: 0px 5px 0px 5px;
        /*border:1px solid #000;*/
        font-size: 13px;
        color: gray;

    }
    table.customtble thead tr th{
        padding: 0px 5px 0px 5px;
        /*border:1px solid #000;*/
        font-size: 14px;
        font-weight: bold;
    }
    @media print{
        table.customtble thead tr th{
            font-size: 11px;
        }
        table.customtble tbody tr td{
            font-size: 10px;
        }
        body * { visibility: hidden; margin-top: 0px !important;}
        .printableArea, .printableArea *{ visibility: visible !important; }
        table{ border-collapse: collapse;}
        @page {size: landscape}
    }
</style>
<div class="container-fluid">
    <div class="printableArea" id="printableArea">  
        <form id="FormId" class="form-horizontal" method="POST" action="{{ route('topBrandsSale') }}">   
            {{ csrf_field() }}
            <div class="form-horizontal form-body hidden-print">
                <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-default">

                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label for="topbrand" class="col-sm-3 control-label">Top</label>
                                            <div class="col-sm-8">
                                                <select class="form-control" name="topbrand" id="topbrand">
                                                    <option value="3">3</option>
                                                    <option value="5">5</option>
                                                    <option value="10">10</option>
                                                    <option value="15">15</option>
                                                    <option value="20">20</option>
                                                    <option value="25">25</option>
                                                </select>
                                            </div>

                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="fromdate" class="col-sm-3 control-label">From Date</label>
                                            <div class="col-sm-8">
                                                <input type="text" name="fromdate" id="fromdate" class="form-control" autocomplete="false" placeholder="dd/mm/yyyy" value="<?php echo date('d-m-Y', strtotime($fromdate)); ?>" />
                                            </div>

                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="fromdate" class="col-sm-3 control-label">To Date</label>
                                            <div class="col-sm-8">
                                                <input type="text" name="todate" id="todate" class="form-control" autocomplete="false" placeholder="dd/mm/yyyy" value="<?php echo date('d-m-Y', strtotime($todate)); ?>" />
                                            </div>

                                        </div>
                                    </div>
                                    <div class="col-md-1 ">
                                        <button id="submitbutton" type="button" class="btn btn-primary"><i class="fa fa-search"></i> Run</button>
                                    </div>
                                    <div class="col-md-1 col-lg-1 col-sm-1 col-xs-12">
                                        <span class="spin-loader"></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-default">

                    <div class="panel-body">
                        <div class="clearfix">
                            <div class="pull-left ">
                                <!-- <h3 class="logo invoice-logo"><img src='{{asset('plugins/images/'.$business->business_logo)}}' width="200" alt='logo here' /></h3> -->
                            </div>
                        </div>
                        <hr class="hidden">
                        <div class="row">
                            <div class="col-md-12"><h3 class="text-center">Top Brand Sales</h3></div>
                        </div>
                        <div class="row hidden">
                            <div class="col-md-12">
                                <table style=" width: 100%;" cellspacing="0" id="podetailstbl" class="customtble">
                                    <tr>
                                        <td style="width: 50% ">
                                            <p><strong>From </strong>: <span id="fromdateshow"><?php echo date('d-M-Y', strtotime($fromdate)); ?></span>
                                                <br>
                                                <strong>To </strong>: <span id="todateshow"><?php echo date('d-M-Y', strtotime($todate)); ?></span>
                                                <br>
                                                <strong></strong> <span id="mode">&nbsp;</span>
                                            </p>

                                        </td>
                                        <td style="width: 0.5%; border-bottom: none !important; border-top: none !important;"></td>
                                        <td style="width: 50%">
                                            <p><strong>Statement Date: </strong> <?php echo date('d-M-Y'); ?>
                                                <br>
                                                <strong></strong> <span id="mode">&nbsp;</span>
                                                <br>
                                                <strong></strong> <span id="mode">&nbsp;</span>
                                            </p>

                                        </td>
                                    </tr>
                                </table>

                            </div><!-- end col -->
                        </div>
                        <!-- end row -->

                        <div class="m-h-50">&nbsp;</div>
                        <div class="row hidden">
                            <div class="col-md-12">
                                <div class="btn-group m-r-10">
                                    <button data-toggle="dropdown" class="btn btn-default btn-outline dropdown-toggle waves-effect waves-light" type="button">
                                        Show/Hide Columns <span class="caret"></span>
                                    </button>
                                    <ul role="menu" id="shCol" class="dropdown-menu animated lightSpeedIn icheck-list">
                                        
                                        <li>
                                            <div class="ckbox ckbox-primary">
                                                <input class="check" data-checkbox="icheckbox_square-red" type="checkbox" checked="checked" id="checkserial" value="0" >
                                                <label for="checkserial">#</label>
                                            </div>
                                        </li>

                                        <li>
                                            <div class="ckbox ckbox-primary">
                                                <input class="check" data-checkbox="icheckbox_square-red" type="checkbox" checked="checked" id="checkitem" value="1">
                                                <label for="checkitem">Item Name</label>
                                            </div>
                                        </li>

                                         <li>
                                            <div class="ckbox ckbox-primary">
                                                <input class="check" data-checkbox="icheckbox_square-red" type="checkbox" checked="checked" id="checkarticle" value="2">
                                                <label for="checkarticle">Article#</label>
                                            </div>
                                        </li>

                                        <li>
                                            <div class="ckbox ckbox-primary">
                                                <input class="check" data-checkbox="icheckbox_square-red" type="checkbox" checked="checked" id="checksaleman" value="3">
                                                <label for="checksaleman">SalesMan</label>
                                            </div>
                                        </li>
                                        
                                        <li>
                                            <div class="ckbox ckbox-primary">
                                                <input class="check" data-checkbox="icheckbox_square-red" type="checkbox" checked="checked" id="checksaleorder" value="4">
                                                <label for="checksaleorder">Sale Order#</label>
                                            </div>
                                        </li>
                                        
                                        <li>
                                            <div class="ckbox ckbox-primary">
                                                <input class="check" data-checkbox="icheckbox_square-red" type="checkbox" checked="checked" id="checktrans" value="5">
                                                <label for="checktrans">Trans#</label>
                                            </div>
                                        </li>
                                        
                                        <li>
                                            <div class="ckbox ckbox-primary">
                                                <input class="check" data-checkbox="icheckbox_square-red" type="checkbox" checked="checked" id="checktransdate" value="6">
                                                <label for="checktransdate">Trans Date</label>
                                            </div>
                                        </li>
                                        
                                        <li>
                                            <div class="ckbox ckbox-primary">
                                                <input class="check" data-checkbox="icheckbox_square-red" type="checkbox" checked="checked" id="checkqty" value="7">
                                                <label for="checkqty">Qty</label>
                                            </div>
                                        </li>
                                        
                                        <li>
                                            <div class="ckbox ckbox-primary">
                                                <input class="check" data-checkbox="icheckbox_square-red" type="checkbox" checked="checked" id="checkunitprice" value="8">
                                                <label for="checkunitprice">Unit Price</label>
                                            </div>
                                        </li>
                                        
                                        <li>
                                            <div class="ckbox ckbox-primary">
                                                <input class="check" data-checkbox="icheckbox_square-red" type="checkbox" checked="checked" id="checkamount" value="9">
                                                <label for="checkamount">Amount</label>
                                            </div>
                                        </li>
                                        
                                        <li>
                                            <div class="ckbox ckbox-primary">
                                                <input class="check" data-checkbox="icheckbox_square-red" type="checkbox" checked="checked" id="checkdiscount" value="10">
                                                <label for="checkdiscount">Discount</label>
                                            </div>
                                        </li>
                                        
                                        <li>
                                            <div class="ckbox ckbox-primary">
                                                <input class="check" data-checkbox="icheckbox_square-red" type="checkbox" checked="checked" id="checknetamount" value="11">
                                                <label for="checknetamount">NetAmount</label>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="m-h-50">&nbsp;</div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <!-- <table class="table table-bordered m-t-30" id="tblproducts"> -->
                                    <!-- <table id="tblreport" class="table table-bordered customtble"> -->
                                    <table id="tblreport" class="display nowrap table-bordered" cellspacing="0" style="width: 100%;">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Brand</th>
                                                <th>Qty</th>
                                                <th>Amount</th>
                                                <th>Discount</th>
                                                <th>Net Amount</th>
                                            </tr>
                                        </thead>
                                        <tbody><tr><td>Data not found</td><td></td><td></td><td></td><td></td><td></td></tr></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <hr>
                        <div class="hidden-print">
                            <div class="pull-right">
                                <a id="printbutton" href="#" class="btn btn-inverse waves-effect waves-light hidden" onclick='window.print();'  ><i class="fa fa-print"></i></a>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>    
    <!-- end row -->
</div>
<script>
    $(document).ready(function(){
        $('#tblreport').DataTable({
            lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "All"]],
            stateSave: false, 
            fixedHeader: {header: true},
            "bSort" : false,
            dom: "Bfrtlip",
            buttons: [
                {extend: "excel", title: 'Top Brand Sales', filename: 'topBrandSale', exportOptions: { columns: ':visible' }}, 
                {extend: "pdf", title: '<?php echo $business->business_name; ?>\n (Top Brand Sales)', orientation: 'landscape', filename: 'topBrandSale', exportOptions: { columns: ':visible' }},
            ],
            //responsive: !0
        });
        $('#topbrand').select2();
        $('#fromdate').datepicker({
                autoclose: true,
                todayHighlight: true,
                format: "dd-mm-yyyy",
//                viewMode: "months", 
//                minViewMode: "months"
        });

        $('#todate').datepicker({
            autoclose: true,
            todayHighlight: true,
            format: "dd-mm-yyyy",
        });
        var shTable;
        $('#submitbutton').click(function(){
            $('.spin-loader').addClass('fa fa-spin fa-spinner');
            $('#fromdateshow').html('').html($('#fromdate').val());
            $('#todateshow').html('').html($('#todate').val());
            $.ajax({
                type: 'POST',
                url: $('#FormId').attr('action'),
                data: {fromdate: $('#fromdate').val(), todate: $('#todate').val(), topbrand: $('#topbrand option:selected').val()},
                dataType: 'json',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo csrf_token(); ?>'
                },
                success: function(response){
                    var data = response;
                    var body = '';
                    var total_qty = 0, total_price = 0, total_discount = 0, total_netamount = 0; 
                    var hhtml = '<tr><th class="text-center">#</th><th class="text-center">Brand</th><th class="text-center">Qty</th><th class="text-center">Amount</th><th class="text-center">Discount</th><th class="text-center">Net Amount</th></tr></tr>';
                    for(var i = 0; i < data.length; i++){
                        //grand_netamount += parseInt(data[i]['qty']) * (parseFloat(data[i]['gdn_unit_price'])-((parseFloat(data[i]['gdn_unit_price']) * parseFloat(data[i]['gdn_discount_percent']))/100));
                        body += '<tr>';
                        body += '<td class="text-center">'+(i+1)+'</td>';
                        body += '<td>'+data[i]['brand_name']+'</td>';
                        body += '<td class="text-right">'+data[i]['qty']+'</td>';
                        body += '<td class="text-right">'+addCommas(parseFloat(data[i]['price']).toFixed(2))+'</td>';
                        body += '<td class="text-right">'+addCommas(parseFloat(data[i]['discount']).toFixed(2))+'</td>';
                        body += '<td class="text-right">'+addCommas(parseFloat(data[i]['price']-data[i]['discount']).toFixed(2))+'</td>';
                        body += '</tr>';
                        total_qty += parseInt(data[i]['qty']);
                        total_price += parseFloat(data[i]['price']);
                        total_discount += parseFloat(data[i]['discount']);
                        total_netamount += parseFloat(data[i]['price'])-parseFloat(data[i]['discount']);
                    }
                    
                    if(data.length > 0){
                        $('.spin-loader').removeClass('fa fa-spin fa-spinner');
                        var heading = '<tr><td></td><td><strong>Top Brand Sales</strong></td><td></td><td></td><td></td><td></td></tr>';
                        var date = '<tr><td></td><td><strong>From: </strong>'+$('#fromdate').val()+'<strong> To: </strong>'+$('#todate').val()+'</td><td></td><td></td><td></td><td></td></tr>';
                        var total_row = '<tr><td></td><td class="text-right"><strong>Total:</strong></td><td class="text-right">'+addCommas(total_qty)+'</td><td class="text-right">'+addCommas(parseFloat(total_price).toFixed(2))+'</td><td class="text-right">'+addCommas(parseFloat(total_discount).toFixed(2))+'</td><td class="text-right">'+addCommas(parseFloat(total_netamount).toFixed(2))+'</td></tr>';
                        var tbody = heading+date+body+total_row;
                        $("#tblreport").dataTable().fnDestroy();
                        $("#tblreport thead").html('');
                        $("#tblreport tbody").html('');
                        $("#tblreport thead").append(hhtml);
                        $("#tblreport tbody").append(tbody);
                        
                        shTable = $('#tblreport').DataTable({
                            lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "All"]],
                            stateSave: false, 
                            fixedHeader: {header: true},
                            "bSort" : false,
                            dom: "Bfrtlip",
                            buttons: [
                                {extend: "excel", title: 'Top Brand Sales', filename: 'topBrandSale', exportOptions: { columns: ':visible' }}, 
                {extend: "pdf", title: '<?php echo $business->business_name; ?>\n (Top Brand Sales)', orientation: 'landscape', filename: 'topBrandSale', exportOptions: { columns: ':visible' }},
                            ],
                            //responsive: !0
                        });
                    }else{
                        $('.spin-loader').removeClass('fa fa-spin fa-spinner');
                        $("#tblreport").dataTable().fnDestroy();
                        $("#tblreport thead").html('');
                        $("#tblreport tbody").html('');
                        $("#tblreport thead").append(hhtml);
                        $("#tblreport tbody").append('<tr><td>Data not found</td><td></td><td></td><td></td><td></td><td></td></tr>');
                        $('#printbutton').addClass('hidden');
                    }
                }
            });
        });
        
        jQuery('#shCol input').on('click', function() {
            // Get the column API object
            var column = shTable.column($(this).val());
            // Toggle the visibility
            if ($(this).is(':checked')){
                column.visible(true);
            }else{
                column.visible(false);
            }
        });
    });
    function addCommas(nStr)
{
    nStr += '';
    x = nStr.split('.');
    x1 = x[0];
    x2 = x.length > 1 ? '.' + x[1] : '';
    var rgx = /(\d+)(\d{3})/;
    while (rgx.test(x1)) {
        x1 = x1.replace(rgx, '$1' + ',' + '$2');
    }
    return x1 + x2;
}
</script>
@endsection

