@extends('layouts.master')
@section('content')
    <style>
        .iti.iti--allow-dropdown.iti--show-flags {
            width: 100%;
        }
    </style>
    <div class="az-content-breadcrumb">
        <span>Customer list</span>
        <span>Edit Customer</span>
    </div>
    <h2 class="az-content-title" style="display: inline">Edit Customer <span>
            <a href="{{ url('customers') }}" class="btn border" style="float: right"><i class="fa-solid fa-bars-staggered"></i>
                Back to Customer
            </a>
        </span></h2>
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <h5 class="card-title mg-b-20">Edit Customer Details</h5>
                <form method="post" enctype="multipart/form-data"
                    action="{{ url('customers/update/' . \Crypt::encrypt($customers->id_customers)) }}">
                    @if (count($errors) > 0)
                        <div class="p-1">
                            @foreach ($errors->all() as $error)
                                <div class="alert alert-warning alert-danger fade show" role="alert">
                                    {{ $error }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    <div class="row">
                        <div class="col-6">
                            <div class="form-group">
                                <label class="">
                                    Customer Name (English)
                                    <span style="color:red;">*</span>
                                </label>
                                <input type="text" name="customer_name" class="form-control"
                                    value="{{ $customers->customer_name }}" required />
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-group">
                                <label class="" style="float: inline-end;">
                                    کھا تہ
                                </label>
                                <input type="text" name="customer_name_urdu" class="form-control"
                                    value="{{ $customers->customer_name_urdu }}" id="customer_name_urdu" dir="rtl" />
                            </div>
                        </div>
                    </div>

                    <div class="row mt-3">
                        <div class="col-4">
                            <div class="form-group">
                                <label class="">
                                    Customer Email
                                    <span style="color:red;">*</span>
                                </label>
                                <input type="text" name="customer_email" class="form-control"
                                    value="{{ $customers->customer_email }}" />
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group ">
                                <label class="">
                                    Contact Number
                                    <span style="color:red;">*</span>
                                </label>
                                <input type="text" id="whatsapp_number" class="form-control" name="customer_phone"
                                    value="{{ $customers->customer_cell }}">
                                <div class="invalid-feedback1"></div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group">
                                <label class="">Contact - Other /
                                    PTCL / WHATSAPP</label>
                                <input type="text" class="form-control" name="customer_whatsapp"
                                    value="{{ $customers->whatsapp_number }}">
                                <div class="invalid-feedback2"></div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-3">
                        <div class="col-4">
                            <div class="form-group ml-2 mt-2">
                                <label class="">
                                    Opening Balance Dr
                                </label>
                                <input type="text" class="form-control" name="customer_ope_bal_dr"
                                    value="{{ $customers->customer_ope_bal_dr }}">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group ml-2 mt-2">
                                <label class="">
                                    Opening Balance Cr
                                </label>
                                <input type="text" class="form-control" name="customer_ope_bal_cr"
                                    value="{{ $customers->customer_ope_bal_cr }}">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group ml-2 mt-2">
                                <label class="">
                                    Opening Date
                                </label>
                                <input type="text" id="customer_ope_date"  value="{{ $customers->customer_ope_date }}" name="customer_ope_date" class="form-control"
                                            placeholder="dd/mm/yyyy" required />
                                {{-- <input type="date" class="form-control" name="customer_ope_date"
                                    value="{{ $customers->customer_ope_date }}"> --}}
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-3">
                        <div class="col-6">
                            <div class="form-group">
                                <label class="">
                                    Customer Address (English)
                                </label>
                                <input type="text" name="customer_address" class="form-control"
                                    value="{{ $customers->customer_address }}" />
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-group">
                                <label class="">
                                    Customer Address (Urdu)
                                </label>
                                <input type="text" name="customer_address_urdu" class="form-control"
                                    value="{{ $customers->customer_address_urdu }}" id="customer_address_urdu"
                                    dir="rtl" />
                            </div>
                        </div>
                    </div>

                    <div class="row mt-3">
                        <div class="col-4">
                            <div class="form-group ml-2 mt-2">
                                <label class="">Customer
                                    Reference</label>
                                <input type="text" class="form-control" name="customer_reference"
                                    value="{{ $customers->customer_reference }}">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group ml-2 mt-2">
                                <label class="">Remarks
                                    (English)</label>
                                <input type="text" class="form-control" name="customer_remarks"
                                    value="{{ $customers->customer_remarks }}">
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group ml-2 mt-2">
                                <label class="">Remarks
                                    (Urdu)</label>
                                <input type="text" class="form-control" dir="rtl" id="customer_remarks_urdu"
                                    name="customer_remarks_urdu" value="{{ $customers->customer_remarks_urdu }}">
                            </div>
                        </div>
                    </div>

                    <div class="row my-3">
                        <div class="col-6">
                            <div class="form-group ml-2 mt-2">
                                <label class="">Customer
                                    Image</label>
                                <input type="file" class="form-control" name="customer_image" />
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-group ml-2 mt-2">
                                <label class="">Status</label>
                                <select class="form-control" name="customer_status" id="customer_status">
                                    <option value="1" {{ $customers->customer_status == 1 ? 'selected' : '' }}>Active
                                    </option>
                                    <option value="0" {{ $customers->customer_status == 0 ? 'selected' : '' }}>In
                                        Active
                                    </option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="customer_records d-none"></div>
                    <div class="customer_records_dynamic"></div>
                    @csrf

                    <a href="{{ url('customers') }}" class="btn btn-danger btn-block mt-2">
                        Back
                    </a>
                    <button type="submit" class="btn btn-az-primary btn-block mt-2" style="float: right">
                        Submit
                    </button>
                </form>
            </div>
        </div>
    </div>

@endsection

@push('scripts')
    <script>
         $(document).ready(function() {
            $("#customer_ope_date").datepicker({
                dateFormat: "yy-mm-dd" // You can customize the date format here
            });
        });
        document.getElementById('customer_name_urdu').addEventListener('input', function(e) {
            var urduPattern = /[\u0600-\u06FF\u0750-\u077F ]/g;
            var inputValue = e.target.value;

            e.target.value = inputValue.replace(/[^\u0600-\u06FF\u0750-\u077F ]/g, '');
        });

        document.getElementById('customer_address_urdu').addEventListener('input', function(e) {
            var urduPattern = /[\u0600-\u06FF\u0750-\u077F ]/g;
            var inputValue = e.target.value;

            e.target.value = inputValue.replace(/[^\u0600-\u06FF\u0750-\u077F ]/g, '');
        });

        document.getElementById('customer_remarks_urdu').addEventListener('input', function(e) {
            var urduPattern = /[\u0600-\u06FF\u0750-\u077F ]/g;
            var inputValue = e.target.value;

            e.target.value = inputValue.replace(/[^\u0600-\u06FF\u0750-\u077F ]/g, '');
        });
    </script>
@endpush
