@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Supplier Brand</span>
    </div>
    <h2 class="az-content-title" style="display: inline">Supplier Brand<span>
            {{-- @can('Supplier add') --}}
            <a href="{{ route('supplier.brand_create', \Crypt::encrypt($supplier->id_supplier)) }}" class="btn btn-az-primary"
                style="float: right">Add brand</a>
            {{-- @endcan --}}
        </span>
    </h2>
    {{-- <h2 style="float: right" class="az-content-title"></h2> --}}


    {{-- <div class="az-content-body pd-lg-l-40 d-flex flex-column"> --}}
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            {{-- <div class="card card-body pd-40"> --}}

            <div>
                <table id="example2" class="table table-striped">
                    <thead>
                        <tr>
                            <th class="wd-10p">S.No</th>
                            <th class="wd-10p">Supplier Name</th>
                            <th class="wd-10p">Brand Name</th>
                            <th class="wd-10p">Created</th>
                            <th class="wd-10p">Operations</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($supplier_brands as $key => $supplier_brand)
                            <tr>
                                <td>{{ $key + 1 }}</td>
                                <td>{{ $supplier_brand->supplier_name }}</td>
                                <td>{{ $supplier_brand->brands_name }}</td>
                                <td>{{ $supplier_brand->created_at ? date('d-m-Y', strtotime($supplier->created_at)) : 'N/A' }}
                                </td>
                                <td>

                                    <a href="#" class="btn btn-danger" data-toggle="modal" data-target="#deleteModal"
                                        data-id="{{ $supplier_brand->id_supplier_brand }}">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                </td>
                            </tr>
                        @endforeach


                    </tbody>
                    <tfoot>
                        <tr>
                            <th class="wd-10p">S.No</th>
                            <th class="wd-10p">Supplier Name</th>
                            <th class="wd-10p">Brand Name</th>
                            <th class="wd-10p">Created</th>
                            <th class="wd-10p">Operations</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
            {{-- </div> --}}
            <!-- card -->
        </div>
        <!-- col -->
    </div>

    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this Brand?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" action="" method="POST">
                        @csrf
                        @method('POST')
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>




    {{-- </div><!-- az-content-body --> --}}
@endsection

@push('scripts')
    <script>
        function confirmDelete() {
            return confirm('Are you sure you want to delete this supplier?');
        }

        $(function() {
            oTable = $('#example2').DataTable({
                responsive: !0
            });
        });

        $(document).ready(function() {
            $('#deleteModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget);
                var id = button.data('id');
                var actionUrl = '{{ url('supplier/brand_destroy') }}/' + id;
                var modal = $(this);
                modal.find('#deleteForm').attr('action', actionUrl);
            });
        });
    </script>
@endpush
